/*
 *  Copyright 2016 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.contentio.synchronize;

import java.util.List;
import java.util.Map;

import org.slf4j.Logger;

import org.ametys.cms.contenttype.ContentType;
import org.ametys.cms.repository.Content;
import org.ametys.runtime.i18n.I18nizableText;

/**
 * Extension which enables to transform the remote values of a {@link SynchronizableContentsCollection} before synchronizing metadata via {@link #transform(ContentType, Map, Logger)} method
 * and to make some additional operations after synchronization via {@link #additionalOperation(Content, Map, Logger)} method.
 */
public interface SynchronizingContentOperator
{
    /**
     * Get the label of this component
     * @return the label
     */
    public I18nizableText getLabel();
    
    /**
     * Transforms the remote values of a {@link SynchronizableContentsCollection} before synchronizing attributes.
     * @param cType The content type
     * @param remoteValues The remote values to transform
     * @param logger The logger
     * @return The transformed remote values
     */
    public Map<String, List<Object>> transform(ContentType cType, Map<String, List<Object>> remoteValues, Logger logger);
    
    /**
     * Make some additional operations after synchronization
     * @param content The content which was synchronized
     * @param remoteValues The transformed remote values
     * @param logger The logger
     */
    public void additionalOperation(Content content, Map<String, List<Object>> remoteValues, Logger logger);
}
