/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.contentstree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.ametys.cms.contenttype.ContentType;
import org.ametys.cms.contenttype.ContentTypeExtensionPoint;
import org.ametys.cms.contenttype.ContentTypesHelper;
import org.ametys.cms.data.ContentValue;
import org.ametys.cms.repository.Content;
import org.ametys.core.ui.Callable;
import org.ametys.core.util.StringUtils;
import org.ametys.plugins.contentstree.AttributeTreeConfigurationElementsChild;
import org.ametys.plugins.contentstree.TreeConfiguration;
import org.ametys.plugins.contentstree.TreeConfigurationContentType;
import org.ametys.plugins.contentstree.TreeConfigurationElements;
import org.ametys.plugins.contentstree.TreeConfigurationElementsChild;
import org.ametys.plugins.contentstree.TreeExtensionPoint;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.data.holder.ModelAwareDataHolder;
import org.ametys.plugins.repository.data.holder.group.ModelAwareComposite;
import org.ametys.plugins.repository.data.holder.group.ModelAwareRepeater;
import org.ametys.plugins.repository.data.holder.group.ModelAwareRepeaterEntry;
import org.ametys.plugins.repository.model.CompositeDefinition;
import org.ametys.plugins.repository.model.RepeaterDefinition;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.ModelItemContainer;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class ContentsTreeHelper
extends AbstractLogEnabled
implements Component,
Serviceable {
    public static final String ROLE = ContentsTreeHelper.class.getName();
    protected AmetysObjectResolver _ametysResolver;
    protected TreeExtensionPoint _treeExtensionPoint;
    protected ContentTypeExtensionPoint _contentTypesEP;
    protected ContentTypesHelper _contentTypesHelper;

    public void service(ServiceManager smanager) throws ServiceException {
        this._ametysResolver = (AmetysObjectResolver)smanager.lookup(AmetysObjectResolver.ROLE);
        this._treeExtensionPoint = (TreeExtensionPoint)((Object)smanager.lookup(TreeExtensionPoint.ROLE));
        this._contentTypesEP = (ContentTypeExtensionPoint)smanager.lookup(ContentTypeExtensionPoint.ROLE);
        this._contentTypesHelper = (ContentTypesHelper)smanager.lookup(ContentTypesHelper.ROLE);
    }

    public boolean hasChildrenContent(Content content, TreeConfiguration treeConfiguration) {
        return !this.getChildrenContent(content, treeConfiguration).isEmpty();
    }

    public Map<String, List<Content>> getChildrenContent(Content parentContent, TreeConfiguration treeConfiguration) {
        HashMap<String, List<Content>> childrenContent = new HashMap<String, List<Content>>();
        for (String contentTypeId : parentContent.getTypes()) {
            for (TreeConfigurationElements treeConfigurationElements : treeConfiguration.getElements()) {
                for (TreeConfigurationContentType treeConfigurationContentType : treeConfigurationElements.getContentTypesConfiguration()) {
                    if (!treeConfigurationContentType.getContentTypesIds().contains(contentTypeId)) continue;
                    ContentType contentType = (ContentType)this._contentTypesEP.getExtension(contentTypeId);
                    for (TreeConfigurationElementsChild treeConfigurationElementsChild : treeConfigurationElements.getChildren()) {
                        if (treeConfigurationElementsChild instanceof AttributeTreeConfigurationElementsChild) {
                            Map<String, List<Content>> contents = this._handleAttributeTreeConfigurationElementsChild(contentType, (ModelAwareDataHolder)parentContent, (AttributeTreeConfigurationElementsChild)treeConfigurationElementsChild, treeConfiguration);
                            this._merge(childrenContent, contents);
                            continue;
                        }
                        throw new IllegalArgumentException("The child configuration element class <" + treeConfigurationElementsChild + "> is not supported in tree '" + treeConfiguration.getId() + "'");
                    }
                }
            }
        }
        return childrenContent;
    }

    @Callable
    public Map<String, Object> getChildrenContent(String contentId, String treeId) {
        TreeConfiguration treeConfiguration = this._getTreeConfiguration(treeId);
        Content parentContent = this._getParentContent(contentId);
        HashMap<String, Object> infos = new HashMap<String, Object>();
        this._addChildren(parentContent, treeConfiguration, infos);
        infos.putAll(this.getNodeInformations(contentId));
        return infos;
    }

    protected void _addChildren(Content content, TreeConfiguration treeConfiguration, Map<String, Object> infos) {
        Map<String, List<Content>> children = this.getChildrenContent(content, treeConfiguration);
        boolean hasAtLeastOneAutoExpand = this.hasAutoExpandTargets(treeConfiguration);
        ArrayList<Map<String, Object>> childrenInfos = new ArrayList<Map<String, Object>>();
        infos.put("children", childrenInfos);
        for (String attributePath : children.keySet()) {
            for (Content childContent : children.get(attributePath)) {
                boolean expand = hasAtLeastOneAutoExpand && !this.isAnAutoExpandTarget(treeConfiguration, childContent);
                Map<String, Object> childInfo = this.content2Json(childContent);
                childInfo.put("metadataPath", attributePath);
                childInfo.put("expanded", expand);
                if (expand) {
                    this._addChildren(childContent, treeConfiguration, childInfo);
                }
                if (!this.hasChildrenContent(childContent, treeConfiguration)) {
                    childInfo.put("children", Collections.EMPTY_LIST);
                } else {
                    childInfo.put("leaf", false);
                    childInfo.put("isExpanded", false);
                }
                childrenInfos.add(childInfo);
            }
        }
    }

    @Callable
    public List<String> filterChildrenContentByRegExp(String parentContentId, String treeId, String value) {
        ArrayList<String> matchingPaths = new ArrayList<String>();
        Content parentContent = (Content)this._ametysResolver.resolveById(parentContentId);
        TreeConfiguration treeConfiguration = (TreeConfiguration)this._treeExtensionPoint.getExtension(treeId);
        String toMatch = org.apache.commons.lang3.StringUtils.stripAccents((String)value.toLowerCase()).trim();
        Map<String, List<Content>> childrenContentByAttributes = this.getChildrenContent(parentContent, treeConfiguration);
        for (List<Content> childrenContent : childrenContentByAttributes.values()) {
            for (Content childContent : childrenContent) {
                this._getMatchingContents(childContent, toMatch, treeConfiguration, matchingPaths, parentContentId);
            }
        }
        return matchingPaths;
    }

    private void _getMatchingContents(Content content, String value, TreeConfiguration treeConfiguration, List<String> matchingPaths, String parentPath) {
        if (this.isContentMatching(content, value)) {
            matchingPaths.add(parentPath + ";" + content.getId());
        }
        Map<String, List<Content>> childrenContentByAttributes = this.getChildrenContent(content, treeConfiguration);
        for (List<Content> childrenContent : childrenContentByAttributes.values()) {
            for (Content childContent : childrenContent) {
                this._getMatchingContents(childContent, value, treeConfiguration, matchingPaths, parentPath + ";" + content.getId());
            }
        }
    }

    protected boolean isContentMatching(Content content, String value) {
        String title = org.apache.commons.lang3.StringUtils.stripAccents((String)content.getTitle().toLowerCase());
        return title.contains(value);
    }

    @Callable
    public Map<String, Object> getRootNodeInformations(String contentId, String treeId) {
        TreeConfiguration treeConfiguration = this._getTreeConfiguration(treeId);
        Content content = (Content)this._ametysResolver.resolveById(contentId);
        Map<String, Object> nodeInformations = this.content2Json(content);
        nodeInformations.put("id", "root");
        this._addChildren(content, treeConfiguration, nodeInformations);
        return nodeInformations;
    }

    @Callable
    public Map<String, Object> getNodeInformations(String contentId) {
        Content content = (Content)this._ametysResolver.resolveById(contentId);
        return this.content2Json(content);
    }

    protected Map<String, Object> content2Json(Content content) {
        HashMap<String, Object> infos = new HashMap<String, Object>();
        infos.put("id", "random-id-" + StringUtils.generateKey() + "-" + Math.round(Math.random() * 10000.0));
        infos.put("contentId", content.getId());
        infos.put("contenttypesIds", content.getTypes());
        infos.put("name", content.getName());
        infos.put("title", content.getTitle());
        infos.put("iconGlyph", this._contentTypesHelper.getIconGlyph(content));
        infos.put("iconDecorator", this._contentTypesHelper.getIconDecorator(content));
        infos.put("iconSmall", this._contentTypesHelper.getSmallIcon(content));
        infos.put("iconMedium", this._contentTypesHelper.getMediumIcon(content));
        infos.put("iconLarge", this._contentTypesHelper.getLargeIcon(content));
        return infos;
    }

    public Map<String, Object> childContent2Json(Content content, String attributePath) {
        Map<String, Object> childInfo = this.content2Json(content);
        childInfo.put("metadataPath", attributePath);
        return childInfo;
    }

    private void _merge(Map<String, List<Content>> childrenContent, Map<String, List<Content>> contents) {
        for (String key : contents.keySet()) {
            if (!childrenContent.containsKey(key)) {
                childrenContent.put(key, new ArrayList());
            }
            List<Content> contentsList = childrenContent.get(key);
            contentsList.addAll((Collection<Content>)contents.get(key));
        }
    }

    private Map<String, List<Content>> _handleAttributeTreeConfigurationElementsChild(ContentType contentType, ModelAwareDataHolder dataHolder, AttributeTreeConfigurationElementsChild attributeTreeConfigurationElementsChild, TreeConfiguration treeConfiguration) {
        HashMap<String, List<Content>> childrenContent = new HashMap<String, List<Content>>();
        String attributePath = attributeTreeConfigurationElementsChild.getPath();
        try {
            Map<String, List<Content>> contents = this._handleAttribute((ModelItemContainer)contentType, dataHolder, attributePath);
            this._merge(childrenContent, contents);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("An error occured on the tree configuration '" + treeConfiguration.getId() + "' getting for metadata '" + attributePath + "' on content type '" + contentType.getId() + "'", e);
        }
        return childrenContent;
    }

    private Map<String, List<Content>> _handleAttribute(ModelItemContainer modelItemContainer, ModelAwareDataHolder dataHolder, String attributePath) {
        HashMap<String, List<Content>> childrenContent = new HashMap<String, List<Content>>();
        String currentModelItemName = org.apache.commons.lang3.StringUtils.substringBefore((String)attributePath, (String)"/");
        ModelItem currentModelItem = modelItemContainer.getChild(currentModelItemName);
        if (currentModelItem == null) {
            throw new IllegalArgumentException("No attribute definition for " + currentModelItemName);
        }
        if (dataHolder.hasValue(currentModelItemName)) {
            if (currentModelItem instanceof RepeaterDefinition) {
                ModelAwareRepeater repeater = dataHolder.getRepeater(currentModelItemName);
                for (ModelAwareRepeaterEntry entry : repeater.getEntries()) {
                    String subMetadataId = org.apache.commons.lang3.StringUtils.substringAfter((String)attributePath, (String)"/");
                    Map<String, List<Content>> contents = this._handleAttribute((ModelItemContainer)((RepeaterDefinition)currentModelItem), (ModelAwareDataHolder)entry, subMetadataId);
                    this._merge(childrenContent, contents);
                }
            } else if (currentModelItem instanceof CompositeDefinition) {
                ModelAwareComposite metadata = dataHolder.getComposite(currentModelItemName);
                String subMetadataId = org.apache.commons.lang3.StringUtils.substringAfter((String)attributePath, (String)"/");
                Map<String, List<Content>> contents = this._handleAttribute((ModelItemContainer)((CompositeDefinition)currentModelItem), (ModelAwareDataHolder)metadata, subMetadataId);
                this._merge(childrenContent, contents);
            } else if ("content".equals(currentModelItem.getType().getId())) {
                ContentValue[] contentValues;
                for (ContentValue contentValue : contentValues = (ContentValue[])dataHolder.getValue(currentModelItemName)) {
                    String key = currentModelItem.getPath();
                    Optional optContent = contentValue.getContentIfExists();
                    if (optContent.isPresent()) {
                        childrenContent.computeIfAbsent(key, k -> new ArrayList()).add((Content)optContent.get());
                        continue;
                    }
                    this.getLogger().warn("On a data holder, the attribute '{}' is referencing a unexisting content: '{}'", (Object)key, (Object)contentValue.getContentId());
                }
            } else {
                throw new IllegalArgumentException("The metadata definition for " + currentModelItem.getPath() + " is not a content");
            }
        }
        return childrenContent;
    }

    protected TreeConfiguration _getTreeConfiguration(String treeId) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)treeId)) {
            throw new IllegalArgumentException("The tree information cannot be obtain, because 'tree' is null");
        }
        TreeConfiguration treeConfiguration = (TreeConfiguration)this._treeExtensionPoint.getExtension(treeId);
        if (treeConfiguration == null) {
            throw new IllegalArgumentException("There is no tree configuration for '" + treeId + "'");
        }
        return treeConfiguration;
    }

    protected Content _getParentContent(String parentId) throws IllegalArgumentException {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)parentId)) {
            throw new IllegalArgumentException("The tree information cannot be obtain, because 'node' is null");
        }
        try {
            return (Content)this._ametysResolver.resolveById(parentId);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("The tree configuration cannot be used on an object that is not a content: " + parentId, e);
        }
    }

    protected boolean hasAutoExpandTargets(TreeConfiguration treeConfiguration) {
        return treeConfiguration.getElements().stream().map(TreeConfigurationElements::getContentTypesConfiguration).flatMap(Collection::stream).anyMatch(TreeConfigurationContentType::autoExpandTarget);
    }

    protected boolean isAnAutoExpandTarget(TreeConfiguration treeConfiguration, Content content) {
        List<String> contentTypes = Arrays.asList(content.getTypes());
        return treeConfiguration.getElements().stream().map(TreeConfigurationElements::getContentTypesConfiguration).flatMap(Collection::stream).filter(TreeConfigurationContentType::autoExpandTarget).map(TreeConfigurationContentType::getContentTypesIds).anyMatch(ct -> {
            HashSet hs = new HashSet(ct);
            hs.retainAll(contentTypes);
            return hs.size() > 0;
        });
    }
}

