/*
 *  Copyright 2015 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.contentstree;

import java.util.Collection;

/**
 * Bean for a content type
 */
public class TreeConfigurationContentType
{
    /** Can be a root node */
    protected final boolean _canBeRoot;
    /** Will the tree automatically expand node until it leads to such nodes */
    protected boolean _autoExpandTarget;
    /** The content types ids */
    protected final Collection<String> _contentTypesIds;
    /** The message bus type */
    protected final String _messageBusType;
    
    /**
     * Creates the bean
     * @param canBeRoot Can be root?
     * @param autoExpandTarget Will the tree automatically expand node until it leads to such nodes
     * @param contentTypesIds The content type ids
     * @param messageBusType The message bus type
     */
    public TreeConfigurationContentType(boolean canBeRoot, boolean autoExpandTarget, Collection<String> contentTypesIds, String messageBusType)
    {
        _canBeRoot = canBeRoot;
        _autoExpandTarget = autoExpandTarget;
        _contentTypesIds = contentTypesIds;
        _messageBusType = messageBusType;
    }

    /**
     * Can this content type be root
     * @return true if this node can be root
     */
    public boolean canBeRoot()
    {
        return _canBeRoot;
    }
    
    /**
     * Will the tree automatically expand node until it leads to such nodes
     * @return true if should expand until such a node is found
     */
    public boolean autoExpandTarget()
    {
        return _autoExpandTarget;
    }
    
    /**
     * Get the content ids
     * @return the content ids
     */
    public Collection<String> getContentTypesIds()
    {
        return _contentTypesIds;
    }
    
    /**
     * Get the message bus type
     * @return the message bus type
     */
    public String getMessageBusType()
    {
        return _messageBusType;
    }
}
