/*
 *  Copyright 2014 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class is the model for nodes of a contents tree.
 * @private
 */
Ext.define('Ametys.plugins.contentstree.ContentsTreePanel.ContentsTreeModel', {
    extend : 'Ext.data.TreeModel',

    fields : [ 
        { name: 'text', mapping: 'title'},
        'contentId',
        'lang',
        'metadataPath',
        'contenttypesIds',
        'name',
        'title',
        'iconGlyph',
        'iconDecorator',
        'iconSmall',
        'iconMedium',
        'iconLarge', 
        {
            name: 'icon',
            depends: ['iconGlyph', 'iconDecorator', 'iconSmall'],
            calculate: function (data)
            {
                return Ext.isEmpty(data.iconGlyph) && !Ext.isEmpty(data.iconSmall) ? Ametys.CONTEXT_PATH + data.iconSmall : null;
            }
        },
        {
            name: 'iconCls',
            depends: ['iconGlyph', 'iconDecorator'],
            calculate: function (data)
            {
                return Ext.isEmpty(data.iconGlyph) ? null : data.iconGlyph + (Ext.isEmpty(data.iconDecorator) ? '' : ' ' + data.iconDecorator)
            }
        }
	]
});

/**
 * This class is the model for nodes which can be checked of a contents tree.
 * @private
 */
Ext.define('Ametys.plugins.contentstree.ContentsTreePanel.CheckableContentsTreeModel', {
    extend : 'Ext.data.TreeModel',

    fields : [ 
        { name: 'text', mapping: 'title'},
        'contentId',
        'lang',
        'metadataPath',
        'contenttypesIds',
        'name',
        'title',
        'iconGlyph',
        'iconDecorator',
        'iconSmall',
        'iconMedium',
        'iconLarge', 
        {
            name: 'icon',
            depends: ['iconGlyph', 'iconDecorator', 'iconSmall'],
            calculate: function (data)
            {
                return Ext.isEmpty(data.iconGlyph) && !Ext.isEmpty(data.iconSmall) ? Ametys.CONTEXT_PATH + data.iconSmall : null;
            }
        },
        {
            name: 'iconCls',
            depends: ['iconGlyph', 'iconDecorator'],
            calculate: function (data)
            {
                return Ext.isEmpty(data.iconGlyph) ? null : data.iconGlyph + (Ext.isEmpty(data.iconDecorator) ? '' : ' ' + data.iconDecorator)
            }
	   	},
	   	{ name: 'checked', type: 'boolean', defaultValue: false }
	]
});

/**
 * This class is the model for nodes which can be checked (except for the root node) of a contents tree.
 * @private
 */
Ext.define('Ametys.plugins.contentstree.ContentsTreePanel.CheckableExceptRootContentsTreeModel', {
    extend : 'Ext.data.TreeModel',

    fields : [ 
        { name: 'text', mapping: 'title'},
        'contentId',
        'metadataPath',
        'contenttypesIds',
        'name',
        'title',
        'iconGlyph',
        'iconDecorator',
        'iconSmall',
        'iconMedium',
        'iconLarge', 
        {
            name: 'icon',
            depends: ['iconGlyph', 'iconDecorator', 'iconSmall'],
            calculate: function (data)
            {
                return Ext.isEmpty(data.iconGlyph) && !Ext.isEmpty(data.iconSmall) ? Ametys.CONTEXT_PATH + data.iconSmall : null;
            }
        },
        {
            name: 'iconCls',
            depends: ['iconGlyph', 'iconDecorator'],
            calculate: function (data)
            {
                return Ext.isEmpty(data.iconGlyph) ? null : data.iconGlyph + (Ext.isEmpty(data.iconDecorator) ? '' : ' ' + data.iconDecorator)
            }
        },
        {
            name: 'checked', 
            type: 'boolean', 
            convert: function (value, node) 
            {
	            if (node.get('root'))
	            {
	                return null; // no checkbox for root node
	            }
	            else if (value == undefined)
	            {
	                return false;
	            }
	            else
	            {
	                return value;
	            }
            }
        }
    ]
});