/*
 *  Copyright 2015 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.contentstree;

import java.util.Collection;

/**
 * A bean to represent an element of a tree configuration
 */
public class TreeConfigurationElements
{
    /** The collection of content-types info */
    protected Collection<TreeConfigurationContentType> _contentTypesInfos;
    /** The collection of child nodes */
    protected Collection<TreeConfigurationElementsChild> _childNodes;

    /**
     * Creates a tree configuration
     * @param contentTypesInfos the association of content types supported and message bus types (content, simple-content...). At least an empty map.
     * @param childNodes The child nodes of this element. At least an empty collection.
     */
    public TreeConfigurationElements(Collection<TreeConfigurationContentType> contentTypesInfos, Collection<TreeConfigurationElementsChild> childNodes)
    {
        _contentTypesInfos = contentTypesInfos;
        _childNodes = childNodes;
    }
    
    /**
     * Content types infos
     * @return A non-null collection
     */
    public Collection<TreeConfigurationContentType> getContentTypesConfiguration()
    {
        return _contentTypesInfos;
    }
    
    /**
     * Get the list of children for this elements
     * @return A non null list of children
     */
    public Collection<TreeConfigurationElementsChild> getChildren()
    {
        return _childNodes;
    }
}
