/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.datafiller;

import com.opensymphony.workflow.WorkflowException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.ametys.cms.contenttype.ContentType;
import org.ametys.cms.contenttype.ContentTypeExtensionPoint;
import org.ametys.cms.data.RichText;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ContentDAO;
import org.ametys.cms.repository.ModifiableWorkflowAwareContent;
import org.ametys.cms.repository.WorkflowAwareContent;
import org.ametys.core.util.I18nUtils;
import org.ametys.core.util.LambdaUtils;
import org.ametys.core.util.dom.DOMUtils;
import org.ametys.plugins.datafiller.ContentCreationHelper;
import org.ametys.plugins.datafiller.SitemapPopulator;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.data.extractor.xml.ModelAwareXMLValuesExtractor;
import org.ametys.plugins.repository.data.extractor.xml.XMLValuesExtractorAdditionalDataGetter;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.Model;
import org.ametys.runtime.model.View;
import org.ametys.runtime.model.ViewHelper;
import org.ametys.runtime.model.ViewItemContainer;
import org.ametys.runtime.model.type.ElementType;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.web.frontoffice.search.metamodel.impl.ContentReturnable;
import org.ametys.web.repository.page.ContentTypesAssignmentHandler;
import org.ametys.web.repository.page.MetadataAwareSitemapElement;
import org.ametys.web.repository.page.ModifiablePage;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.PageDAO;
import org.ametys.web.repository.page.SitemapElement;
import org.ametys.web.repository.page.ZoneDAO;
import org.ametys.web.repository.page.ZoneItemManager;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.sitemap.Sitemap;
import org.ametys.web.skin.Skin;
import org.ametys.web.skin.SkinTemplate;
import org.ametys.web.skin.SkinTemplateZone;
import org.ametys.web.skin.SkinsManager;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.environment.Context;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.AutoCloseInputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceNotFoundException;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.TraversableSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class GenericContentCreationManager
extends AbstractLogEnabled
implements Component,
Serviceable,
Contextualizable {
    public static final String ROLE = GenericContentCreationManager.class.getName();
    private static final String _FILE_DIRECTORY_CONTENTS_URI = "/WEB-INF/param/datafill/contents";
    private static final String _FILLING_DATA_FOLDER_URI = "plugin:data-filler://filling-data/resources/";
    private ContentTypeExtensionPoint _cTypeEP;
    private ContentTypesAssignmentHandler _cTypeHandler;
    private ContentDAO _contentDAO;
    private Context _context;
    private I18nUtils _i18nUtils;
    private PageDAO _pageDAO;
    private SitemapPopulator _sitemapPopulator;
    private SourceResolver _sourceResolver;
    private SkinsManager _skinsManager;
    private ZoneDAO _zoneDAO;
    private ZoneItemManager _zoneItemManager;
    private ContentCreationHelper _contentCreationHelper;

    public void contextualize(org.apache.avalon.framework.context.Context context) throws ContextException {
        this._context = (Context)context.get((Object)"environment-context");
    }

    public void service(ServiceManager manager) throws ServiceException {
        this._contentCreationHelper = (ContentCreationHelper)((Object)manager.lookup(ContentCreationHelper.ROLE));
        this._contentDAO = (ContentDAO)manager.lookup(ContentDAO.ROLE);
        this._cTypeEP = (ContentTypeExtensionPoint)manager.lookup(ContentTypeExtensionPoint.ROLE);
        this._cTypeHandler = (ContentTypesAssignmentHandler)manager.lookup(ContentTypesAssignmentHandler.ROLE);
        this._i18nUtils = (I18nUtils)manager.lookup(I18nUtils.ROLE);
        this._pageDAO = (PageDAO)manager.lookup(PageDAO.ROLE);
        this._sitemapPopulator = (SitemapPopulator)((Object)manager.lookup(SitemapPopulator.ROLE));
        this._sourceResolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
        this._skinsManager = (SkinsManager)manager.lookup(SkinsManager.ROLE);
        this._zoneDAO = (ZoneDAO)manager.lookup(ZoneDAO.ROLE);
        this._zoneItemManager = (ZoneItemManager)manager.lookup(ZoneItemManager.ROLE);
    }

    public void createGenericContentPages(Sitemap sitemap) throws Exception {
        Collection<Content> createdContents = this._getOrCreateContentsForTestPages(sitemap);
        ModifiablePage autogeneratedSection = this._sitemapPopulator.getOrCreatePage((MetadataAwareSitemapElement)sitemap, "Test des gabarits");
        for (Content content : createdContents) {
            this._createPagesForContent((Page)autogeneratedSection, content);
        }
    }

    private Collection<Content> _getOrCreateContentsForTestPages(Sitemap sitemap) {
        Comparator<Content> comp = Comparator.comparing(Content::getTitle);
        TreeSet<Content> createdContents = new TreeSet<Content>(comp);
        createdContents.addAll(this._getOrCreateSpecificContents(sitemap));
        Pair<Set<String>, Collection<Content>> result = this._getOrCreateUserDefinedContents(sitemap);
        Set overideContentTypeIds = (Set)result.getLeft();
        createdContents.addAll((Collection)result.getRight());
        Set availableContentTypeIds = this._cTypeEP.getExtensionsIds();
        for (String contentTypeID : availableContentTypeIds) {
            ContentType contentType = (ContentType)this._cTypeEP.getExtension(contentTypeID);
            if (contentType.isPrivate() || contentType.isReferenceTable() || contentType.isMixin() || contentType.isAbstract() || overideContentTypeIds.contains(contentTypeID)) continue;
            try {
                Content copyContent;
                Content content = this._getOrCreateGenericContent(contentType, sitemap);
                createdContents.add(content);
                if (!content.hasDefinition("illustration") || (copyContent = this._getOrCreateGenericContentWithoutIllustration(contentType, sitemap)) == null) continue;
                createdContents.add(copyContent);
            }
            catch (Exception e) {
                this.getLogger().warn("Failed to create content for contentType {}", (Object)contentTypeID, (Object)e);
            }
        }
        return createdContents;
    }

    private Set<Content> _getOrCreateSpecificContents(Sitemap sitemap) {
        HashSet<Content> specificContent = new HashSet<Content>();
        try {
            specificContent.add(this._getOrCreateDocbookDemonstratorContent(sitemap));
        }
        catch (WorkflowException e) {
            this.getLogger().warn("Failed to create Docbook demonstrator content");
        }
        try {
            specificContent.add(this._getOrCreateFormDemonstratorContent(sitemap));
        }
        catch (WorkflowException e) {
            this.getLogger().warn("Failed to create rich text with form content");
        }
        return specificContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Content _getOrCreateFormDemonstratorContent(Sitemap sitemap) throws WorkflowException {
        String title = "Richtext avec formulaire";
        String contentName = "richtext-form";
        WorkflowAwareContent content = this._contentCreationHelper.getContent(contentName, sitemap);
        if (content == null) {
            RichText text = new RichText();
            text.setEncoding("UTF-8");
            text.setLastModificationDate(ZonedDateTime.now());
            text.setMimeType("text/xml");
            Source docBookSource = null;
            InputStream is = null;
            try {
                docBookSource = this._sourceResolver.resolveURI("plugin:data-filler://filling-data/resources/richtextWithForm.xml");
                is = docBookSource.getInputStream();
                text.setInputStream(is);
            }
            catch (IOException e) {
                this.getLogger().warn("Can't access richtext demonstrator docbook", (Throwable)e);
            }
            finally {
                this._sourceResolver.release(docBookSource);
                IOUtils.closeQuietly((InputStream)is);
            }
            ContentType articleContentType = (ContentType)this._cTypeEP.getExtension("org.ametys.web.default.Content.article");
            content = this._contentCreationHelper.initializeContent(articleContentType, sitemap, contentName);
            content = this._contentCreationHelper.editContent(content, articleContentType, Map.of("content", text, "title", title));
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Content _getOrCreateDocbookDemonstratorContent(Sitemap sitemap) throws WorkflowException {
        WorkflowAwareContent content;
        block4: {
            String title = "D\u00e9monstrateur Docbook";
            String contentName = "demonstrateur-docbook";
            content = this._contentCreationHelper.getContent(contentName, sitemap);
            if (content != null) break block4;
            RichText text = new RichText();
            Source docBookSource = null;
            InputStream is = null;
            try {
                docBookSource = this._sourceResolver.resolveURI("plugin:data-filler://filling-data/resources/richtextDemonstrator.xml");
                is = docBookSource.getInputStream();
                text.setInputStream(is);
            }
            catch (IOException e) {
                try {
                    this.getLogger().warn("Can't access richtext demonstrator docbook", (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    this._sourceResolver.release(docBookSource);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)is);
                this._sourceResolver.release(docBookSource);
            }
            IOUtils.closeQuietly((InputStream)is);
            this._sourceResolver.release(docBookSource);
            text.setEncoding("UTF-8");
            text.setLastModificationDate(ZonedDateTime.now());
            text.setMimeType("text/xml");
            ContentType articleContentType = (ContentType)this._cTypeEP.getExtension("org.ametys.web.default.Content.article");
            content = this._contentCreationHelper.initializeContent(articleContentType, sitemap, contentName);
            content = this._contentCreationHelper.editContent(content, articleContentType, Map.of("content", text, "title", title));
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pair<Set<String>, Collection<Content>> _getOrCreateUserDefinedContents(Sitemap sitemap) {
        HashSet<String> overideContentTypeIds = new HashSet<String>();
        HashSet<Content> userContents = new HashSet<Content>();
        TraversableSource contentDir = null;
        try {
            contentDir = (TraversableSource)this._sourceResolver.resolveURI("context://WEB-INF/param/datafill/contents");
            if (!contentDir.exists()) {
                Pair pair = Pair.of(overideContentTypeIds, Set.of());
                return pair;
            }
            if (!contentDir.isCollection()) {
                throw new IllegalStateException("Root folder for the user defined content must be a folder");
            }
            for (TraversableSource contentSource : contentDir.getChildren()) {
                if (contentSource.isCollection()) continue;
                try {
                    Content content = this._getOrCreateContentFromFile((Source)contentSource, sitemap);
                    userContents.add(content);
                    String contentTypeId = content.getTypes()[0];
                    overideContentTypeIds.add(contentTypeId);
                    this.getLogger().info("A user defined configuration for contentType {} was found.", (Object)contentTypeId);
                }
                catch (WorkflowException | IOException | IllegalStateException | ParserConfigurationException | SAXException e) {
                    this.getLogger().error("Failed create content from source {}", (Object)contentSource.getURI(), (Object)e);
                }
            }
        }
        catch (IOException e) {
            this.getLogger().info("No folder of user defined content for datafiller in the instance. Continuing with automatically generated content only.", (Throwable)e);
        }
        finally {
            this._sourceResolver.release((Source)contentDir);
        }
        return Pair.of(overideContentTypeIds, userContents);
    }

    private Content _getOrCreateContentFromFile(Source source, Sitemap sitemap) throws ParserConfigurationException, SourceNotFoundException, IOException, SAXException, WorkflowException {
        String fileName = StringUtils.substringAfterLast((String)source.getURI(), (String)"/");
        String name = StringUtils.substringBefore((String)fileName, (String)".xml");
        String contentTypeId = this._getContentTypeIdForSource(source);
        ContentType contentType = (ContentType)this._cTypeEP.getExtension(contentTypeId);
        if (contentType == null) {
            throw new IllegalStateException("Can't find content type for id: " + contentTypeId);
        }
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        try (InputStream is = source.getInputStream();){
            Content content;
            Document doc = docBuilder.parse(is);
            Element root = doc.getDocumentElement();
            String sitemapName = sitemap.getSitemapName();
            String contentName = String.join((CharSequence)"-", StringUtils.substringAfterLast((String)name, (String)"."), sitemapName);
            Element contentElement = DOMUtils.getChildElementByTagName((Element)root, (String)"content");
            Path imagesDir = Path.of(this._context.getRealPath("/WEB-INF/param/datafill/contents/images"), new String[0]);
            ResourcesAdditionalDataGetter additionalDataGetter = new ResourcesAdditionalDataGetter(this, imagesDir);
            Content content2 = content = this._getOrCreateContentFromXML(contentElement, sitemap, sitemapName, contentType, contentName, additionalDataGetter);
            return content2;
        }
    }

    private Content _getOrCreateContentFromXML(Element root, Sitemap sitemap, String language, ContentType contentType, String contentName, ResourcesAdditionalDataGetter additionalDataGetter) throws WorkflowException {
        WorkflowAwareContent content = this._contentCreationHelper.getContent(contentName, sitemap);
        if (content == null) {
            content = this._contentCreationHelper.initializeContent(contentType, sitemap, contentName);
            ModelAwareXMLValuesExtractor extractor = new ModelAwareXMLValuesExtractor(root, (XMLValuesExtractorAdditionalDataGetter)additionalDataGetter, content.getModel());
            try {
                Map values = extractor.extractValues();
                content = this._contentCreationHelper.editContent(content, contentType, values);
            }
            catch (Exception e) {
                this.getLogger().warn("Failed to extract values from XML for {}", (Object)contentType.getId(), (Object)e);
            }
            ArrayList<String> tags = new ArrayList<String>();
            Element tagsElement = DOMUtils.getChildElementByTagName((Element)root, (String)"tags");
            if (tagsElement != null) {
                List tagElements = DOMUtils.getChildElements((Element)tagsElement);
                for (Element tagElement : tagElements) {
                    tags.add(tagElement.getTagName());
                }
                if (!tags.isEmpty()) {
                    this._contentDAO.tag(List.of(content.getId()), tags, ContentDAO.TagMode.INSERT, new HashMap(), true);
                }
            }
        }
        return content;
    }

    private String _getContentTypeIdForSource(Source source) {
        String fileName = StringUtils.substringAfterLast((String)source.getURI(), (String)"/");
        String name = StringUtils.substringBefore((String)fileName, (String)".xml");
        String contentTypeId = StringUtils.contains((CharSequence)name, (CharSequence)"-") ? StringUtils.substringBefore((String)name, (String)"-") : name;
        return contentTypeId;
    }

    private Content _getOrCreateGenericContent(ContentType contentType, Sitemap sitemap) throws WorkflowException {
        String contentName = contentType.getId();
        WorkflowAwareContent content = this._contentCreationHelper.getContent(contentName, sitemap);
        if (content == null) {
            content = this._contentCreationHelper.initializeContent(contentType, sitemap, contentName);
            View view = ViewHelper.getTruncatedView((View)View.of((Model)contentType));
            Map<String, Object> values = this._contentCreationHelper.getGenericValuesForView((ViewItemContainer)view);
            content = this._contentCreationHelper.editContent(content, contentType, values);
        }
        return content;
    }

    private Content _getOrCreateGenericContentWithoutIllustration(ContentType contentType, Sitemap sitemap) throws AmetysRepositoryException, WorkflowException {
        String contentName = contentType.getId() + "-no-illustration";
        ModifiableWorkflowAwareContent content = (ModifiableWorkflowAwareContent)this._contentCreationHelper.getContent(contentName, sitemap);
        if (content == null) {
            content = (ModifiableWorkflowAwareContent)this._contentCreationHelper.initializeContent(contentType, sitemap, contentName);
            View view = ViewHelper.getTruncatedView((View)View.of((Model)contentType));
            Map<String, Object> values = this._contentCreationHelper.getGenericValuesForView((ViewItemContainer)view);
            content = (ModifiableWorkflowAwareContent)this._contentCreationHelper.editContent((WorkflowAwareContent)content, contentType, values);
            content.setTitle(content.getTitle() + " (no illustration)");
            content.removeValue("illustration");
            content.saveChanges();
        }
        return content;
    }

    private void _createPagesForContent(Page rootPage, Content content) throws Exception {
        boolean noIllustration = StringUtils.contains((CharSequence)content.getName(), (CharSequence)"-no-illustration");
        String contentTypeId = content.getTypes()[0];
        ContentType contentType = (ContentType)this._cTypeEP.getExtension(contentTypeId);
        Site site = rootPage.getSite();
        String language = rootPage.getSitemapName();
        Skin skin = this._skinsManager.getSkin(site.getSkinId());
        Set templates = skin.getTemplates();
        boolean useSearchTemplateForSection = templates.contains("search");
        for (String templateId : templates) {
            if (!this._canCreateTemplate(rootPage.getId(), templateId, templateId)) continue;
            String templateLabel = this._i18nUtils.translate((I18nizable)skin.getTemplate(templateId).getLabel(), language);
            ModifiablePage templateSection = this._sitemapPopulator.getOrCreatePage((MetadataAwareSitemapElement)rootPage, (String)StringUtils.defaultIfBlank((CharSequence)templateLabel, (CharSequence)templateId));
            this._pageDAO.setTemplate(List.of(templateSection.getId()), templateId, false);
            SkinTemplate template = skin.getTemplate(templateId);
            String defaultZoneId = template.getDefaultZoneId();
            for (SkinTemplateZone skinZone : template.getZones().values()) {
                if (!this._cTypeHandler.getAvailableContentTypes((SitemapElement)templateSection, skinZone.getId()).contains(contentType.getId())) continue;
                I18nizableText contentsTitle = new I18nizableText("plugin.data-filler", "PLUGINS_DATA_FILLER_CREATE_TEST_PAGE_CONTENTS_PAGE_TITLE");
                ModifiablePage contentsSection = this._sitemapPopulator.getOrCreatePage((MetadataAwareSitemapElement)templateSection, this._i18nUtils.translate((I18nizable)contentsTitle, language));
                String contentTitle = content.getTitle();
                ModifiablePage contentSection = this._sitemapPopulator.getOrCreatePage((MetadataAwareSitemapElement)contentsSection, contentTitle = StringUtils.substringBefore((String)contentTitle, (String)" (no illustration)"));
                if (contentSection.getTemplate() == null) {
                    this._pageDAO.setTemplate(List.of(contentSection.getId()), useSearchTemplateForSection ? "search" : templateId, false);
                }
                if (contentSection.hasZone(defaultZoneId)) {
                    contentSection.getZone(defaultZoneId).remove();
                }
                HashMap<String, Object> serviceParam = new HashMap<String, Object>();
                serviceParam.put("returnables", ContentReturnable.class.getName());
                serviceParam.put("contentTypes", contentType.getId());
                serviceParam.put("contexts", "{\"sites\":\"{\\\"context\\\":\\\"CURRENT_SITE\\\",\\\"sites\\\":[]}\",\"search-sitemap-context\":\"{\\\"context\\\":\\\"CHILD_PAGES\\\",\\\"page\\\":null}\",\"context-lang\":\"CURRENT\",\"tags\":[]}");
                serviceParam.put("criteria", "{}");
                serviceParam.put("launchSearchAtStartup", false);
                serviceParam.put("initialSorts", "{\"name\":\"common$pertinence\",\"sort\":\"DESC\"}");
                serviceParam.put("rightCheckingMode", "fast");
                serviceParam.put("contentView", contentType.getView("abstract") != null ? "abstract" : "main");
                serviceParam.put("resultPlace", "ABOVE_CRITERIA");
                serviceParam.put("rss", false);
                serviceParam.put("xslt", "pages/services/search/search-default.xsl");
                this._zoneItemManager.addService(contentSection.getId(), defaultZoneId, "org.ametys.web.service.SearchService", serviceParam);
                String viewName = "main";
                String zoneLabel = this._i18nUtils.translate((I18nizable)skinZone.getLabel(), language);
                String pageName = (String)StringUtils.defaultIfBlank((CharSequence)zoneLabel, (CharSequence)skinZone.getId()) + (noIllustration ? " (no illustration)" : "");
                ModifiablePage zonePage = this._sitemapPopulator.getOrCreatePage((MetadataAwareSitemapElement)contentSection, pageName);
                ArrayList<String> pageIds = new ArrayList<String>();
                pageIds.add(zonePage.getId());
                this._pageDAO.setTemplate(pageIds, templateId, false);
                if (zonePage.hasZone(skinZone.getId())) {
                    zonePage.getZone(skinZone.getId()).remove();
                }
                this._zoneDAO.addSharedContent(zonePage.getId(), skinZone.getId(), content.getId(), viewName);
                if (skinZone.getId().equals(defaultZoneId) || !this._cTypeHandler.getAvailableContentTypes((SitemapElement)zonePage, defaultZoneId).contains(contentType.getId())) continue;
                if (zonePage.hasZone(defaultZoneId)) {
                    zonePage.getZone(defaultZoneId).remove();
                }
                this._zoneDAO.addSharedContent(zonePage.getId(), defaultZoneId, content.getId(), viewName);
            }
            this._pageDAO.setBlank(List.of(templateSection.getId()));
        }
    }

    private boolean _canCreateTemplate(String parentId, String pageTitle, String templateId) {
        List availableTemplatesForCreation = this._pageDAO.getAvailableTemplatesForCreation(null, parentId, pageTitle);
        return availableTemplatesForCreation.parallelStream().filter(map -> templateId.equals(map.get("id"))).findAny().isPresent();
    }

    class ResourcesAdditionalDataGetter
    implements XMLValuesExtractorAdditionalDataGetter {
        private Path _path;

        ResourcesAdditionalDataGetter(GenericContentCreationManager this$0, Path path) {
            this._path = path;
        }

        public Optional<Object> getAdditionalData(String dataPath, ElementType type) {
            HashMap fileData = new HashMap();
            if (Files.isDirectory(this._path, new LinkOption[0])) {
                try (Stream<Path> files = Files.list(this._path);){
                    files.forEach(LambdaUtils.wrapConsumer(file -> this._initFile((Path)file, fileData)));
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            return Optional.of(fileData);
        }

        private void _initFile(Path file, Map<String, InputStream> fileData) throws IOException {
            String fileName = file.getFileName().toString();
            AutoCloseInputStream is = ((AutoCloseInputStream.Builder)AutoCloseInputStream.builder().setPath(file)).get();
            fileData.put(fileName, (InputStream)is);
        }
    }
}

