/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.deploystarter;

import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.ametys.core.right.Profile;
import org.ametys.core.right.RightProfilesDAO;
import org.ametys.core.schedule.Runnable;
import org.ametys.core.schedule.Schedulable;
import org.ametys.core.schedule.SchedulableExtensionPoint;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.core.user.directory.ModifiableUserDirectory;
import org.ametys.core.user.directory.UserDirectory;
import org.ametys.core.user.population.UserPopulationDAO;
import org.ametys.core.util.DateUtils;
import org.ametys.plugins.core.impl.schedule.DefaultRunnable;
import org.ametys.plugins.core.schedule.Scheduler;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.plugin.PluginsManager;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.ConfigurationUtil;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.excalibur.source.MoveableSource;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceResolver;
import org.w3c.dom.Element;

public class Init
extends AbstractLogEnabled
implements org.ametys.runtime.plugin.Init,
Serviceable {
    protected SourceResolver _resolver;
    protected UserManager _userManager;
    protected RightProfilesDAO _profilesDAO;
    protected Scheduler _scheduler;
    protected SchedulableExtensionPoint _schedulableEP;

    public void service(ServiceManager manager) throws ServiceException {
        this._resolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
        this._userManager = (UserManager)manager.lookup(UserManager.ROLE);
        if (!PluginsManager.getInstance().isSafeMode()) {
            this._profilesDAO = (RightProfilesDAO)manager.lookup(RightProfilesDAO.ROLE);
            this._scheduler = (Scheduler)manager.lookup(Scheduler.ROLE);
            this._schedulableEP = (SchedulableExtensionPoint)manager.lookup(SchedulableExtensionPoint.ROLE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void init() throws Exception {
        block17: {
            this.getLogger().debug("'start actions' loading...");
            Source source = null;
            Source source2 = null;
            try {
                source = this._resolver.resolveURI("context://WEB-INF/param/start-actions.xml");
                source2 = this._resolver.resolveURI("context://WEB-INF/param/start-actions-" + DateUtils.dateToString((Date)new Date()).replaceAll(":", "").replaceAll("\\+", "") + ".xml");
                if (source.exists()) {
                    Configuration configuration = null;
                    try (InputStream is = source.getInputStream();){
                        configuration = new DefaultConfigurationBuilder().build(is);
                    }
                    ((MoveableSource)source).moveTo(source2);
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("'start actions' file backed up to " + source2.getURI());
                    }
                    this._act(configuration);
                } else {
                    this.getLogger().debug("'start actions' no file found");
                }
                this._resolver.release(source);
            }
            catch (SourceException e) {
                this.getLogger().error("An error occurred before applying 'start actions'", (Throwable)e);
                break block17;
            }
            catch (ResourceNotFoundException e2) {
                this.getLogger().debug("'start actions' no file found");
                break block17;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this._resolver.release(source);
                this._resolver.release(source2);
            }
            this._resolver.release(source2);
        }
        this.getLogger().debug("'start actions' ends");
    }

    protected void _act(Configuration configuration) throws Exception {
        this._actUsersPopulations(configuration.getChild("users-populations"));
        if (!PluginsManager.getInstance().isSafeMode()) {
            this._actRights(configuration.getChild("rights"));
            this._actSchedulables(configuration.getChild("schedulables"));
        }
    }

    protected void _actUsersPopulations(Configuration usersPopulationsConfiguration) throws Exception {
        this.getLogger().debug("'start actions' acting on user populations...");
        for (Configuration usersPopulationConfiguration : usersPopulationsConfiguration.getChildren("users-population")) {
            String populationId = usersPopulationConfiguration.getAttribute("id");
            for (Configuration userConfiguration : usersPopulationConfiguration.getChildren("user")) {
                String login = userConfiguration.getAttribute("login");
                UserDirectory userDirectory = this._userManager.getUserDirectory(populationId, login);
                if (populationId == null) {
                    throw new ConfigurationException("The user '" + UserIdentity.userIdentityToString((UserIdentity)new UserIdentity(login, populationId)) + "' does not exists and thus cannot be modified", userConfiguration);
                }
                if (!(userDirectory instanceof ModifiableUserDirectory)) {
                    throw new ConfigurationException("The user '" + UserIdentity.userIdentityToString((UserIdentity)new UserIdentity(login, populationId)) + "' is not modifiable", userConfiguration);
                }
                HashMap<String, String> modifications = new HashMap<String, String>();
                modifications.put("login", login);
                for (Configuration propertyConfiguration : userConfiguration.getChildren()) {
                    modifications.put(propertyConfiguration.getName(), propertyConfiguration.getValue(""));
                }
                this.getLogger().info("'start actions' updating user {}", (Object)UserIdentity.userIdentityToString((UserIdentity)new UserIdentity(login, populationId)));
                ((ModifiableUserDirectory)userDirectory).update(modifications);
            }
        }
    }

    protected void _actRights(Configuration rightsConfiguration) throws Exception {
        this.getLogger().debug("'start actions' acting on rights...");
        for (Configuration profileConfiguration : rightsConfiguration.getChild("profiles").getChildren("profile")) {
            String profileId = profileConfiguration.getAttribute("id");
            Profile profile = this._profilesDAO.getProfile(profileId);
            if (profile == null) {
                throw new ConfigurationException("Cannot edit profile '" + profileId + "'... it does not exist", profileConfiguration);
            }
            List rights = this._profilesDAO.getRights(profileId);
            for (Configuration removeConfiguration : profileConfiguration.getChildren("remove")) {
                String rightId = removeConfiguration.getAttribute("right");
                rights.remove(rightId);
            }
            this._profilesDAO.updateRights(profile, rights);
        }
    }

    protected void _actSchedulables(Configuration schedulablesConfiguration) throws Exception {
        this.getLogger().debug("'start actions' acting on schedulables...");
        for (Configuration schedulableConfiguration : schedulablesConfiguration.getChildren("schedulable")) {
            String schedulableId = schedulableConfiguration.getAttribute("id");
            Schedulable schedulable = (Schedulable)this._schedulableEP.getExtension(schedulableId);
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            Map schedulableParams = schedulable.getParameters();
            Configuration parametersConfiguration = schedulableConfiguration.getChild("params");
            Element parametersElt = ConfigurationUtil.toElement((Configuration)parametersConfiguration);
            for (Configuration parameterConfiguration : schedulableConfiguration.getChild("params").getChildren()) {
                String parameterName = parameterConfiguration.getName();
                if (!schedulableParams.containsKey(parameterName)) continue;
                ElementDefinition definition = (ElementDefinition)schedulableParams.get(parameterName);
                String parameterType = parameterConfiguration.getAttribute("type", "");
                Object parameterValue = parameterType.equals("config") ? Config.getInstance().getValue(parameterConfiguration.getValue()) : definition.getType().valueFromXML(parametersElt, parameterName, Optional.empty());
                parameters.put(parameterName, parameterValue);
            }
            DefaultRunnable deployJob = new DefaultRunnable("deploy-starter-" + System.currentTimeMillis(), new I18nizableText("plugin.deploy-starter", "PLUGINS_DEPLOY_STARTER_SCHEDULABLE"), new I18nizableText(""), Runnable.FireProcess.NOW, null, schedulable.getId(), true, true, false, null, false, UserPopulationDAO.SYSTEM_USER_IDENTITY, parameters);
            this._scheduler.scheduleJob((Runnable)deployJob);
        }
    }
}

