/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.externaldata.transformation;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.ametys.cms.repository.Content;
import org.ametys.cms.transformation.AbstractEnhancementHandler;
import org.ametys.plugins.externaldata.data.DataInclusionException;
import org.ametys.plugins.externaldata.data.DataSourceFactory;
import org.ametys.plugins.externaldata.data.DataSourceFactoryExtensionPoint;
import org.ametys.plugins.externaldata.data.Query;
import org.ametys.plugins.externaldata.data.QueryDao;
import org.ametys.plugins.externaldata.data.QueryResult;
import org.ametys.plugins.externaldata.data.QueryResultRow;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.PluginAware;
import org.ametys.web.URIPrefixHandler;
import org.ametys.web.renderingcontext.RenderingContext;
import org.ametys.web.renderingcontext.RenderingContextHandler;
import org.ametys.web.repository.content.WebContent;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class DataInclusionEnhancementHandler
extends AbstractEnhancementHandler
implements Component,
Serviceable,
Contextualizable,
PluginAware {
    public static final String ROLE = DataInclusionEnhancementHandler.class.getName();
    private static final String _QUERY_TAG = "dataquery";
    private static final String _ID_ATTR = "id";
    private static final String _PARAMETER_PREFIX = "param-";
    protected QueryDao _queryDao;
    protected Context _context;
    protected String _pluginName;
    protected Logger _logger;
    private RenderingContextHandler _renderingContextHandler;
    private URIPrefixHandler _prefixHandler;
    private DataSourceFactoryExtensionPoint _dataSourceFactoryEP;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this._queryDao = (QueryDao)serviceManager.lookup(QueryDao.ROLE);
        this._dataSourceFactoryEP = (DataSourceFactoryExtensionPoint)((Object)serviceManager.lookup(DataSourceFactoryExtensionPoint.ROLE));
        this._renderingContextHandler = (RenderingContextHandler)serviceManager.lookup(RenderingContextHandler.ROLE);
        this._prefixHandler = (URIPrefixHandler)serviceManager.lookup(URIPrefixHandler.ROLE);
    }

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public void setPluginInfo(String pluginName, String featureName, String id) {
        this._pluginName = pluginName;
    }

    public void enableLogging(Logger logger) {
        this._logger = logger;
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        block14: {
            if (_QUERY_TAG.equals(localName)) {
                Request request = ContextHelper.getRequest((Context)this._context);
                WebContent content = (WebContent)request.getAttribute(Content.class.getName());
                String contentTitle = content.getTitle();
                String id = atts.getValue(_ID_ATTR);
                String siteName = (String)ContextHelper.getRequest((Context)this._context).getAttribute("site");
                if (siteName == null) {
                    siteName = content.getSiteName();
                }
                try {
                    if (StringUtils.isNotBlank((CharSequence)id)) {
                        Query query = this._queryDao.getQuery(siteName, id);
                        if (query != null) {
                            Map<String, String> parameters = this.getParameters(query, atts);
                            String factoryId = query.getFactory();
                            DataSourceFactory dsFactory = (DataSourceFactory)this._dataSourceFactoryEP.getExtension(factoryId);
                            Object result = dsFactory.execute(query, parameters);
                            if (result != null) {
                                if (query.getResultType().equals((Object)Query.ResultType.MULTIPLE)) {
                                    this._saxResult(query, (QueryResult)result);
                                } else {
                                    this._saxSingleResult(query, (QueryResult)result);
                                }
                            }
                        } else {
                            this._logger.error("The query of id '" + id + "' is included in the content of title '" + contentTitle + "' but was deleted.");
                            RenderingContext currentContext = this._renderingContextHandler.getRenderingContext();
                            if (currentContext == RenderingContext.BACK) {
                                String iconPath = this._prefixHandler.getUriPrefix() + "/plugins/" + this._pluginName + "/resources/img/content/edition/data-error.png";
                                this.saxError(new I18nizableText("plugin." + this._pluginName, "PLUGINS_EXTERNAL_DATA_ERROR_TITLE"), new I18nizableText("plugin." + this._pluginName, "PLUGINS_EXTERNAL_DATA_ERROR_NONEXISTING_QUERY"), iconPath);
                            }
                        }
                    } else {
                        this._logger.error("Query ID must be provided.");
                        RenderingContext currentContext = this._renderingContextHandler.getRenderingContext();
                        if (currentContext == RenderingContext.BACK) {
                            String iconPath = this._prefixHandler.getUriPrefix() + "/plugins/" + this._pluginName + "/resources/img/content/edition/data-error.png";
                            this.saxError(new I18nizableText("plugin." + this._pluginName, "PLUGINS_EXTERNAL_DATA_ERROR_TITLE"), new I18nizableText("plugin." + this._pluginName, "PLUGINS_EXTERNAL_DATA_ERROR_NO_ID"), iconPath);
                        }
                    }
                    break block14;
                }
                catch (DataInclusionException e) {
                    this._logger.error("Error executing the query " + id, (Throwable)e);
                    RenderingContext currentContext = this._renderingContextHandler.getRenderingContext();
                    if (currentContext == RenderingContext.BACK) {
                        String iconPath = this._prefixHandler.getUriPrefix() + "/plugins/" + this._pluginName + "/resources/img/content/edition/data-error.png";
                        this.saxError(new I18nizableText("plugin." + this._pluginName, "PLUGINS_EXTERNAL_DATA_ERROR_TITLE"), new I18nizableText("plugin." + this._pluginName, "PLUGINS_EXTERNAL_DATA_QUERY_EXECUTION_ERROR"), iconPath);
                    }
                    break block14;
                }
            }
            super.startElement(uri, localName, qName, atts);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (!_QUERY_TAG.equals(localName)) {
            super.endElement(uri, localName, qName);
        }
    }

    protected void _saxResult(Query query, QueryResult result) throws SAXException {
        String queryId = query.getId();
        try {
            this._contentHandler.processingInstruction("ametys-unmodifiable", "start");
            AttributesImpl atts = new AttributesImpl();
            atts.addCDATAAttribute("class", "data " + queryId);
            XMLUtils.startElement((ContentHandler)this._contentHandler, (String)"table", (Attributes)atts);
            Collection<String> colNames = result.getColumnNames();
            if (!colNames.isEmpty()) {
                XMLUtils.startElement((ContentHandler)this._contentHandler, (String)"tr");
                for (String columnName : colNames) {
                    XMLUtils.createElement((ContentHandler)this._contentHandler, (String)"th", (String)columnName);
                }
                XMLUtils.endElement((ContentHandler)this._contentHandler, (String)"tr");
            }
            int index = 0;
            for (QueryResultRow row : result) {
                AttributesImpl attr = new AttributesImpl();
                if (index % 2 != 0) {
                    attr.addAttribute("", "class", "class", "CDATA", "odd");
                } else {
                    attr.addAttribute("", "class", "class", "CDATA", "even");
                }
                XMLUtils.startElement((ContentHandler)this._contentHandler, (String)"tr", (Attributes)attr);
                for (String columnName : colNames) {
                    String value = row.get(columnName);
                    XMLUtils.createElement((ContentHandler)this._contentHandler, (String)"td", (String)StringUtils.defaultString((String)value));
                }
                XMLUtils.endElement((ContentHandler)this._contentHandler, (String)"tr");
                ++index;
            }
            XMLUtils.endElement((ContentHandler)this._contentHandler, (String)"table");
            this._contentHandler.processingInstruction("ametys-unmodifiable", "end");
        }
        catch (DataInclusionException e) {
            String message = "Unable to get the query results (query ID : " + queryId + ")";
            this._logger.error(message, (Throwable)e);
            throw new SAXException(message, e);
        }
        finally {
            result.close();
        }
    }

    protected void _saxSingleResult(Query query, QueryResult result) throws SAXException {
        String queryId = query.getId();
        try {
            Collection<String> colNames = result.getColumnNames();
            if (colNames.size() > 0) {
                QueryResultRow row;
                String value;
                String colName = colNames.iterator().next();
                if (result.iterator().hasNext() && StringUtils.isNotBlank((CharSequence)(value = (row = (QueryResultRow)result.iterator().next()).get(colName)))) {
                    AttributesImpl atts = new AttributesImpl();
                    atts.addCDATAAttribute("class", "query " + queryId);
                    XMLUtils.createElement((ContentHandler)this._contentHandler, (String)"span", (Attributes)atts, (String)value);
                }
            }
        }
        catch (DataInclusionException e) {
            String message = "Unable to get the query results (query ID : " + queryId + ")";
            this._logger.error(message, (Throwable)e);
            throw new SAXException(message, e);
        }
        finally {
            result.close();
        }
    }

    protected Map<String, String> getParameters(Query query, Attributes atts) {
        HashMap<String, String> params = new HashMap<String, String>();
        for (String param : query.getParameters().keySet()) {
            String value = atts.getValue(_PARAMETER_PREFIX + param.toLowerCase());
            if (!StringUtils.isNotBlank((CharSequence)value)) continue;
            params.put(param, value);
        }
        return params;
    }
}

