<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2016 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
				xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
				xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
				xmlns:xalan="http://xml.apache.org/xalan"
				xmlns:math="http://exslt.org/math" 
				xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
				extension-element-prefixes="math ametys">
				
	<xsl:import href="service:web://pages/services/common.xsl"/>
	<xsl:import href="plugin:web://stylesheets/helper/common.xsl"/>
    
    <xsl:variable name="service-title" select="string(ametys:serviceParameter('header')/text())"/>
	<xsl:variable name="pagination" select="xalan:nodeset(/search/search-result/pagination)"/>
	<xsl:variable name="uniqueId" select="concat('ud_external_search_', substring-after(math:random(), '.'))"/>   
    
    <!-- Used in common.xsl -->
    <xsl:variable name="common-service-css-class-name">user-directory-external</xsl:variable>
    
    <!-- Used in common.xsl --> 
    <xsl:template name="common-service-head-title">
        <xsl:call-template name="common-service-head-title-content">
            <xsl:with-param name="title" select="$service-title"/>              
        </xsl:call-template>
    </xsl:template> 
    
    <!-- Used in common.xsl --> 
    <xsl:template name="common-service-body-nonempty-content-title">
        <xsl:call-template name="common-service-body-nonempty-content-title-content">
            <xsl:with-param name="title" select="$service-title"/>              
        </xsl:call-template>    
    </xsl:template>
    
    <!-- Used in common.xsl --> 
    <xsl:template name="common-service-body-nonempty-content-content">
   		<xsl:call-template name="search-form"/>
        <xsl:call-template name="search-results"/>
    </xsl:template>
    
    <xsl:template name="search-form">
        <form method="post"  class="search">
            <xsl:for-each select="/search/form/fields/field">
                <xsl:variable name="value" select="/search/form/values/*[local-name() = current()/@id]" />
                
                <div class="field">
                    <div class="label">
                        <label for="search-{$uniqueId}-{@id}"><xsl:value-of select="." /></label>
                    </div>
                    <div class="input">
                        <input type="text" name="external-data-search-{@id}" id="search-{$uniqueId}-{@id}" value="{$value}"/>
                    </div>
                    <div class="field-end"></div>
                </div>
            </xsl:for-each>
        
            <xsl:call-template name="search-form-field-submit"/>
        </form>
    </xsl:template>
    
    <xsl:template name="search-form-field-submit">
         <!-- Template for submit button -->
         <div id="search-submit-{$uniqueId}">
         	<xsl:call-template name="common-utils-input-submit">
               <xsl:with-param name="class-name">search</xsl:with-param>
               <xsl:with-param name="i18nkey" select="'plugin.web:FRONT_MODULE_SEARCH_BUTTON_OK'" />    
               <xsl:with-param name="name" select="'external-data-search-submit'" />                                    
           </xsl:call-template>
         </div>
    </xsl:template>
    
    <xsl:template name="search-results">
        <xsl:if test="/search/search-result">
            <div class="results">
                <xsl:copy-of select="/search/search-result" />
                <xsl:call-template name="pagination" />
            </div>
        </xsl:if>
    </xsl:template>
    
    <!-- +
         | Template for page navigation
         + -->
    <xsl:template name="pagination">
        <form id="reload" method="post" action="{$site-uri-prefix}/{/search/url}#nav" accept-charset="UTF-8">
            <div class="pagination">
                <xsl:call-template name="pagination-input-hidden"/>
                
                <xsl:call-template name="common-utils-pagination-results">
                    <xsl:with-param name="i18nkey" select="'plugin.web:FRONT_MODULE_SEARCH_RESULTS_NO_NB_RESULT'" />
                    <xsl:with-param name="pagination-start" select="$pagination/@start + 1" />
                    <xsl:with-param name="pagination-end" select="$pagination/@end" />
                    <xsl:with-param name="hits-total" select="$pagination/../hits/@total" />
                </xsl:call-template>
            
                <xsl:call-template name="common-utils-pagination">
                    <xsl:with-param name="nbPages" select="count($pagination/page)"/>
                    <xsl:with-param name="current-page" select="xalan:nodeset($pagination/page[@start = ../@start])"/>
                    <xsl:with-param name="hasNbPages" select="false()"/>
                </xsl:call-template>            
            </div>
        </form>
    </xsl:template>
    
    <xsl:template name="pagination-input-hidden" >
        <input type="hidden" name="external-data-search-submit" />
    
        <xsl:for-each select="/search/form/fields/field">
        	<xsl:variable name="value" select="/search/form/values/*[local-name() = current()/@id]" />
            <input type="hidden" name="external-data-search-{@id}" value="{$value}"/>
        </xsl:for-each>
    </xsl:template>
</xsl:stylesheet>
