/*
 *  Copyright 2015 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class is the model for nodes of a datasources tree. See {@link Ametys.plugins.externaldata.DataSourcesTree}
 * @private
 */
 Ext.define('Ametys.plugins.externaldata.DataSourcesTree.DataSourceEntry', { 
	extend: 'Ext.data.Model',
	
	fields: [
		'id',
		'name',
		{
			name: 'text', mapping: 'name', type: 'string'
		},
		'resultType', // For a query, the type (SIMPLE or MULTIPLE) of the result of this query
		'type', // The type of node, can only be 'root', 'dataSourceType', 'datasource' or 'query'
		'dataSourceType',
		'leaf',
		{name: 'isValid', defaultValue: true},
		{
			name: 'iconCls',
			depends: ['type', 'dataSourceType', 'resultType', 'isValid'],
			calculate: function (data)
			{
				if (data.type == 'root')
				{
					return "a-tree-glyph ametysicon-data112";
				}
				else if (data.type == 'dataSourceType')
				{
					return 'a-tree-glyph '+ (data.dataSourceType == 'LDAP' ? "ametysicon-agenda3" : "ametysicon-data110");
				}
				else if (data.type == 'datasource')
				{
					return 'a-tree-glyph datasource decorator-ametysicon-connection ' + (data.dataSourceType == 'LDAP' ? "ametysicon-agenda3" : "ametysicon-data110") +  (data.isValid ? ' valid' : ' invalid');
				}
				else if (data.type == 'query')
				{
					return 'a-tree-glyph '+ (data.resultType == 'SIMPLE' ? "ametysicon-input" : "ametysicon-tables1");
				}
				else
				{
					return '';
				}
			}
		},
		{
			name: 'tooltipGlyphIcon',
			depends: ['type', 'dataSourceType', 'resultType'],
			calculate: function (data)
			{
				if (data.type == 'datasource')
				{
					return data.dataSourceType == 'LDAP' ? "ametysicon-agenda3" : "ametysicon-data110";
				}
				else if (data.type == 'query')
				{
					return data.resultType == 'SIMPLE' ? "ametysicon-input" : "ametysicon-tables1";
				}

				return null;
			}
		},
		{
			name: 'tooltipIconDecorator',
			depends: ['type', 'dataSourceType', 'resultType'],
			calculate: function (data)
			{
				if (data.type == 'datasource')
				{
					return 'decorator-ametysicon-connection';
				}

				return null;
			}
		}
	]
});