/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.extrausermgt.authentication.oidc.endofauthenticationprocess;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.ametys.core.user.population.UserPopulation;
import org.ametys.core.util.JSONUtils;
import org.ametys.core.util.URIUtils;
import org.ametys.plugins.extrausermgt.authentication.oidc.endofauthenticationprocess.EndOfAuthenticationProcess;
import org.ametys.plugins.site.Site;
import org.ametys.plugins.site.SiteInformationCache;
import org.ametys.runtime.authentication.AccessDeniedException;
import org.ametys.runtime.exception.ServiceUnavailableException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.commons.lang3.StringUtils;

public class TemporarySignup
extends EndOfAuthenticationProcess
implements Serviceable {
    private JSONUtils _jsonUtils;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this._jsonUtils = (JSONUtils)serviceManager.lookup(JSONUtils.ROLE);
    }

    private String _buildRedirectURI(Request request, String redirectPage, String email, String firstName, String lastName, String token) {
        StringBuilder uriBuilder = new StringBuilder();
        uriBuilder.append(request.getScheme() + "://").append(request.getServerName());
        if (request.isSecure()) {
            if (request.getServerPort() != 443) {
                uriBuilder.append(":");
                uriBuilder.append(request.getServerPort());
            }
        } else if (request.getServerPort() != 80) {
            uriBuilder.append(":");
            uriBuilder.append(request.getServerPort());
        }
        uriBuilder.append(request.getContextPath());
        uriBuilder.append("/_extra-user-management/temp-signup-callback");
        Object actualRedirectUri = uriBuilder.toString();
        Object redirectUri = redirectPage;
        if (token != null) {
            redirectUri = (String)redirectUri + "?email=" + email;
            redirectUri = (String)redirectUri + "&token=" + token;
            if (firstName != null) {
                redirectUri = (String)redirectUri + "&firstname=" + URIUtils.encodeParameter((String)firstName);
            }
            if (lastName != null) {
                redirectUri = (String)redirectUri + "&lastname=" + URIUtils.encodeParameter((String)lastName);
            }
        }
        actualRedirectUri = (String)actualRedirectUri + "?redirectPage=" + URIUtils.encodeParameter((String)redirectUri);
        return actualRedirectUri;
    }

    private String _buildRequest(String cmsUrl, String siteName, String populationId, String userDirectoryId, String language, String email) {
        Map<String, String> parameters = Map.of("siteName", siteName, "populationID", populationId, "userDirectoryID", userDirectoryId, "language", language, "email", email);
        String requestUri = URIUtils.encodeURI((String)(cmsUrl + "/plugins/web/user-signup/tempSignup"), parameters);
        return requestUri;
    }

    /*
     * Exception decompiling
     */
    private String _temporarySignup(String siteName, String populationId, String userDirectoryId, String language, String email) throws IllegalStateException, ServiceUnavailableException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private SiteInformationCache.SignupPage _getSignupPageInformations(Site site, String language, UserPopulation userPopulation) {
        List signupPages = site.getSignupPages(language);
        if (signupPages != null && signupPages.size() >= 1) {
            for (SiteInformationCache.SignupPage signupPage : signupPages) {
                for (String populationId : signupPage.userDirByPop().keySet()) {
                    if (!StringUtils.equals((CharSequence)userPopulation.getId(), (CharSequence)populationId)) continue;
                    return signupPage;
                }
            }
        }
        return null;
    }

    private SiteInformationCache.SignupPage _getRedirectPageInformations(Request request, Site site, UserPopulation userPopulation) {
        String prefLanguage;
        SiteInformationCache.SignupPage page = null;
        String languageByDefault = "en";
        List languages = site.getLanguages();
        Locale local = request.getLocale();
        if (local != null && (prefLanguage = local.getLanguage()) != null && !prefLanguage.equals(languageByDefault) && languages.contains(prefLanguage) && (page = this._getSignupPageInformations(site, prefLanguage, userPopulation)) != null) {
            return page;
        }
        if (languages.contains(languageByDefault) && (page = this._getSignupPageInformations(site, languageByDefault, userPopulation)) != null) {
            return page;
        }
        for (String language : languages) {
            page = this._getSignupPageInformations(site, language, userPopulation);
            if (page == null) continue;
            return page;
        }
        return page;
    }

    public void unexistingUser(String login, String firstName, String lastName, UserPopulation userPopulation, Redirector redirector, Request request) throws AccessDeniedException, ServiceUnavailableException {
        Site site = (Site)request.getAttribute("site");
        try {
            SiteInformationCache.SignupPage signupPage = this._getRedirectPageInformations(request, site, userPopulation);
            if (signupPage != null) {
                String redirectPageURL = signupPage.url();
                String userPopulationId = userPopulation.getId();
                String userDirectoryId = (String)signupPage.userDirByPop().get(userPopulationId);
                String language = signupPage.lang();
                String siteName = signupPage.siteName();
                if (redirectPageURL != null) {
                    String token = this._temporarySignup(siteName, userPopulationId, userDirectoryId, language, login);
                    redirector.redirect(true, this._buildRedirectURI(request, redirectPageURL, login, firstName, lastName, token));
                }
            }
        }
        catch (IOException | IllegalStateException | AccessDeniedException | ProcessingException e) {
            this.getLogger().error("The user couldn't be redirected to the sign-up page", e);
            throw new AccessDeniedException("The user couldn't be redirected to the sign-up page");
        }
    }
}

