/*
 *  Copyright 2025 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

const IOUtils = Java.type("org.apache.commons.io.IOUtils");
const File = Java.type("java.io.File");

let userPopulations = "ametys-home://config/user-populations.xml";
let dataFolder = org.ametys.runtime.util.AmetysHomeHelper.getAmetysHomeConfig();
let srcFile = new File(dataFolder, "user-populations.xml");

let containsExtraCredentialProviders = Ametys.utils.contains(userPopulations, /<credentialProvider[^>]+modelId="authentication\.CAS"[^>]+>/g)

if (containsExtraCredentialProviders)
{
    var newUriRegexp = new RegExp(/^https?:\/\/[^\s?;#]+(?<!\/)$/);
    let fis = new java.io.FileInputStream(srcFile);
    let fileAsString = IOUtils.toString(fis, "UTF-8");
    
    var serverUrlsMatches = [...fileAsString.matchAll("<authentication\.cas\.serverUrl.*?>(.*?)</authentication\.cas\.serverUrl>")];
    
    for (let serverUrlMatch of serverUrlsMatches)
    {
        if (!newUriRegexp.test(serverUrlMatch[1]))
        {
            throw new Error("One or more CAS credential providers URL are not valid. Check documentation in issue : CMS-12099 to see how to correct it.");
        }
    }
}
