/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.extrausermgt.graph;

import com.azure.core.credential.TokenCredential;
import com.azure.identity.ClientSecretCredential;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.microsoft.graph.serviceclient.GraphServiceClient;
import com.microsoft.graph.users.item.UserItemRequestBuilder;
import com.microsoft.kiota.authentication.AccessTokenProvider;
import com.microsoft.kiota.authentication.AllowedHostsValidator;
import com.microsoft.kiota.authentication.AuthenticationProvider;
import com.microsoft.kiota.authentication.BaseBearerTokenAuthenticationProvider;
import java.net.URI;
import java.util.Map;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.core.util.SessionAttributeProvider;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;

public class GraphClientProvider
extends AbstractLogEnabled
implements Initializable,
Serviceable,
Component {
    public static final String ROLE = GraphClientProvider.class.getName();
    private static final String __SCOPE = "https://graph.microsoft.com/.default";
    private GraphServiceClient _graphClient;
    private CurrentUserProvider _currentUserProvider;
    private SessionAttributeProvider _sessionAttributeProvider;
    private UserManager _userManager;

    public void service(ServiceManager manager) throws ServiceException {
        this._currentUserProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
        this._sessionAttributeProvider = (SessionAttributeProvider)manager.lookup(SessionAttributeProvider.ROLE);
        this._userManager = (UserManager)manager.lookup(UserManager.ROLE);
    }

    public void initialize() {
        if (((Boolean)Config.getInstance().getValue("org.ametys.plugins.extra-user-management.graph.useadmin")).booleanValue()) {
            String appId = (String)Config.getInstance().getValue("org.ametys.plugins.extra-user-management.graph.appid");
            String clientSecret = (String)Config.getInstance().getValue("org.ametys.plugins.extra-user-management.graph.clientsecret");
            String tenant = (String)Config.getInstance().getValue("org.ametys.plugins.extra-user-management.graph.tenant");
            ClientSecretCredential clientSecretCredential = ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId(appId)).clientSecret(clientSecret).tenantId(tenant)).build();
            this._graphClient = new GraphServiceClient((TokenCredential)clientSecretCredential, new String[]{__SCOPE});
        }
    }

    public UserItemRequestBuilder getUserRequestBuilder(UserIdentity userIdentity) throws GraphClientException {
        if (this._graphClient != null) {
            return this._graphClient.users().byUserId(this._getUserPrincipalName(userIdentity));
        }
        if (!userIdentity.equals((Object)this._currentUserProvider.getUser())) {
            throw new GraphClientException(userIdentity.toString() + " is not the current user. A graph client can only be retrieved for the current user");
        }
        return this._sessionAttributeProvider.getSessionAttribute("msal_token").filter(String.class::isInstance).map(String.class::cast).map(this::_getClientFromToken).map(GraphServiceClient::me).orElseThrow(() -> new GraphClientException("The current user " + this._currentUserProvider.getUser().toString() + "is not logged with Entra ID."));
    }

    public GraphServiceClient getGraphClient() throws GraphClientException {
        if (this._graphClient != null) {
            return this._graphClient;
        }
        return this._sessionAttributeProvider.getSessionAttribute("msal_token").filter(String.class::isInstance).map(String.class::cast).map(this::_getClientFromToken).orElseThrow(() -> new GraphClientException("The current user " + this._currentUserProvider.getUser().toString() + "is not logged with Entra ID."));
    }

    private GraphServiceClient _getClientFromToken(String token) {
        AccessTokenAuthenticationProvider accessTokenAuthenticationProvider = new AccessTokenAuthenticationProvider(token);
        return new GraphServiceClient((AuthenticationProvider)new BaseBearerTokenAuthenticationProvider((AccessTokenProvider)accessTokenAuthenticationProvider));
    }

    private String _getUserPrincipalName(UserIdentity userIdentity) throws GraphClientException {
        if ("email".equals(Config.getInstance().getValue("org.ametys.plugins.extra-user-management.graph.authmethod"))) {
            User user = this._userManager.getUser(userIdentity);
            String email = user.getEmail();
            if (StringUtils.isBlank((CharSequence)email)) {
                throw new GraphClientException("The user '" + userIdentity.toString() + "' has no email address set, thus exchange cannot be contacted using 'email' authentication method");
            }
            return email;
        }
        return userIdentity.getLogin();
    }

    public static class GraphClientException
    extends Exception {
        public GraphClientException(String message) {
            super(message);
        }
    }

    private static class AccessTokenAuthenticationProvider
    implements AccessTokenProvider {
        private String _accessToken;

        public AccessTokenAuthenticationProvider(String accessToken) {
            this._accessToken = accessToken;
        }

        public String getAuthorizationToken(URI uri, Map<String, Object> additionalAuthenticationContext) {
            return this._accessToken;
        }

        public AllowedHostsValidator getAllowedHostsValidator() {
            return null;
        }
    }
}

