/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.extrausermgt.users.entraid;

import com.azure.core.credential.TokenCredential;
import com.azure.identity.ClientSecretCredential;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.microsoft.graph.core.requests.IBaseClient;
import com.microsoft.graph.core.tasks.PageIterator;
import com.microsoft.graph.models.User;
import com.microsoft.graph.models.UserCollectionResponse;
import com.microsoft.graph.models.odataerrors.ODataError;
import com.microsoft.graph.serviceclient.GraphServiceClient;
import com.microsoft.kiota.serialization.Parsable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.ametys.core.user.directory.NotUniqueUserException;
import org.ametys.core.user.directory.StoredUser;
import org.ametys.core.user.directory.UserDirectory;
import org.ametys.plugins.core.impl.user.directory.AbstractCachingUserDirectory;
import org.apache.commons.lang3.StringUtils;

public class EntraIDUserDirectory
extends AbstractCachingUserDirectory {
    public static final String ON_PREMISES_SAM_ACCOUNT_NAME = "onPremisesSamAccountName";
    private static final String[] __USER_ATTRIBUTES_SELECT = new String[]{"userPrincipalName", "surname", "givenName", "mail", "onPremisesSamAccountName"};
    private GraphServiceClient _graphClient;
    private String _filter;
    private String _loginAttribute;

    public void init(String id, String udModelId, Map<String, Object> paramValues, String label) throws Exception {
        super.init(id, udModelId, paramValues, label);
        String clientID = (String)paramValues.get("org.ametys.plugins.extrausermgt.users.entraid.appid");
        String clientSecret = (String)paramValues.get("org.ametys.plugins.extrausermgt.users.entraid.clientsecret");
        String tenant = (String)paramValues.get("org.ametys.plugins.extrausermgt.users.entraid.tenant");
        this._filter = (String)paramValues.get("org.ametys.plugins.extrausermgt.users.entraid.filter");
        this._loginAttribute = (String)paramValues.get("org.ametys.plugins.extrausermgt.users.entraid.loginattribute");
        ClientSecretCredential clientSecretCredential = ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId(clientID)).clientSecret(clientSecret).tenantId(tenant)).build();
        this._graphClient = new GraphServiceClient((TokenCredential)clientSecretCredential, new String[0]);
        this.createCaches();
    }

    protected String getCacheTypeLabel() {
        return "EntraID";
    }

    public Collection<StoredUser> getStoredUsers() {
        return this.getStoredUsers(-1, 0, null);
    }

    public List<StoredUser> getStoredUsers(int count, int offset, Map<String, Object> parameters) {
        UserCollectionResponse userCollectionResponse = this._graphClient.users().get(requestConfiguration -> {
            String pattern;
            requestConfiguration.headers.add("ConsistencyLevel", "eventual");
            String string = pattern = parameters != null ? (String)parameters.get("pattern") : null;
            if (StringUtils.isNotEmpty((CharSequence)pattern)) {
                requestConfiguration.queryParameters.search = "\"givenName:" + pattern + "\" OR \"surname:" + pattern + "\" OR \"userPrincipalName:" + pattern + "\"";
            }
            if (count > 0 && count < Integer.MAX_VALUE) {
                requestConfiguration.queryParameters.top = Math.min(count + offset, 999);
            }
            if (StringUtils.isNotEmpty((CharSequence)this._filter)) {
                requestConfiguration.queryParameters.filter = this._filter;
                if (StringUtils.isEmpty((CharSequence)pattern)) {
                    requestConfiguration.queryParameters.count = true;
                }
            }
            requestConfiguration.queryParameters.select = __USER_ATTRIBUTES_SELECT;
        });
        ArrayList<StoredUser> result = new ArrayList<StoredUser>();
        AtomicInteger offsetCounter = new AtomicInteger(offset);
        try {
            new PageIterator.Builder().client((IBaseClient)this._graphClient).collectionPage((Parsable)userCollectionResponse).collectionPageFactory(UserCollectionResponse::createFromDiscriminatorValue).processPageItemCallback(user -> {
                if (offsetCounter.decrementAndGet() <= 0) {
                    this._handleUser((User)user, (List<StoredUser>)result);
                }
                return count <= 0 || result.size() < count;
            }).build().iterate();
        }
        catch (Exception e) {
            this.getLogger().error("Error while fetching users from Entra ID", (Throwable)e);
            return Collections.emptyList();
        }
        return result;
    }

    public String getUserIdentifier(User user) {
        if (ON_PREMISES_SAM_ACCOUNT_NAME.equals(this._loginAttribute)) {
            String samAccountName = user.getOnPremisesSamAccountName();
            if (StringUtils.isNotBlank((CharSequence)samAccountName)) {
                return samAccountName;
            }
            this.getLogger().debug("OnPremisesSamAccountName not available for user {}, falling back to UserPrincipalName", (Object)user.getUserPrincipalName());
            return user.getUserPrincipalName();
        }
        return user.getUserPrincipalName();
    }

    private void _handleUser(User user, List<StoredUser> storedUsers) {
        String userIdentifier = this.getUserIdentifier(user);
        StoredUser storedUser = new StoredUser(userIdentifier, user.getSurname(), user.getGivenName(), user.getMail());
        storedUsers.add(storedUser);
        if (this.isCachingEnabled()) {
            this.getCacheByLogin().put((Object)storedUser.getIdentifier(), (Object)storedUser);
        }
    }

    public StoredUser getStoredUser(String login) {
        if (this.isCachingEnabled() && this.getCacheByLogin().hasKey((Object)login)) {
            StoredUser storedUser = (StoredUser)this.getCacheByLogin().get((Object)login);
            return storedUser;
        }
        StoredUser storedUser = null;
        try {
            User user = null;
            if (ON_PREMISES_SAM_ACCOUNT_NAME.equals(this._loginAttribute)) {
                List users = this._graphClient.users().get(requestConfiguration -> {
                    requestConfiguration.headers.add("ConsistencyLevel", "eventual");
                    requestConfiguration.queryParameters.filter = "onPremisesSamAccountName eq '" + login + "'";
                    requestConfiguration.queryParameters.count = true;
                    requestConfiguration.queryParameters.select = __USER_ATTRIBUTES_SELECT;
                }).getValue();
                if (!users.isEmpty()) {
                    user = (User)users.get(0);
                } else {
                    try {
                        user = this._graphClient.users().byUserId(login).get(requestConfiguration -> {
                            requestConfiguration.queryParameters.select = __USER_ATTRIBUTES_SELECT;
                        });
                        if (user != null && StringUtils.isNotBlank((CharSequence)user.getOnPremisesSamAccountName())) {
                            user = null;
                        }
                    }
                    catch (Exception e) {
                        this.getLogger().debug("User '{}' not found by SAM or UPN", (Object)login, (Object)e);
                    }
                }
            } else {
                user = this._graphClient.users().byUserId(login).get(requestConfiguration -> {
                    requestConfiguration.queryParameters.select = __USER_ATTRIBUTES_SELECT;
                });
            }
            if (user != null) {
                String userIdentifier = this.getUserIdentifier(user);
                storedUser = new StoredUser(userIdentifier, user.getSurname(), user.getGivenName(), user.getMail());
                if (this.isCachingEnabled()) {
                    this.getCacheByLogin().put((Object)storedUser.getIdentifier(), (Object)storedUser);
                }
            }
        }
        catch (ODataError e) {
            if (e.getResponseStatusCode() == 404) {
                this.getLogger().debug("User '{}' not found in EntraID", (Object)login);
            } else {
                this.getLogger().warn("Unable to retrieve user '{}' from EntraID", (Object)login, (Object)e);
            }
        }
        catch (Exception e) {
            this.getLogger().warn("Unable to retrieve user '{}' from EntraID", (Object)login, (Object)e);
        }
        return storedUser;
    }

    public StoredUser getStoredUserByEmail(String email) throws NotUniqueUserException {
        if (StringUtils.isBlank((CharSequence)email)) {
            return null;
        }
        if (this.isCachingEnabled() && this.getCacheByMail().hasKey((Object)email)) {
            StoredUser storedUser = (StoredUser)this.getCacheByMail().get((Object)email);
            return storedUser;
        }
        List users = this._graphClient.users().get(requestConfiguration -> {
            requestConfiguration.headers.add("ConsistencyLevel", "eventual");
            requestConfiguration.queryParameters.filter = "mail eq '" + email + "'";
            requestConfiguration.queryParameters.select = __USER_ATTRIBUTES_SELECT;
        }).getValue();
        if (users.size() == 1) {
            User u = (User)users.get(0);
            String userIdentifier = this.getUserIdentifier(u);
            StoredUser storedUser = new StoredUser(userIdentifier, u.getSurname(), u.getGivenName(), u.getMail());
            if (this.isCachingEnabled()) {
                this.getCacheByMail().put((Object)storedUser.getEmail(), (Object)storedUser);
            }
            return storedUser;
        }
        if (users.isEmpty()) {
            return null;
        }
        throw new NotUniqueUserException("Find " + users.size() + " users matching the email " + email);
    }

    public UserDirectory.CredentialsResult checkCredentials(String login, String password) {
        throw new UnsupportedOperationException("The EntraIDUserDirectory cannot authenticate users");
    }
}

