/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.workspaces.extrausermgt.authentication.oidc;

import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.acting.AbstractAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Session;
import org.apache.cocoon.environment.SourceResolver;

public class OIDCCallbackAction
extends AbstractAction
implements ThreadSafe {
    public static final String CALLBACK_URL = "/_extra-user-management/oidc-callback";

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        Session session = request.getSession(true);
        String redirectUri = (String)session.getAttribute("oidc_actualRedirectUri");
        if (redirectUri == null) {
            throw new IllegalArgumentException("OIDC callback must have a redirect URI");
        }
        String error = request.getParameter("error");
        String errorDescription = request.getParameter("error_description");
        if (error != null || errorDescription != null) {
            this.getLogger().warn(String.format("Received an error from OpenID provider. Redirecting to initial URI. Error: %s %nErrorDescription: %s", error, errorDescription));
            redirector.redirect(true, redirectUri);
        } else {
            String queryString = request.getQueryString();
            String actualRedirectUri = redirectUri.contains("?") ? redirectUri + "&" + queryString : redirectUri + "?" + queryString;
            redirector.redirect(true, actualRedirectUri);
        }
        return EMPTY_MAP;
    }
}

