/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

let userPopulations = "ametys-home://config/user-populations.xml"

let containsEntraCredentialProviders = Ametys.utils.contains(userPopulations, /<credentialProvider[^>]+modelId="authentication\.EntraID"[^>]+>/g)
let containsLoginAttributeParameter = Ametys.utils.contains(userPopulations, /(<authentication\.entraid\.loginattribute)/g)

if (containsEntraCredentialProviders && !containsLoginAttributeParameter)
{
    Ametys.utils.searchAndReplace(userPopulations, 
        /(<credentialProvider[^>]+modelId="authentication\.EntraID"[^>]+>)/g,
        '$1<authentication.entraid.loginattribute>userPrincipalName</authentication.entraid.loginattribute>');
}
