/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.extrausermgt.authentication.kerberos;

import com.google.common.net.InetAddresses;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.ametys.plugins.extrausermgt.authentication.kerberos.KerberosCredentialProvider;
import org.ametys.runtime.model.checker.ItemChecker;
import org.ametys.runtime.model.checker.ItemCheckerTestFailureException;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class KerberosChecker
extends AbstractLogEnabled
implements ItemChecker {
    public void check(List<String> values) throws ItemCheckerTestFailureException {
        final String realm = values.get(0);
        String svcLogin = values.get(1);
        String svcPassword = values.get(2);
        String kdc = values.get(3);
        String testDomain = values.get(4);
        final String testLogin = values.get(5);
        final String testPassword = values.get(6);
        try {
            System.setProperty("java.security.krb5.kdc", kdc);
            Configuration loginConfig = null;
            if (System.getProperty("java.security.auth.login.config") == null) {
                loginConfig = new Configuration(this){

                    @Override
                    public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
                        return new AppConfigurationEntry[]{new AppConfigurationEntry("com.sun.security.auth.module.Krb5LoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, Map.of())};
                    }
                };
            }
            LoginContext loginContext = new LoginContext("kerberos-client", null, new CallbackHandler(){

                @Override
                public void handle(Callback[] callbacks) {
                    for (Callback callback : callbacks) {
                        if (callback instanceof NameCallback) {
                            ((NameCallback)callback).setName(testLogin + "@" + realm.toUpperCase());
                            continue;
                        }
                        if (callback instanceof PasswordCallback) {
                            ((PasswordCallback)callback).setPassword(testPassword.toCharArray());
                            continue;
                        }
                        throw new RuntimeException("Invalid callback received during KerberosCredentialProvider initialization");
                    }
                }
            }, loginConfig);
            this.getLogger().debug("***** Authenticating " + testLogin);
            loginContext.login();
            Subject subject = loginContext.getSubject();
            this.getLogger().debug("***** TGT obtained");
            this.getLogger().debug(subject.toString());
            final GSSManager manager = GSSManager.getInstance();
            Callable<GSSCredential> action = new Callable<GSSCredential>(this){

                @Override
                public GSSCredential call() throws GSSException {
                    return manager.createCredential(null, Integer.MAX_VALUE, new Oid("1.3.6.1.5.5.2"), 1);
                }
            };
            GSSCredential gssCredential = Subject.callAs(subject, action);
            String receivedToken = null;
            try {
                receivedToken = this._getToken(manager, testDomain, realm, gssCredential);
            }
            catch (GSSException e) {
                if (e.getMajor() == 13) {
                    String resolvedDomain = null;
                    try {
                        resolvedDomain = InetAddress.getByName(testDomain).getCanonicalHostName();
                    }
                    catch (UnknownHostException ex) {
                        this.getLogger().debug("***** Cannot get ticket for host {} and also fail to resolve", (Object)testDomain, (Object)ex);
                        throw e;
                    }
                    if (InetAddresses.isInetAddress((String)resolvedDomain) || resolvedDomain.equals(testDomain)) {
                        throw e;
                    }
                    this.getLogger().debug("***** Cannot get ticket for host {}, try with {}", (Object)resolvedDomain);
                    receivedToken = this._getToken(manager, resolvedDomain, realm, gssCredential);
                }
                throw e;
            }
            this.getLogger().debug("***** Decoding token");
            LoginContext srvLoginContext = KerberosCredentialProvider.createLoginContext(realm, svcLogin, svcPassword);
            action = new Callable<GSSCredential>(this){

                @Override
                public GSSCredential call() throws GSSException {
                    return manager.createCredential(null, Integer.MAX_VALUE, new Oid("1.3.6.1.5.5.2"), 2);
                }
            };
            gssCredential = Subject.callAs(srvLoginContext.getSubject(), action);
            GSSContext gssContext = GSSManager.getInstance().createContext(gssCredential);
            byte[] token = Base64.getDecoder().decode(receivedToken);
            gssContext.acceptSecContext(token, 0, token.length);
            GSSName gssSrcName = gssContext.getSrcName();
            this.getLogger().debug("***** User authenticated: " + String.valueOf(gssSrcName));
        }
        catch (LoginException | GSSException e) {
            throw new ItemCheckerTestFailureException("Unable to connect to the KDC (" + e.getMessage() + ")", (Throwable)e);
        }
    }

    private String _getToken(GSSManager manager, String host, String realm, GSSCredential gssCredential) throws GSSException {
        this.getLogger().debug("***** Getting ticket for {}", (Object)host);
        GSSName peer = manager.createName("HTTP/" + host + "@" + realm.toUpperCase(), GSSName.NT_USER_NAME);
        GSSContext gssContext = GSSManager.getInstance().createContext(peer, new Oid("1.3.6.1.5.5.2"), gssCredential, Integer.MAX_VALUE);
        byte[] kdcTokenAnswer = gssContext.initSecContext(new byte[0], 0, 0);
        String receivedToken = kdcTokenAnswer != null ? Base64.getEncoder().encodeToString(kdcTokenAnswer) : null;
        this.getLogger().debug("***** Token generated\n{}", (Object)receivedToken);
        return receivedToken;
    }
}

