/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.extrausermgt.authentication.cas;

import java.util.Map;

import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;

/**
 * Action called as callback by CAS server with the Proxy Granting Ticket, when proxying other applications
 */
public class CasProxyGrantingTicketAction extends ServiceableAction
{
    private static final String __PGTIOU_PARAMETER_NAME = "pgtIou";
    private static final String __PGT_PARAMETER_NAME = "pgtId";
    
    private CasProxyGrantingTicketManager _pgtManager;

    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        super.service(smanager);
        _pgtManager = (CasProxyGrantingTicketManager) smanager.lookup(CasProxyGrantingTicketManager.ROLE);
    }
    
    @Override
    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception
    {
        Request request = ObjectModelHelper.getRequest(objectModel);
        String pgtIou = request.getParameter(__PGTIOU_PARAMETER_NAME);
        String pgt = request.getParameter(__PGT_PARAMETER_NAME);
        if (pgtIou != null && pgt != null)
        {
            _pgtManager.save(pgtIou, pgt);
            getLogger().info(String.format("Adding PGT '%s' with PGTIOU '%s'", pgt, pgtIou));
        }
        else
        {
            getLogger().debug("Calling CasProxyGrantingTicketAction with no pgtIou. It may be the first call from CAS to test the url");
        }
        
        return EMPTY_MAP;
    }
}
