/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.extrausermgt.authentication.oidc;

import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.id.Issuer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import org.ametys.plugins.extrausermgt.authentication.oidc.AbstractOIDCCredentialProvider;
import org.ametys.runtime.authentication.AccessDeniedException;

public class GoogleCredentialProvider
extends AbstractOIDCCredentialProvider {
    private final Scope _scopeGg = new Scope(new String[]{"openid", "email", "profile"});

    @Override
    protected void initUrisScope() throws AccessDeniedException {
        try {
            this._authUri = URI.create("https://accounts.google.com/o/oauth2/v2/auth?prompt=consent");
            this._tokenEndpointUri = URI.create("https://oauth2.googleapis.com/token");
            this._iss = new Issuer("https://accounts.google.com");
            this._jwkSetURL = new URI("https://www.googleapis.com/oauth2/v3/certs").toURL();
            this._userInfoEndpoint = URI.create("https://www.googleapis.com/oauth2/v3/userinfo");
            this._scope = this._scopeGg;
        }
        catch (MalformedURLException | URISyntaxException e) {
            this.getLogger().error("Encountered a problem when creating the jwkSetURL", (Throwable)e);
            throw new AccessDeniedException("Encountered a problem when creating the jwkSetURL");
        }
    }
}

