/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.extraction.execution;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.ametys.core.cocoon.JSonReader;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.core.ui.parameter.files.GetParameterFileAction;
import org.ametys.plugins.extraction.execution.Extraction;
import org.ametys.plugins.extraction.execution.ExtractionDAO;
import org.ametys.plugins.extraction.execution.ExtractionDefinitionReader;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.TraversableSource;
import org.apache.excalibur.source.impl.FileSource;

public class GetExtractionDefinitionFilesAction
extends GetParameterFileAction {
    private CurrentUserProvider _currentUserProvider;
    private ExtractionDefinitionReader _definitionReader;
    private ExtractionDAO _extractionDAO;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._currentUserProvider = (CurrentUserProvider)serviceManager.lookup(CurrentUserProvider.ROLE);
        this._definitionReader = (ExtractionDefinitionReader)((Object)serviceManager.lookup(ExtractionDefinitionReader.ROLE));
        this._extractionDAO = (ExtractionDAO)((Object)serviceManager.lookup(ExtractionDAO.ROLE));
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        UserIdentity userIdentity = this._currentUserProvider.getUser();
        Map jsParameters = (Map)objectModel.get("parent-context");
        String profileId = (String)StringUtils.defaultIfEmpty((CharSequence)((String)jsParameters.get("profile")), (CharSequence)Extraction.ExtractionProfile.READ_ACCESS.name());
        if (!EnumUtils.isValidEnum(Extraction.ExtractionProfile.class, (String)profileId.toUpperCase())) {
            throw new IllegalArgumentException("Unexpected profile identifier : " + profileId);
        }
        Extraction.ExtractionProfile profile = Extraction.ExtractionProfile.valueOf(profileId.toUpperCase());
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        String path = Objects.toString(request.getParameter("path"), "");
        String rootURI = this.getRootURI(request);
        TraversableSource rootDir = (TraversableSource)this._srcResolver.resolveURI(rootURI);
        TraversableSource currentDir = (TraversableSource)this._srcResolver.resolveURI(rootURI + (String)(path.length() > 0 ? "/" + path : ""));
        List<Map<String, Object>> nodes = this._fillNodes(currentDir, profile, rootDir, userIdentity);
        HashMap<String, List<Map<String, Object>>> result = new HashMap<String, List<Map<String, Object>>>();
        result.put("nodes", nodes);
        request.setAttribute(JSonReader.OBJECT_TO_READ, result);
        return EMPTY_MAP;
    }

    private List<Map<String, Object>> _fillNodes(TraversableSource currentDir, Extraction.ExtractionProfile profile, TraversableSource rootDir, UserIdentity userIdentity) throws SourceException, Exception {
        ArrayList<Map<String, Object>> nodes = new ArrayList<Map<String, Object>>();
        if (currentDir.exists()) {
            block8: for (TraversableSource child : currentDir.getChildren()) {
                if (this.isIgnoredSource(child)) continue;
                if (child.isCollection()) {
                    Map<String, Object> properties = this._extractionContainer2JsonObject(child, rootDir);
                    switch (profile) {
                        case WRITE_ACCESS: {
                            if (!((Boolean)properties.get("canWrite")).booleanValue() && !this._extractionDAO.hasAnyWritableDescendant(userIdentity, child, true).booleanValue()) continue block8;
                            nodes.add(properties);
                            break;
                        }
                        case RIGHT_ACCESS: {
                            if (!((Boolean)properties.get("canAssignRights")).booleanValue() && !this._extractionDAO.hasAnyAssignableDescendant(userIdentity, child)) continue block8;
                            nodes.add(properties);
                            break;
                        }
                        default: {
                            if (!((Boolean)properties.get("canRead")).booleanValue() && !this._extractionDAO.hasAnyReadableDescendant(userIdentity, child).booleanValue()) continue block8;
                            nodes.add(properties);
                            break;
                        }
                    }
                    continue;
                }
                Extraction extraction = this._definitionReader.readExtractionDefinitionFile(((FileSource)child).getFile());
                switch (profile) {
                    case WRITE_ACCESS: {
                        if (!this._extractionDAO.canWrite(userIdentity, child)) continue block8;
                        nodes.add(this._extraction2JsonObject(extraction, child, rootDir));
                        continue block8;
                    }
                    case RIGHT_ACCESS: {
                        if (!this._extractionDAO.canAssignRights(userIdentity, child)) continue block8;
                        nodes.add(this._extraction2JsonObject(extraction, child, rootDir));
                        continue block8;
                    }
                }
                if (!this._extractionDAO.canRead(userIdentity, child)) continue;
                nodes.add(this._extraction2JsonObject(extraction, child, rootDir));
            }
        }
        return nodes;
    }

    protected String getRootURI(Request request) {
        return "context://WEB-INF/param/extraction/definitions/";
    }

    protected boolean isIgnoredSource(TraversableSource source) {
        return !source.isCollection() && !source.getName().endsWith(".xml");
    }

    private Map<String, Object> _extraction2JsonObject(Extraction extraction, TraversableSource file, TraversableSource root) {
        Map jsonObject = super._resource2JsonObject(file, root);
        jsonObject.putAll(this._extractionDAO.getExtractionProperties(extraction, file));
        return jsonObject;
    }

    private Map<String, Object> _extractionContainer2JsonObject(TraversableSource file, TraversableSource root) {
        Map jsonObject = super._collection2JsonObject(file, root);
        jsonObject.putAll(this._extractionDAO.getExtractionContainerProperties(file));
        return jsonObject;
    }
}

