/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.extraction.execution.pipeline;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import org.ametys.core.cache.AbstractCacheManager;
import org.ametys.core.cache.Cache;
import org.ametys.core.ui.Callable;
import org.ametys.core.util.LambdaUtils;
import org.ametys.core.util.URIUtils;
import org.ametys.plugins.extraction.execution.pipeline.ExtractionMatcher;
import org.ametys.plugins.extraction.execution.pipeline.PipelineDescriptor;
import org.ametys.plugins.extraction.execution.pipeline.PipelineSerializerModel;
import org.ametys.plugins.extraction.execution.pipeline.PipelineSerializerModelExtensionPoint;
import org.ametys.plugins.extraction.execution.pipeline.impl.ConfigurablePipelineDescriptor;
import org.ametys.plugins.extraction.execution.pipeline.impl.NoOpPipelineDescriptor;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.container.ContainerUtil;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.impl.FileSource;
import org.xml.sax.SAXException;

public class PipelineManager
extends AbstractLogEnabled
implements Component,
Serviceable,
Initializable,
Disposable {
    public static final String ROLE = PipelineManager.class.getName();
    private static final String __NO_OP_PIPELINE_ID = NoOpPipelineDescriptor.class.getName() + "*";
    private static final String __PIPELINE_DESCRIPTOR_CACHE = "plugin-extraction.PipelineDescriptor";
    private PipelineDescriptor _noOpPipelineDesc;
    private Map<String, Long> _lastReading = new HashMap<String, Long>();
    private AbstractCacheManager _cacheManager;
    private SourceResolver _resolver;
    private PipelineSerializerModelExtensionPoint _serializerEP;

    public void service(ServiceManager manager) throws ServiceException {
        this._cacheManager = (AbstractCacheManager)manager.lookup(AbstractCacheManager.ROLE);
        this._resolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
        this._serializerEP = (PipelineSerializerModelExtensionPoint)((Object)manager.lookup(PipelineSerializerModelExtensionPoint.ROLE));
    }

    public void initialize() throws Exception {
        PipelineSerializerModel xmlSerializer = (PipelineSerializerModel)this._serializerEP.getExtension("xml");
        this._noOpPipelineDesc = new NoOpPipelineDescriptor(xmlSerializer);
        this._cacheManager.createMemoryCache(__PIPELINE_DESCRIPTOR_CACHE, new I18nizableText("plugin.extraction", "PLUGINS_EXTRACTION_CACHE_PIPELINE_DESCRIPTOR_LABEL"), new I18nizableText("plugin.extraction", "PLUGINS_EXTRACTION_CACHE_PIPELINE_DESCRIPTOR_DESCRIPTION"), true, null);
    }

    public void dispose() {
        this._getPipelineDescriptorCache().invalidateAll();
        this._lastReading.clear();
    }

    public boolean has(String path) throws IOException {
        return this.get(path) != null;
    }

    public PipelineDescriptor get(Path path) throws IOException {
        return this.get(path.toString());
    }

    public PipelineDescriptor get(String path) throws IOException {
        if (__NO_OP_PIPELINE_ID.equals(path)) {
            return this._noOpPipelineDesc;
        }
        return this._readAndGetPipeline(path);
    }

    @Callable(rights={"Extraction_Rights_ExecuteExtraction"})
    public Map<String, Object> getAvailablePipelines(String extractionId) throws IOException {
        if (extractionId != null) {
            String decodedExtractionId = URIUtils.decode((String)extractionId);
            List<Map<String, Object>> enumeration = this._getJsonEnumeration(URIUtils.decode((String)decodedExtractionId));
            return Map.of("pipelines", enumeration);
        }
        return Map.of();
    }

    private List<Map<String, Object>> _getJsonEnumeration(String extractionId) throws IOException {
        ArrayList<Map<String, Object>> enumeration = new ArrayList<Map<String, Object>>();
        this._readAll();
        for (Map.Entry entry : this._getPipelineDescriptorCache().asMap().entrySet()) {
            PipelineDescriptor pipeline = (PipelineDescriptor)entry.getValue();
            ExtractionMatcher matcher = pipeline.getExtractionMatcher();
            if (!matcher.isHandled(extractionId)) continue;
            enumeration.add(Map.of("value", entry.getKey(), "text", pipeline.getLabel()));
        }
        return enumeration;
    }

    public String getDefaultPipeline() {
        return __NO_OP_PIPELINE_ID;
    }

    private synchronized PipelineDescriptor _readAndGetPipeline(String path) throws IOException {
        Pair<String, PipelineDescriptor> readPipeline;
        Path pipelinePath = this._absolutePath(path);
        if (Files.exists(pipelinePath, new LinkOption[0]) && (readPipeline = this._readPipeline(pipelinePath)) != null) {
            PipelineDescriptor pipeline = (PipelineDescriptor)readPipeline.getRight();
            String id = (String)readPipeline.getLeft();
            this._getPipelineDescriptorCache().put((Object)id, (Object)pipeline);
            return pipeline;
        }
        return null;
    }

    private synchronized void _readAll() throws IOException {
        this._readFromFolder(this._absolutePath("")).forEach(pair -> this._getPipelineDescriptorCache().put((Object)((String)pair.getKey()), (Object)((PipelineDescriptor)pair.getValue())));
        this._getPipelineDescriptorCache().put((Object)__NO_OP_PIPELINE_ID, (Object)this._noOpPipelineDesc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Path _absolutePath(String relativePath) throws IOException {
        Path path;
        FileSource pipelinesDirScr = null;
        FileSource src = null;
        try {
            pipelinesDirScr = (FileSource)this._resolver.resolveURI("context://WEB-INF/param/extraction/config/");
            pipelinesDirScr.getFile().mkdirs();
            src = (FileSource)this._resolver.resolveURI("context://WEB-INF/param/extraction/config/" + relativePath);
            File file = src.getFile();
            path = file.toPath();
        }
        catch (Throwable throwable) {
            this._resolver.release((Source)pipelinesDirScr);
            this._resolver.release(src);
            throw throwable;
        }
        this._resolver.release((Source)pipelinesDirScr);
        this._resolver.release((Source)src);
        return path;
    }

    private Stream<Pair<String, PipelineDescriptor>> _readFromFolder(Path folderPath) throws IOException {
        return Files.list(folderPath).map(LambdaUtils.wrap(this::_readFromFile)).flatMap(Function.identity());
    }

    private Stream<Pair<String, PipelineDescriptor>> _readFromFile(Path path) throws IOException {
        return Files.isDirectory(path, new LinkOption[0]) ? this._readFromFolder(path) : Stream.ofNullable(this._readPipeline(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pair<String, PipelineDescriptor> _readPipeline(Path pipelinePath) throws IOException {
        String id = this._getPipelineIdFromAbsolutePath(pipelinePath);
        File pipelineFile = pipelinePath.toFile();
        long lastModified = pipelineFile.lastModified() / 1000L * 1000L;
        if (lastModified > this._lastReading.getOrDefault(id, -1L)) {
            try {
                Configuration conf = new DefaultConfigurationBuilder().buildFromFile(pipelineFile);
                ConfigurablePipelineDescriptor pipeline = new ConfigurablePipelineDescriptor(id, this._resolver, this._serializerEP);
                ContainerUtil.configure((Object)pipeline, (Configuration)conf);
                Pair pair = Pair.of((Object)id, (Object)pipeline);
                return pair;
            }
            catch (IOException | ConfigurationException | SAXException e) {
                this.getLogger().error("File '{}' could not be parsed as an extraction pipeline.", (Object)pipelinePath, (Object)e);
                Pair<String, PipelineDescriptor> pair = null;
                return pair;
            }
            finally {
                this._lastReading.put(id, PipelineManager._now());
            }
        }
        PipelineDescriptor pipeline = (PipelineDescriptor)this._getPipelineDescriptorCache().get((Object)id);
        return pipeline == null ? null : Pair.of((Object)id, (Object)pipeline);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String _getPipelineIdFromAbsolutePath(Path pipelineAbsolutePath) throws IOException {
        FileSource pipelinesDirScr = null;
        try {
            pipelinesDirScr = (FileSource)this._resolver.resolveURI("context://WEB-INF/param/extraction/config/");
            File pipelinesFile = pipelinesDirScr.getFile();
            Path pipelineRelativePath = pipelinesFile.toPath().relativize(pipelineAbsolutePath);
            String string = pipelineRelativePath.toString();
            return string;
        }
        finally {
            this._resolver.release((Source)pipelinesDirScr);
        }
    }

    private static Long _now() {
        return Instant.now().truncatedTo(ChronoUnit.SECONDS).toEpochMilli();
    }

    private Cache<String, PipelineDescriptor> _getPipelineDescriptorCache() {
        return this._cacheManager.get(__PIPELINE_DESCRIPTOR_CACHE);
    }
}

