/*
 *  Copyright 2016 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.extraction;

import java.io.File;

/**
 * Constants related to extraction.
 */
public interface ExtractionConstants
{
    /** Right id to execute extractions */
    public static final String EXECUTE_EXTRACTION_RIGHT_ID = "Extraction_Rights_ExecuteExtraction";
    
    /** Right id to modify extractions */
    public static final String MODIFY_EXTRACTION_RIGHT_ID = "Extraction_Rights_EditExtraction";
    
    /** Path of the base directory for extraction files */
    public static final String BASE_DIR = "context://WEB-INF/param/extraction/";
    
    /** Plugin name to use for I18nizable texts */
    public static final String PLUGIN_NAME = "plugin.extraction";
    
    /** Path of the directory containing definition files */ 
    public static final String DEFINITIONS_DIR = BASE_DIR + "definitions/";
    
    /** Path of the directory containing stylesheets */ 
    public static final String XSLT_DIR = BASE_DIR + "stylesheets/";
    
    /** Path of the directory containing pipelines definitions */ 
    public static final String PIPELINES_DIR = BASE_DIR + "config/";
    
    /** Identifier of the description's content type */
    public static final String DESCRIPTION_CONTENT_TYPE_ID = "org.ametys.plugins.extraction.Content.description";
    
    /** Name of the workflow used by description */
    public static final String DESCRIPTION_CONTENT_WORKFLOW_NAME = "extraction-description";
    
    /** Identifier of the initial action of the description's workflow */
    public static final int DESCRIPTION_CONTENT_INITIAL_ACTION_ID = 1;
    
    /** Message key for the description default title */
    public static final String DESCRIPTION_DEFAULT_TITLE_KEY = "PLUGINS_EXTRACTION_CONTENT_DESCRIPTION_DEFAULT_TITLE";
    
    /** language of the description */
    public static final String DESCRIPTION_LANGUAGE = "fr";
    
    /** extraction tag for definition file */
    public static final String EXTRACTION_TAG = "extraction";
    
    /** description tag */
    public static final String DESCRIPTION_TAG = "description";
    
    /** author tag */
    public static final String AUTHOR_TAG = "author";
    
    /** description identifier attribute name */
    public static final String DESCRIPTION_IDENTIFIER_ATTRIBUTE_NAME = "id";
    
    /** query component tag */
    public static final String QUERY_COMPONENT_TAG = "query";
    
    /** thesaurus component tag */
    public static final String THESAURUS_COMPONENT_TAG = "thesaurus";
    
    /** count component tag */
    public static final String COUNT_COMPONENT_TAG = "count";
    
    /** mapping query component tag */
    public static final String MAPPING_QUERY_COMPONENT_TAG = "mapping-query";
    
    /** clauses variables tag */
    public static final String CLAUSES_VARIABLES_TAG = "clauses-variables";
    
    /** optional columns tag */
    public static final String OPTIONAL_COLUMNS_TAG = "optional-columns";
    
    /** delimiter used in dialog inputs for string collections */
    public static final String STRING_COLLECTIONS_INPUT_DELIMITER = ",";
    
    /** The directory under ametys home data directory for extraction results */
    public static final String RESULT_EXTRACTION_DIR_NAME = "extraction";
    
    /** extraction tag for result file */
    public static final String RESULT_EXTRACTION_TAG = "extraction";
    
    /** the path separator */
    public static final String PATH_SEPARATOR = File.separator;
}
