/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.extraction.component;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import org.ametys.cms.repository.Content;
import org.ametys.cms.search.SortOrder;
import org.ametys.cms.search.cocoon.GroupSearchContent;
import org.ametys.cms.search.content.ContentSearcherFactory;
import org.ametys.cms.search.query.QuerySyntaxException;
import org.ametys.cms.search.ui.model.ColumnHelper;
import org.ametys.core.util.StringUtils;
import org.ametys.plugins.extraction.component.AbstractGroupExtractionComponent;
import org.ametys.plugins.extraction.component.ExtractionColumn;
import org.ametys.plugins.extraction.component.TwoStepsExecutingExtractionComponent;
import org.ametys.plugins.extraction.execution.ExtractionExecutionContext;
import org.ametys.plugins.extraction.execution.ExtractionExecutionContextHierarchyElement;
import org.ametys.runtime.model.ViewItemAccessor;
import org.ametys.runtime.model.ViewItemContainer;
import org.ametys.runtime.model.type.DataContext;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;

public class QueryExtractionComponent
extends AbstractGroupExtractionComponent
implements TwoStepsExecutingExtractionComponent {
    private boolean _overrideColumns;
    private List<ExtractionColumn> _columns = new ArrayList<ExtractionColumn>();
    private boolean _overrideSorts;
    private Map<String, SortOrder> _sortMap = new LinkedHashMap<String, SortOrder>();
    private List<ContentSearcherFactory.ContentSearchSort> _sorts = new ArrayList<ContentSearcherFactory.ContentSearchSort>();
    private ViewItemContainer _resultItems;
    private ColumnHelper _columnHelper;

    @Override
    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._columnHelper = (ColumnHelper)serviceManager.lookup(ColumnHelper.ROLE);
    }

    @Override
    public void configure(Configuration query) throws ConfigurationException {
        super.configure(query);
        Configuration columnsConfiguration = query.getChild("columns");
        this._overrideColumns = columnsConfiguration.getAttributeAsBoolean("override", false);
        for (Configuration columnConfiguration : columnsConfiguration.getChildren("column")) {
            ExtractionColumn column = new ExtractionColumn();
            column.setFieldPath(columnConfiguration.getValue());
            column.setDisplayOptionalName(columnConfiguration.getAttribute("optional", null));
            this._columns.add(column);
        }
        Configuration sorts = query.getChild("sorts");
        this._overrideSorts = sorts.getAttributeAsBoolean("override", false);
        for (Configuration sort : sorts.getChildren("sort")) {
            String orderAsString = sort.getAttribute("order", "ASC");
            SortOrder order = orderAsString.equalsIgnoreCase("ASC") ? SortOrder.ASC : SortOrder.DESC;
            String fieldPath = sort.getValue();
            this._sortMap.put(fieldPath, order);
        }
    }

    @Override
    public void prepareComponentExecution(ExtractionExecutionContext context) throws Exception {
        super.prepareComponentExecution(context);
        List<String> columnFieldPaths = this._getColumnsToDisplay(context);
        this._resultItems = this._buildResulItems(columnFieldPaths);
        for (Map.Entry<String, SortOrder> entry : this._sortMap.entrySet()) {
            String fieldPath = entry.getKey().replaceAll("\\.", "/");
            this._sorts.add(new ContentSearcherFactory.ContentSearchSort(fieldPath, entry.getValue()));
        }
        for (ContentSearcherFactory.ContentSearchSort sort : this._sorts) {
            this._getAttributeTypeId(sort.sortField(), this._contentTypes);
        }
    }

    private List<String> _getColumnsToDisplay(ExtractionExecutionContext context) {
        Map<String, Boolean> displayOptionalColumns = context.getDisplayOptionalColumns();
        ArrayList<String> columnFieldPaths = new ArrayList<String>();
        for (ExtractionColumn column : this._columns) {
            String displayOptionalColumnName = column.getDisplayOptionalName();
            if (displayOptionalColumns.containsKey(displayOptionalColumnName) && !displayOptionalColumns.get(displayOptionalColumnName).booleanValue()) continue;
            columnFieldPaths.add(column.getFieldPath());
        }
        return columnFieldPaths;
    }

    private ViewItemContainer _buildResulItems(List<String> columnFieldPaths) {
        Set contentTypeIds = this._contentTypesHelper.getCommonAncestors((Collection)this._contentTypes);
        List columns = this._columnHelper.getColumns(columnFieldPaths, contentTypeIds);
        return this._columnHelper.createViewFromColumns(contentTypeIds, (Collection)columns, true);
    }

    @Override
    protected void computeReferencedQueryInfos(String refQueryContent) throws QuerySyntaxException {
        super.computeReferencedQueryInfos(refQueryContent);
        Map contentMap = this._jsonUtils.convertJsonToMap(refQueryContent);
        Map exportParams = (Map)contentMap.get("exportParams");
        if (!this._overrideColumns) {
            Map values = (Map)exportParams.get("values");
            Object columnFieldPathsAsObject = values.get("columns");
            Collection columnFieldPaths = columnFieldPathsAsObject instanceof String ? StringUtils.stringToCollection((String)((String)columnFieldPathsAsObject)) : (List)columnFieldPathsAsObject;
            for (String fieldPath : columnFieldPaths) {
                ExtractionColumn column = new ExtractionColumn();
                column.setFieldPath(fieldPath);
                this._columns.add(column);
            }
        }
        if (!this._overrideSorts) {
            this._sorts.addAll(0, this._getQueryFromJSONHelper.getSort(exportParams));
        }
    }

    @Override
    protected ContentSearcherFactory.SimpleContentSearcher getContentSearcher() {
        return super.getContentSearcher().withSort(this._sorts);
    }

    @Override
    protected void processContents(Iterable<Content> contents, ContentHandler contentHandler, ExtractionExecutionContext context) throws Exception {
        if (contents.iterator().hasNext()) {
            XMLUtils.startElement((ContentHandler)contentHandler, (String)this._tagName);
            GroupSearchContent rootGroup = this.organizeContentsInGroups(contents, context.getDefaultLocale());
            this.saxGroup(contentHandler, rootGroup, 0, context, this._resultItems);
            XMLUtils.endElement((ContentHandler)contentHandler, (String)this._tagName);
        }
    }

    @Override
    public Iterable<Content> computeFirstLevelResults(ExtractionExecutionContext context) throws Exception {
        return this.getContents(context);
    }

    @Override
    public void executeFor(ContentHandler contentHandler, Iterable<Content> firstLevelResults, ExtractionExecutionContext context) throws Exception {
        this.processContents(firstLevelResults, contentHandler, context);
    }

    @Override
    protected void saxContents(ContentHandler contentHandler, ExtractionExecutionContext context, ViewItemContainer resultItems, List<Content> contents) throws Exception {
        for (int currentContentIndex = 0; currentContentIndex < contents.size(); ++currentContentIndex) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(this.getLogsPrefix() + "executing content " + (currentContentIndex + 1) + "/" + contents.size());
            }
            Content content = contents.get(currentContentIndex);
            AttributesImpl attributes = new AttributesImpl();
            attributes.addCDATAAttribute("id", content.getId());
            attributes.addCDATAAttribute("name", content.getName());
            attributes.addCDATAAttribute("title", content.getTitle(context.getDefaultLocale()));
            if (content.getLanguage() != null) {
                attributes.addCDATAAttribute("language", content.getLanguage());
            }
            XMLUtils.startElement((ContentHandler)contentHandler, (String)"content", (Attributes)attributes);
            DataContext dataContext = DataContext.newInstance().withLocale(context.getDefaultLocale()).withEmptyValues(false);
            content.dataToSAX(contentHandler, (ViewItemAccessor)resultItems, dataContext);
            ExtractionExecutionContextHierarchyElement currentContext = new ExtractionExecutionContextHierarchyElement(this, Collections.singleton(content));
            this.executeSubComponents(contentHandler, context, currentContext);
            XMLUtils.endElement((ContentHandler)contentHandler, (String)"content");
        }
    }

    @Override
    public Map<String, Object> getComponentDetailsForTree() {
        Map<String, Object> details = super.getComponentDetailsForTree();
        details.put("tag", "query");
        Map data = (Map)details.get("data");
        StringJoiner columns = new StringJoiner(",");
        for (ExtractionColumn column : this.getColumns()) {
            StringBuilder builder = new StringBuilder();
            builder.append(column.getFieldPath());
            if (null != column.getDisplayOptionalName()) {
                builder.append(" (").append(column.getDisplayOptionalName()).append(")");
            }
            columns.add(builder);
        }
        data.put("columns", columns.toString());
        data.put("overrideColumns", this.overrideColumns());
        StringJoiner sorts = new StringJoiner(",");
        for (Map.Entry<String, SortOrder> sort : this.getSorts().entrySet()) {
            StringBuilder builder = new StringBuilder();
            builder.append(sort.getKey()).append(" (");
            if (SortOrder.DESC.equals((Object)sort.getValue())) {
                builder.append("DESC");
            } else {
                builder.append("ASC");
            }
            builder.append(")");
            sorts.add(builder);
        }
        data.put("sorts", sorts.toString());
        data.put("overrideSorts", this.overrideSorts());
        details.put("iconCls", "ametysicon-query-search");
        return details;
    }

    @Override
    protected String getDefaultTagName() {
        return "query";
    }

    @Override
    protected String getLogsPrefix() {
        return "Query component '" + this._tagName + "': ";
    }

    public boolean overrideColumns() {
        return this._overrideColumns;
    }

    public void setOverrideColumns(boolean overrideColumns) {
        this._overrideColumns = overrideColumns;
    }

    public List<ExtractionColumn> getColumns() {
        return this._columns;
    }

    public void addColumns(String ... fieldPaths) {
        for (String fieldPath : fieldPaths) {
            ExtractionColumn column = new ExtractionColumn();
            column.setFieldPath(fieldPath);
            this._columns.add(column);
        }
    }

    public void addColumn(String fieldPath, String displayOptionalColumnName) {
        ExtractionColumn column = new ExtractionColumn();
        column.setFieldPath(fieldPath);
        column.setDisplayOptionalName(displayOptionalColumnName);
        this._columns.add(column);
    }

    public boolean overrideSorts() {
        return this._overrideSorts;
    }

    public void setOverrideSorts(boolean overrideSorts) {
        this._overrideSorts = overrideSorts;
    }

    public Map<String, SortOrder> getSorts() {
        return this._sortMap;
    }

    public void addSort(String filedPath, SortOrder order) {
        this._sortMap.put(filedPath, order);
    }
}

