/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.extraction.execution;

import java.io.File;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.ametys.cms.contenttype.ContentType;
import org.ametys.cms.contenttype.ContentTypeExtensionPoint;
import org.ametys.cms.contenttype.ContentTypesHelper;
import org.ametys.core.schedule.Runnable;
import org.ametys.core.ui.Callable;
import org.ametys.core.ui.StaticClientSideElement;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.core.util.JSONUtils;
import org.ametys.plugins.core.schedule.Scheduler;
import org.ametys.plugins.extraction.execution.ExecuteExtractionRunnable;
import org.ametys.plugins.extraction.execution.Extraction;
import org.ametys.plugins.extraction.execution.ExtractionDefinitionReader;
import org.ametys.plugins.extraction.execution.pipeline.PipelineManager;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.impl.FileSource;
import org.quartz.JobKey;
import org.quartz.SchedulerException;

public class ExecuteExtractionClientSideElement
extends StaticClientSideElement {
    private UserManager _userManager;
    private ExtractionDefinitionReader _reader;
    private SourceResolver _sourceResolver;
    private JSONUtils _jsonUtils;
    private Scheduler _scheduler;
    private PipelineManager _pipelineManager;
    private ContentTypeExtensionPoint _contentTypeExtensionPoint;
    private ContentTypesHelper _contentTypesHelper;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._userManager = (UserManager)serviceManager.lookup(UserManager.ROLE);
        this._reader = (ExtractionDefinitionReader)((Object)serviceManager.lookup(ExtractionDefinitionReader.ROLE));
        this._sourceResolver = (SourceResolver)serviceManager.lookup(SourceResolver.ROLE);
        this._jsonUtils = (JSONUtils)serviceManager.lookup(JSONUtils.ROLE);
        this._scheduler = (Scheduler)serviceManager.lookup(Scheduler.ROLE);
        this._pipelineManager = (PipelineManager)((Object)serviceManager.lookup(PipelineManager.ROLE));
        this._contentTypeExtensionPoint = (ContentTypeExtensionPoint)serviceManager.lookup(ContentTypeExtensionPoint.ROLE);
        this._contentTypesHelper = (ContentTypesHelper)serviceManager.lookup(ContentTypesHelper.ROLE);
    }

    @Callable(rights={"Extraction_Rights_ExecuteExtraction"})
    public Map<String, Object> getExecutionParameters(String definitionFile) throws Exception {
        LinkedHashMap<String, Object> executionParameters = new LinkedHashMap<String, Object>();
        String definitionFilePath = "context://WEB-INF/param/extraction/definitions/" + definitionFile;
        Source src = this._sourceResolver.resolveURI(definitionFilePath);
        File file = ((FileSource)src).getFile();
        if (!file.exists()) {
            throw new IllegalArgumentException("The file " + definitionFilePath + " does not exist.");
        }
        executionParameters.put("pipeline", this._getPipelineInputConfig(definitionFile));
        Extraction extraction = this._reader.readExtractionDefinitionFile(file);
        List<Extraction.ClausesVariable> clausesVariables = extraction.getClausesVariables();
        List<String> optionalColumns = extraction.getDisplayOptionalColumnsNames();
        if (!clausesVariables.isEmpty()) {
            HashMap<String, Object> clausesVariablesFieldSet = new HashMap<String, Object>();
            clausesVariablesFieldSet.put("role", "fieldset");
            clausesVariablesFieldSet.put("label", new I18nizableText("plugin.extraction", "PLUGINS_EXTRACTION_EXECUTE_EXTRACTION_CLAUSES_VARIABLES_FIELDSET_LABEL"));
            HashMap<String, Map<String, Object>> clausesVariablesFieldSetElements = new HashMap<String, Map<String, Object>>();
            for (Extraction.ClausesVariable clausesVariable : clausesVariables) {
                clausesVariablesFieldSetElements.put(clausesVariable.name(), this._getClausesVariableInputConfig(clausesVariable));
            }
            clausesVariablesFieldSet.put("elements", clausesVariablesFieldSetElements);
            executionParameters.put("clausesVariables", clausesVariablesFieldSet);
        }
        if (!optionalColumns.isEmpty()) {
            HashMap<String, Object> optionalColumnsFieldSet = new HashMap<String, Object>();
            optionalColumnsFieldSet.put("role", "fieldset");
            optionalColumnsFieldSet.put("label", new I18nizableText("plugin.extraction", "PLUGINS_EXTRACTION_EXECUTE_EXTRACTION_OPTIONAL_COLUMNS_FIELDSET_LABEL"));
            HashMap<String, Map<String, Object>> optionalColumnsFieldSetElements = new HashMap<String, Map<String, Object>>();
            for (String optionalColumn : optionalColumns) {
                optionalColumnsFieldSetElements.put(optionalColumn, this._getOptionalColumnsInputConfig(optionalColumn));
            }
            optionalColumnsFieldSet.put("elements", optionalColumnsFieldSetElements);
            executionParameters.put("optionalColumns", optionalColumnsFieldSet);
        }
        executionParameters.put("recipient", this._getRecipientInputConfig());
        return executionParameters;
    }

    private Map<String, Object> _getPipelineInputConfig(String definitionFile) {
        HashMap<String, Object> inputConfig = new HashMap<String, Object>();
        inputConfig.put("label", new I18nizableText("plugin.extraction", "PLUGINS_EXTRACTION_EXECUTE_EXTRACTION_PIPELINE_INPUT_LABEL"));
        inputConfig.put("description", new I18nizableText("plugin.extraction", "PLUGINS_EXTRACTION_EXECUTE_EXTRACTION_PIPELINE_INPUT_DESCRIPTION"));
        inputConfig.put("type", "string");
        inputConfig.put("default-value", this._pipelineManager.getDefaultPipeline());
        inputConfig.put("validation", this._getMandatoryValidation());
        inputConfig.put("widget", "edition.select-pipeline");
        HashMap<String, String> widgetParams = new HashMap<String, String>();
        widgetParams.put("extraction", definitionFile);
        inputConfig.put("widget-params", widgetParams);
        return inputConfig;
    }

    private Map<String, Object> _getClausesVariableInputConfig(Extraction.ClausesVariable clausesVariable) {
        HashMap<String, Object> inputConfig = new HashMap<String, Object>();
        inputConfig.put("label", clausesVariable.name());
        if (Extraction.ClausesVariableType.SOLR_REQUEST.equals((Object)clausesVariable.type())) {
            inputConfig.put("description", new I18nizableText("plugin.extraction", "PLUGINS_EXTRACTION_EXECUTE_EXTRACTION_CLAUSES_VARIABLE_SOLR_REQUEST_INPUT_DESCRIPTION"));
            inputConfig.put("type", "string");
            inputConfig.put("widget", "edition.solr-code");
            HashMap<String, Object> widgetParams = new HashMap<String, Object>();
            Set commonAncestors = this._contentTypesHelper.getCommonAncestors(clausesVariable.contentTypeIds());
            widgetParams.put("ctypes", commonAncestors);
            widgetParams.put("singleLine", true);
            widgetParams.put("height", 66);
            widgetParams.put("mode", "text/x-solr-ametys");
            inputConfig.put("widget-params", widgetParams);
        } else {
            inputConfig.put("description", new I18nizableText("plugin.extraction", "PLUGINS_EXTRACTION_EXECUTE_EXTRACTION_CLAUSES_VARIABLE_SELECT_CONTENTS_INPUT_DESCRIPTION"));
            inputConfig.put("type", "content");
            inputConfig.put("multiple", true);
            String widget = "edition.select-content";
            HashMap widgetParams = new HashMap();
            Optional contentTypeId = clausesVariable.contentTypeIds().stream().findFirst();
            if (contentTypeId.isPresent()) {
                ContentType contentType = (ContentType)this._contentTypeExtensionPoint.getExtension((String)contentTypeId.get());
                if (contentType.isReferenceTable()) {
                    widget = "edition.select-referencetable-content";
                }
                widgetParams.put("contentType", contentTypeId.get());
            }
            clausesVariable.searchModelId().ifPresent(searchModelId -> widgetParams.put("modelId", searchModelId));
            clausesVariable.solrRequest().ifPresent(solrRequest -> widgetParams.put("solrRequest", solrRequest));
            inputConfig.put("widget", widget);
            inputConfig.put("widget-params", widgetParams);
        }
        inputConfig.put("validation", this._getMandatoryValidation());
        return inputConfig;
    }

    private Map<String, Object> _getOptionalColumnsInputConfig(String optionalColumn) {
        HashMap<String, Object> inputConfig = new HashMap<String, Object>();
        inputConfig.put("label", optionalColumn);
        inputConfig.put("description", new I18nizableText("plugin.extraction", "PLUGINS_EXTRACTION_EXECUTE_EXTRACTION_OPTIONAL_COLUMNS_INPUTS_DESCRIPTION"));
        inputConfig.put("type", "boolean");
        inputConfig.put("widget", "edition.checkbox");
        inputConfig.put("validation", this._getMandatoryValidation());
        return inputConfig;
    }

    private Map<String, Object> _getRecipientInputConfig() {
        HashMap<String, Object> inputConfig = new HashMap<String, Object>();
        String currentUserEmail = null;
        UserIdentity currentUser = this._currentUserProvider.getUser();
        String login = currentUser.getLogin();
        if (StringUtils.isNotBlank((CharSequence)login)) {
            String userPopulationId = currentUser.getPopulationId();
            User user = this._userManager.getUser(userPopulationId, login);
            currentUserEmail = user.getEmail();
        }
        inputConfig.put("label", new I18nizableText("plugin.extraction", "PLUGINS_EXTRACTION_EXECUTE_EXTRACTION_RECIPIENT_INPUT_LABEL"));
        inputConfig.put("description", new I18nizableText("plugin.extraction", "PLUGINS_EXTRACTION_EXECUTE_EXTRACTION_RECIPIENT_INPUT_DESCRIPTION"));
        inputConfig.put("type", "string");
        inputConfig.put("default-value", currentUserEmail);
        return inputConfig;
    }

    private Map<String, Object> _getMandatoryValidation() {
        HashMap<String, Object> mandatoryValidation = new HashMap<String, Object>();
        mandatoryValidation.put("mandatory", true);
        return mandatoryValidation;
    }

    @Callable(rights={"Extraction_Rights_ExecuteExtraction"})
    public Map<String, Object> executeExtraction(String definitionFilePath, Map<String, Object> variables, String recipient, String pipelineId) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            String variablesAsString = this._jsonUtils.convertObjectToJson(variables);
            ExecuteExtractionRunnable executeExtractionRunnable = new ExecuteExtractionRunnable(definitionFilePath, variablesAsString, recipient, pipelineId);
            JobKey jobKey = new JobKey(executeExtractionRunnable.getId(), "runtime.job");
            if (this._scheduler.getScheduler().checkExists(jobKey)) {
                this._scheduler.getScheduler().deleteJob(jobKey);
            }
            this._scheduler.scheduleJob((Runnable)executeExtractionRunnable);
            this.getLogger().info("Scheduled extraction execution of " + definitionFilePath);
        }
        catch (SchedulerException e) {
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error("An error occured when trying to schedule the extraction execution of " + definitionFilePath, (Throwable)e);
            }
            result.put("error", "scheduler-error");
            return result;
        }
        result.put("definitionFilePath", definitionFilePath);
        return result;
    }
}

