/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.extraction.execution;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.ametys.cms.schedule.AbstractSendingMailSchedulable;
import org.ametys.core.schedule.progression.ContainerProgressionTracker;
import org.ametys.core.ui.mail.StandardMailBodyHelper;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.directory.NotUniqueUserException;
import org.ametys.core.util.I18nUtils;
import org.ametys.core.util.JSONUtils;
import org.ametys.plugins.extraction.execution.ExtractionExecutor;
import org.ametys.plugins.extraction.execution.pipeline.PipelineDescriptor;
import org.ametys.plugins.extraction.execution.pipeline.PipelineManager;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.util.AmetysHomeHelper;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;

public class ExecuteExtractionSchedulable
extends AbstractSendingMailSchedulable {
    public static final String DEFINITION_FILE_PATH_KEY = "definitionFilePath";
    public static final String VARIABLES_KEY = "variables";
    public static final String RECIPIENT_KEY = "recipient";
    public static final String PIPELINE_KEY = "pipeline";
    private static final String __JOBDATAMAP_DEFINITION_FILE_PATH_KEY = "parameterValues#definitionFilePath";
    private static final String __JOBDATAMAP_VARIABLES_KEY = "parameterValues#variables";
    private static final String __JOBDATAMAP_RECIPIENT_KEY = "parameterValues#recipient";
    private static final String __JOBDATAMAP_PIPELINE_KEY = "parameterValues#pipeline";
    private static final String __RESULT_FILE_PATHS = "resultFilePaths";
    private static final DateTimeFormatter RESULT_FILE_NAME_DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd'T'HH.mm.ss");
    private JSONUtils _jsonUtils;
    private PipelineManager _pipelineManager;
    private ExtractionExecutor _extractionExecutor;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._jsonUtils = (JSONUtils)manager.lookup(JSONUtils.ROLE);
        this._i18nUtils = (I18nUtils)manager.lookup(I18nUtils.ROLE);
        this._pipelineManager = (PipelineManager)((Object)manager.lookup(PipelineManager.ROLE));
        this._extractionExecutor = (ExtractionExecutor)((Object)manager.lookup(ExtractionExecutor.ROLE));
    }

    public void _doExecute(JobExecutionContext context, ContainerProgressionTracker progressionTracker) throws Exception {
        JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
        String definitionFilePath = this._getDefinitionFilePath(context);
        PipelineDescriptor pipeline = this._pipelineManager.get(jobDataMap.getString(__JOBDATAMAP_PIPELINE_KEY));
        String defaultResultFileName = this._getDefaultResultFileName(definitionFilePath, pipeline);
        Map<String, Object> parameters = this._getExtractionParameters(jobDataMap);
        String lang = (String)parameters.get("lang");
        Set<Path> resultFilePaths = this._extractionExecutor.execute(definitionFilePath, defaultResultFileName, lang, parameters, pipeline);
        context.put((Object)__RESULT_FILE_PATHS, resultFilePaths);
    }

    private String _getDefaultResultFileName(String definitionFilePath, PipelineDescriptor pipeline) {
        String[] definitionFilePathSegments = definitionFilePath.split(Pattern.quote(File.separator));
        String definitionFileName = definitionFilePathSegments[definitionFilePathSegments.length - 1];
        int lastIndexOfDot = definitionFileName.lastIndexOf(46);
        if (-1 != lastIndexOfDot) {
            definitionFileName = definitionFileName.substring(0, lastIndexOfDot);
        }
        String extractionDate = ZonedDateTime.now().format(RESULT_FILE_NAME_DATE_TIME_FORMATTER);
        StringBuilder resultFileName = new StringBuilder();
        resultFileName.append(definitionFileName).append("-").append(extractionDate);
        resultFileName.append(".").append(pipeline.getDefaultExtension());
        return resultFileName.toString();
    }

    private Map<String, Object> _getExtractionParameters(JobDataMap jobDataMap) {
        String variablesAsString = jobDataMap.getString(__JOBDATAMAP_VARIABLES_KEY);
        Map variablesAsMap = this._jsonUtils.convertJsonToMap(variablesAsString);
        return variablesAsMap;
    }

    protected String _getRecipientLanguage(JobExecutionContext context) {
        JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
        String recipient = jobDataMap.getString(__JOBDATAMAP_RECIPIENT_KEY);
        if (jobDataMap.containsKey((Object)"userIdentity")) {
            String userIdentityString = jobDataMap.getString("userIdentity");
            UserIdentity userIdentity = UserIdentity.stringToUserIdentity((String)userIdentityString);
            User user = this._userManager.getUser(userIdentity);
            if (user != null && recipient != null && recipient.equals(user.getEmail())) {
                return user.getLanguage();
            }
            try {
                user = this._userManager.getUserByEmail(userIdentity.getPopulationId(), recipient);
                if (user != null) {
                    return user.getLanguage();
                }
            }
            catch (NotUniqueUserException notUniqueUserException) {
                // empty catch block
            }
        }
        return null;
    }

    protected Optional<String> _getRecipient(JobExecutionContext context) {
        JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
        return Optional.ofNullable(jobDataMap.getString(__JOBDATAMAP_RECIPIENT_KEY)).filter(StringUtils::isNotEmpty);
    }

    protected boolean _isMailBodyInHTML(JobExecutionContext context) {
        return true;
    }

    protected I18nizableText _getSuccessMailSubject(JobExecutionContext context) {
        String extractionName = this._getDefinitionFilePath(context);
        return new I18nizableText("plugin.extraction", "PLUGINS_EXTRACTION_EXECUTE_EXTRACTION_MAIL_SUCCESS_SUBJECT", Map.of("extractionName", new I18nizableText(extractionName)));
    }

    protected String _getSuccessMailBody(JobExecutionContext context, String language) {
        try {
            String extractionName = this._getDefinitionFilePath(context);
            StandardMailBodyHelper.MailBodyBuilder bodyBuilder = StandardMailBodyHelper.newHTMLBody().withTitle(new I18nizableText("plugin.extraction", "PLUGINS_EXTRACTION_EXECUTE_EXTRACTION_MAIL_SUCCESS_BODY_TITLE", Map.of("extractionName", new I18nizableText(extractionName)))).withLanguage(language).addMessage(new I18nizableText("plugin.extraction", "PLUGINS_EXTRACTION_EXECUTE_EXTRACTION_MAIL_SUCCESS_BODY", Map.of("extractionName", new I18nizableText(extractionName))));
            I18nizableText resultsToolLabel = new I18nizableText("plugin.extraction", "PLUGINS_EXTRACTION_RESULTS_LIST_TOOL_LABEL");
            Set resultFilePaths = (Set)context.get((Object)__RESULT_FILE_PATHS);
            if (resultFilePaths.size() == 1) {
                String downloadLink = this._getResultFileDownloadLink((Path)resultFilePaths.iterator().next());
                bodyBuilder.addMessage(new I18nizableText("plugin.extraction", "PLUGINS_EXTRACTION_EXECUTE_EXTRACTION_MAIL_SUCCESS_BODY_DOWNLOAD_RESULT", Map.of("link", new I18nizableText(downloadLink)))).addMessage(new I18nizableText("plugin.extraction", "PLUGINS_EXTRACTION_EXECUTE_EXTRACTION_MAIL_SUCCESS_BODY_SEE_RESULT", Map.of("toolLabel", resultsToolLabel)));
            } else {
                StringBuilder downloadLinks = new StringBuilder("<ul>");
                for (Path resultFilePath : resultFilePaths) {
                    downloadLinks.append("<li>").append(this._getResultFileDownloadLink(resultFilePath)).append("</li>");
                }
                downloadLinks.append("</ul>");
                bodyBuilder.addMessage(new I18nizableText("plugin.extraction", "PLUGINS_EXTRACTION_EXECUTE_EXTRACTION_MAIL_SUCCESS_BODY_DOWNLOAD_RESULTS", Map.of("links", new I18nizableText(downloadLinks.toString())))).addMessage(new I18nizableText("plugin.extraction", "PLUGINS_EXTRACTION_EXECUTE_EXTRACTION_MAIL_SUCCESS_BODY_SEE_RESULTS", Map.of("toolLabel", resultsToolLabel)));
            }
            return bodyBuilder.build();
        }
        catch (IOException e) {
            this.getLogger().error("Failed to build HTML body for extraction report mail", (Throwable)e);
            return null;
        }
    }

    protected I18nizableText _getErrorMailSubject(JobExecutionContext context) {
        String extractionName = this._getDefinitionFilePath(context);
        return new I18nizableText("plugin.extraction", "PLUGINS_EXTRACTION_EXECUTE_EXTRACTION_MAIL_ERROR_SUBJECT", Map.of("extractionName", new I18nizableText(extractionName)));
    }

    protected String _getErrorMailBody(JobExecutionContext context, String language, Throwable throwable) {
        String extractionName = this._getDefinitionFilePath(context);
        String error = ExceptionUtils.getStackTrace((Throwable)throwable);
        try {
            return StandardMailBodyHelper.newHTMLBody().withTitle(new I18nizableText("plugin.extraction", "PLUGINS_EXTRACTION_EXECUTE_EXTRACTION_MAIL_ERROR_BODY_TITLE", Map.of("extractionName", new I18nizableText(extractionName)))).withMessage(new I18nizableText("plugin.extraction", "PLUGINS_EXTRACTION_EXECUTE_EXTRACTION_MAIL_ERROR_BODY", Map.of("extractionName", new I18nizableText(extractionName)))).withDetails(new I18nizableText("plugin.extraction", "PLUGINS_EXTRACTION_EXECUTE_EXTRACTION_MAIL_ERROR_TITLE"), error, true).withLanguage(language).build();
        }
        catch (IOException e) {
            this.getLogger().error("Failed to build HTML body email for extraction report results", (Throwable)e);
            return null;
        }
    }

    private String _getDefinitionFilePath(JobExecutionContext context) {
        JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
        return jobDataMap.getString(__JOBDATAMAP_DEFINITION_FILE_PATH_KEY);
    }

    private String _getResultFileDownloadLink(Path resultFilePath) {
        Path rootPath = AmetysHomeHelper.getAmetysHomeData().toPath().resolve("extraction");
        String rootURI = rootPath.toUri().toString();
        String resultFileURI = resultFilePath.toUri().toString();
        String resultFileRelativeURI = resultFileURI.substring(rootURI.length());
        String downloadURL = String.valueOf(Config.getInstance().getValue("cms.url")) + "/plugins/extraction/result/download/" + resultFileRelativeURI;
        String resultFileRelativePath = rootPath.relativize(resultFilePath).toString();
        return "<a href=\"" + downloadURL + "\">" + resultFileRelativePath + "</a>";
    }
}

