/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * Extraction context for profile assignments.
 */
Ext.define('Ametys.plugins.extraction.ExtractionRightAssignmentContext', {
    extend: 'Ametys.plugins.coreui.profiles.AbstractRightAssignmentContext',
    
    constructor: function(config)
    {
        this.callParent(arguments);
        Ametys.message.MessageBus.on(Ametys.message.Message.TOOL_FOCUSED, this._onToolFocused, this);
    },
    
    getComponent: function()
    {
        this._grid = Ext.create("Ametys.plugins.extraction.execution.ExtractionDefinitionsTree", {
            cls: 'extraction-tree',
            border: false,
            profile: 'right_access',
            
            enableColumnResize: true,
            hideHeaders: false,
            columns: [{
                    header: "{{i18n PLUGINS_EXTRACTION_EXTRACTIONS_LIST_TOOL_COLUMN_PATH}}",
                    xtype: 'treecolumn',
                    dataIndex: 'text',
                    flex: 1,
                    minWidth: 110,
                    editor: {
                        xtype: 'textfield',
                        allowBlank: false,
                        selectOnFocus: true
                    }
                },
                {header: "{{i18n PLUGINS_EXTRACTION_EXTRACTIONS_LIST_TOOL_COLUMN_AUTHOR}}", hidden: false, width: 110, sortable: true, dataIndex: 'authorFullName'}
            ],
            
            allowNodeEditing: false,
            allowDragAndDrop: false
        });
        this._grid.on('selectionchange', this._onSelectionChanged, this);
        return this._grid;
    },
    
    initialize: function()
    {
        var me = this;
        // Reload grid
        this._grid.initRootNodeParameter(function(){
            if (me._extractionPathToSelect)
            {
                me._grid.selectPath(me._grid.getRootNode().get('text') + '/' + me._extractionPathToSelect, "text")
            }
            else
            {
                // Select root node
                me._grid.getSelectionModel().deselectAll();
                me._grid.getSelectionModel().select(0);
            }
        });
    },
    
    dispose: function()
    {
        // Unregister the tool for all messages 
        Ametys.message.MessageBus.unAll(this);
    },

    isSupported: function (message)
    {
        return message.getTargets(Ametys.message.MessageTarget.EXTRACTION_DEFINITION_FILE).length > 0 
            || message.getTargets(Ametys.message.MessageTarget.EXTRACTION_DEFINITION_FOLDER).length > 0;
    },
    
    initContext: function (message)
    {
        var extractionTarget = message.getTarget();
        if (extractionTarget != null)
        {
            this._extractionPathToSelect = extractionTarget.getParameters().path;
        }
    },
    
    /**
     * @private
     * Listener when the selection in the grid has changed
     * @param {Ext.selection.Model} model The selection model
     * @param {Ext.data.Model[]} selected The selected records
     */
    _onSelectionChanged: function(model, selected)
    {
        if (selected.length > 0)
        {

            var object = selected[0];
            var data = object.data;
            if (data.canAssignRights)
            {
                var hintTextContext;
                if (!data.root)
                {
                    hintTextContext = (object.get('type') === "resource" ? "{{i18n PLUGINS_EXTRACTION_EXTRACTIONACCESS_CONTEXT_HINT_EXTRACTION}}" : "{{i18n PLUGINS_EXTRACTION_EXTRACTIONACCESS_CONTEXT_HINT_EXTRACTION_CONTAINER}}")  + "<b>" + selected[0].get('name') + "</b>";
                }
                else
                {
                    hintTextContext ="{{i18n PLUGINS_EXTRACTION_EXTRACTIONACCESS_CONTEXT_HINT_ROOT}}";
                }
                
                var path = this._config.context + (object.get('path') ? ("/" + object.get('path')) : "");
                this._changeObjectContext(path, hintTextContext, false);
            }
            else
            {
                this._changeObjectContext(null);
            }
            
        }
        else
        {
            this._changeObjectContext(null);
        }
    }
});
