/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class is the data model for extraction definition file entries.
 * @private
 */
Ext.define('Ametys.plugins.extraction.execution.ExtractionNodeEntry', {
    extend: 'Ext.data.Model',
    
    fields: [
        'text',
        'tag',
        { 
            name: 'data',
            isEqual: function(v1, v2) {
                if (v1 == v2)
                {
                    return true;
                }
                else if (v1 == null || v2 == null)
                {
                    return false;
                }
                else
                {
                    return Ext.Object.equals(v1, v2);
                }
            }
        }
    ]
});