/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.extraction.execution.pipeline.impl;

import java.util.Collection;

import org.apache.commons.lang3.StringUtils;

import org.ametys.plugins.extraction.ExtractionConstants;
import org.ametys.plugins.extraction.execution.pipeline.ExtractionMatcher;
import org.ametys.plugins.extraction.execution.pipeline.Pipeline;

/**
 * {@link ExtractionMatcher} for a {@link Pipeline} that handles a list of extractions
 */
public class ListExtractionMatcher implements ExtractionMatcher
{
    private Collection<String> _handled;
    
    /**
     * Creates a {@link ListExtractionMatcher}
     * @param handled the list of handled extractions
     */
    public ListExtractionMatcher(Collection<String> handled)
    {
        this._handled = handled;
    }

    @Override
    public boolean isHandled(String extractionId)
    {
        return _handled.contains(extractionId)
                || extractionId.contains(ExtractionConstants.PATH_SEPARATOR)
                    && _handled.contains(StringUtils.substringAfterLast(extractionId, ExtractionConstants.PATH_SEPARATOR));
    }
}
