/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.extraction.execution;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.ametys.plugins.extraction.execution.ExtractionExecutor;
import org.ametys.plugins.extraction.execution.pipeline.PipelineDescriptor;
import org.ametys.plugins.extraction.execution.pipeline.PipelineManager;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.reading.ServiceableReader;
import org.xml.sax.SAXException;

public class ExtractionReader
extends ServiceableReader {
    private static final String __PIPELINE_PARAMETER = "pipeline";
    private static final String __LANG_PARAMETER = "lang";
    private static final String __DEFINITION_FILE_PARAMETER = "file";
    private PipelineManager _pipelineManager;
    private ExtractionExecutor _extractionExecutor;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._pipelineManager = (PipelineManager)((Object)this.manager.lookup(PipelineManager.ROLE));
        this._extractionExecutor = (ExtractionExecutor)((Object)smanager.lookup(ExtractionExecutor.ROLE));
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String definitionFileName = request.getParameter(__DEFINITION_FILE_PARAMETER);
        if (definitionFileName == null) {
            throw new IllegalArgumentException("The 'file' parameter is mandatory, it must be present to select an extraction to execute.");
        }
        String lang = request.getParameter(__LANG_PARAMETER);
        Map<String, Object> params = ExtractionReader._getParams(request);
        PipelineDescriptor pipeline = this._getPipeline(request);
        try {
            this._extractionExecutor.execute(definitionFileName, this.out, lang, params, pipeline);
        }
        catch (Exception e) {
            throw new ProcessingException(e);
        }
    }

    private PipelineDescriptor _getPipeline(Request request) throws IOException {
        String pipelineId = request.getParameter(__PIPELINE_PARAMETER);
        if (pipelineId == null) {
            pipelineId = this._pipelineManager.getDefaultPipeline();
        } else if (!this._pipelineManager.has(pipelineId)) {
            throw new IllegalArgumentException("The pipeline '" + pipelineId + "' does not exists.");
        }
        PipelineDescriptor pipeline = this._pipelineManager.get(pipelineId);
        return pipeline;
    }

    private static Map<String, Object> _getParams(Request request) {
        return Collections.list(request.getParameterNames()).stream().collect(Collectors.toMap(Function.identity(), paramName -> request.getParameter(paramName)));
    }
}

