/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.extraction.execution.pipeline.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.UUID;
import javax.xml.transform.sax.TransformerHandler;
import org.ametys.core.util.URIUtils;
import org.ametys.plugins.extraction.execution.pipeline.PipelineSerializerModel;
import org.ametys.plugins.extraction.execution.pipeline.Pipelines;
import org.ametys.plugins.extraction.execution.pipeline.impl.AbstractSerializerImpl;
import org.ametys.plugins.extraction.execution.pipeline.impl.PipelineSerializer;
import org.ametys.runtime.util.AmetysHomeHelper;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.source.impl.SitemapSource;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.SourceUtil;

public class PdfPipelineSerializerModel
implements PipelineSerializerModel,
Serviceable {
    private SourceResolver _sourceResolver;

    public void service(ServiceManager manager) throws ServiceException {
        this._sourceResolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
    }

    @Override
    public String getDefaultFileExtension() {
        return "pdf";
    }

    @Override
    public PipelineSerializer newSerializer(TransformerHandler handler, OutputStream out, Map<String, String> outputParameters) {
        return new PdfPipelineSerializer(handler, out, this._sourceResolver);
    }

    private static final class PdfPipelineSerializer
    extends AbstractSerializerImpl {
        private SourceResolver _sourceResolver;
        private OutputStream _tmpFileOs;
        private Path _tmpFile;

        PdfPipelineSerializer(TransformerHandler handler, OutputStream out, SourceResolver sourceResolver) {
            super(handler, out);
            this._sourceResolver = sourceResolver;
        }

        @Override
        public void prepare() throws Exception {
            String tmpFilename = UUID.randomUUID().toString();
            this._tmpFile = AmetysHomeHelper.getAmetysHomeTmp().toPath().resolve(Paths.get("extraction", tmpFilename));
            this._tmpFileOs = Pipelines.getOutputStream(this._tmpFile);
            this._streamResult = Pipelines.setResult(this._handler, this._tmpFileOs);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void serialize() throws Exception {
            StringBuilder uri = new StringBuilder("cocoon://_admin/plugins/extraction/pdf-serialize");
            uri.append("?file=").append(URIUtils.encodeParameter((String)this._tmpFile.toString()));
            SitemapSource src = (SitemapSource)this._sourceResolver.resolveURI(uri.toString());
            try (InputStream sourceIs = src.getInputStream();){
                SourceUtil.copy((InputStream)sourceIs, (OutputStream)this._out);
            }
            finally {
                this._sourceResolver.release((Source)src);
            }
        }

        @Override
        public void close() throws IOException {
            super.close();
            this._tmpFileOs.close();
            Files.delete(this._tmpFile);
        }
    }
}

