/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.extraction.rights;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.ametys.cms.contenttype.ContentTypesHelper;
import org.ametys.cms.repository.Content;
import org.ametys.core.group.GroupIdentity;
import org.ametys.core.right.AccessController;
import org.ametys.core.right.AccessExplanation;
import org.ametys.core.right.RightsException;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.core.impl.right.AbstractRightBasedAccessController;
import org.ametys.plugins.extraction.execution.Extraction;
import org.ametys.plugins.extraction.execution.ExtractionDAO;
import org.ametys.plugins.extraction.rights.ExtractionAccessController;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.TraversableSource;
import org.apache.excalibur.source.impl.FileSource;

public class ExtractionAuthorAccessController
extends AbstractRightBasedAccessController
implements Serviceable,
Initializable {
    private static final List<String> __AUTHOR_RIGHTS = List.of("Extraction_Rights_EditExtraction", "Workflow_Rights_Edition_Online");
    private SourceResolver _srcResolver;
    private String _rootPath;
    private ExtractionDAO _extractionDAO;
    private ContentTypesHelper _contentTypesHelper;

    public void service(ServiceManager manager) throws ServiceException {
        this._srcResolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
        this._extractionDAO = (ExtractionDAO)((Object)manager.lookup(ExtractionDAO.ROLE));
        this._contentTypesHelper = (ContentTypesHelper)manager.lookup(ContentTypesHelper.ROLE);
    }

    public void initialize() throws Exception {
        FileSource rootDir = (FileSource)this._srcResolver.resolveURI("context://WEB-INF/param/extraction/definitions/");
        this._rootPath = rootDir.getURI();
    }

    public boolean supports(Object object) {
        Content content;
        FileSource fileSource;
        return object instanceof Extraction || object instanceof FileSource && (fileSource = (FileSource)object).exists() && !fileSource.isCollection() && fileSource.getURI().startsWith(this._rootPath) || object instanceof Content && this._contentTypesHelper.isInstanceOf(content = (Content)object, "org.ametys.plugins.extraction.Content.description");
    }

    public AccessController.AccessResult getPermission(UserIdentity user, Set<GroupIdentity> userGroups, String rightId, Object object) {
        if (user.equals((Object)this._getAuthor(object))) {
            return __AUTHOR_RIGHTS.contains(rightId) ? AccessController.AccessResult.USER_ALLOWED : AccessController.AccessResult.UNKNOWN;
        }
        return AccessController.AccessResult.UNKNOWN;
    }

    public AccessController.AccessResult getReadAccessPermission(UserIdentity user, Set<GroupIdentity> userGroups, Object object) {
        return user.equals((Object)this._getAuthor(object)) ? AccessController.AccessResult.USER_ALLOWED : AccessController.AccessResult.UNKNOWN;
    }

    public Map<String, AccessController.AccessResult> getPermissionByRight(UserIdentity user, Set<GroupIdentity> userGroups, Object object) {
        HashMap<String, AccessController.AccessResult> permissionByRight = new HashMap<String, AccessController.AccessResult>();
        if (user.equals((Object)this._getAuthor(object))) {
            for (String rightId : __AUTHOR_RIGHTS) {
                permissionByRight.put(rightId, AccessController.AccessResult.USER_ALLOWED);
            }
        }
        return permissionByRight;
    }

    public AccessController.AccessResult getPermissionForAnonymous(String rightId, Object object) {
        return AccessController.AccessResult.UNKNOWN;
    }

    public AccessController.AccessResult getReadAccessPermissionForAnonymous(Object object) {
        return AccessController.AccessResult.UNKNOWN;
    }

    public AccessController.AccessResult getPermissionForAnyConnectedUser(String rightId, Object object) {
        return AccessController.AccessResult.UNKNOWN;
    }

    public AccessController.AccessResult getReadAccessPermissionForAnyConnectedUser(Object object) {
        return AccessController.AccessResult.UNKNOWN;
    }

    public Map<UserIdentity, AccessController.AccessResult> getPermissionByUser(String rightId, Object object) {
        HashMap<UserIdentity, AccessController.AccessResult> permissionByUser = new HashMap<UserIdentity, AccessController.AccessResult>();
        if (__AUTHOR_RIGHTS.contains(rightId)) {
            UserIdentity extractionAuthor = this._getAuthor(object);
            permissionByUser.put(extractionAuthor, AccessController.AccessResult.USER_ALLOWED);
        }
        return permissionByUser;
    }

    public Map<UserIdentity, AccessController.AccessResult> getReadAccessPermissionByUser(Object object) {
        return MapUtils.EMPTY_MAP;
    }

    public Map<GroupIdentity, AccessController.AccessResult> getPermissionByGroup(String rightId, Object object) {
        return MapUtils.EMPTY_MAP;
    }

    public Map<GroupIdentity, AccessController.AccessResult> getReadAccessPermissionByGroup(Object object) {
        return MapUtils.EMPTY_MAP;
    }

    public boolean hasUserAnyPermissionOnWorkspace(Set<Object> workspacesContexts, UserIdentity user, Set<GroupIdentity> userGroups, String rightId) {
        return false;
    }

    public boolean hasUserAnyReadAccessPermissionOnWorkspace(Set<Object> workspacesContexts, UserIdentity user, Set<GroupIdentity> userGroups) {
        return false;
    }

    public boolean hasAnonymousAnyPermissionOnWorkspace(Set<Object> workspacesContexts, String rightId) {
        return false;
    }

    public boolean hasAnonymousAnyReadAccessPermissionOnWorkspace(Set<Object> workspacesContexts) {
        return false;
    }

    public boolean hasAnyConnectedUserAnyPermissionOnWorkspace(Set<Object> workspacesContexts, String rightId) {
        return false;
    }

    public boolean hasAnyConnectedUserAnyReadAccessPermissionOnWorkspace(Set<Object> workspacesContexts) {
        return false;
    }

    protected AccessExplanation _getAccessExplanation(AccessController.AccessResult result, Object object, UserIdentity user, Set<GroupIdentity> groups, String rightId) {
        switch (result) {
            case USER_ALLOWED: 
            case UNKNOWN: {
                if (object instanceof Content) {
                    return new AccessExplanation(this.getId(), result, new I18nizableText("plugin.extraction", "PLUGINS_EXTRACTION_CONTENT_AUTHOR_ACCESS_CONTROLLER_" + result.name() + "_EXPLANATION", Map.of("title", this.getObjectLabel(object))));
                }
                return new AccessExplanation(this.getId(), result, new I18nizableText("plugin.extraction", "PLUGINS_EXTRACTION_AUTHOR_ACCESS_CONTROLLER_" + result.name() + "_EXPLANATION", Map.of("title", this.getObjectLabel(object))));
            }
        }
        return AccessController.getDefaultAccessExplanation((String)this.getId(), (AccessController.AccessResult)result);
    }

    private UserIdentity _getAuthor(Object object) {
        if (object instanceof Extraction) {
            Extraction extraction = (Extraction)object;
            return extraction.getAuthor();
        }
        if (object instanceof FileSource) {
            FileSource fileSource = (FileSource)object;
            return this._extractionDAO.getAuthor(fileSource);
        }
        if (object instanceof Content) {
            Content content = (Content)object;
            return content.getCreator();
        }
        return null;
    }

    private String _getExtractionName(Object object) {
        if (object instanceof FileSource) {
            FileSource fileSource = (FileSource)object;
            String target = StringUtils.substringAfter((String)this._extractionDAO.getExtractionRightPath((TraversableSource)fileSource), (String)"/extraction-dir");
            target = StringUtils.replace((String)target.substring(1), (String)"/", (String)" > ");
            return target;
        }
        if (object instanceof Extraction) {
            Extraction extraction = (Extraction)object;
            return extraction.getFileName();
        }
        if (object instanceof Content) {
            Content content = (Content)object;
            return content.getTitle();
        }
        return null;
    }

    public I18nizableText getObjectLabel(Object object) {
        String extractionName = this._getExtractionName(object);
        if (extractionName != null) {
            return new I18nizableText(extractionName);
        }
        throw new RightsException("Unsupported context: " + object.toString());
    }

    public I18nizableText getObjectCategory(Object object) {
        return ExtractionAccessController.EXTRACTION_CONTEXT_CATEGORY;
    }

    protected Iterable<? extends Object> getHandledObjects(UserIdentity identity, Set<GroupIdentity> groups, Set<Object> workspacesContexts) {
        if (workspacesContexts.contains("/cms")) {
            try {
                FileSource rootDir = (FileSource)this._srcResolver.resolveURI("context://WEB-INF/param/extraction/definitions/");
                if (rootDir.getFile().exists()) {
                    Stream<FileSource> definitions = this._getDefinitions(rootDir);
                    return definitions.toList();
                }
            }
            catch (IOException e) {
                this.getLogger().warn("Failed to compute the list of extractions");
            }
        }
        return List.of();
    }

    private Stream<FileSource> _getDefinitions(FileSource source) {
        if (source.isCollection()) {
            try {
                return source.getChildren().stream().filter(FileSource.class::isInstance).flatMap(src -> this._getDefinitions((FileSource)src));
            }
            catch (SourceException e) {
                this.getLogger().warn("Failed to compute the list of extractions");
                return Stream.of(new FileSource[0]);
            }
        }
        return Stream.of(source);
    }

    public AccessController.ExplanationObject getExplanationObject(Object object) {
        if (object instanceof FileSource) {
            FileSource source = (FileSource)object;
            return new AccessController.ExplanationObject((Object)this._extractionDAO.getExtractionRightPath((TraversableSource)source), this.getObjectLabel(object), this.getObjectCategory(object));
        }
        return super.getExplanationObject(object);
    }

    protected Collection<String> getHandledRights() {
        return __AUTHOR_RIGHTS;
    }
}

