/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * Singleton class helper for optional columns node edition.
 * @private
 */
 Ext.define('Ametys.plugins.extraction.edition.EditOptionalColumnsNodeDialog', {
    extend: "Ametys.plugins.extraction.edition.EditExtractionNodeDialog",
    singleton: true,
    
    /**
     * @protected
     * Retrieve the dialog title
     * @return {String} the dialog title
     */
    _getDialogTitle: function ()
    {
        return "{{i18n PLUGINS_EXTRACTION_EDIT_OPTIONAL_COLUMNS_DIALOG_TITLE}}";
    },
    
    /**
     * @protected
     * Retrieve the dialog icon class
     * @return {String} the dialog icon class
     */
    _getDialogIconCls: function ()
    {
        return "ametysicon-table28";
    },
    
    /**
     * @protected
     * Retrieves the form configuration elements
     * @param {Object} response needed information to configure form
     * @return {Object} the form configuration element
     */
    _getFormConfiguration: function(response)
    {
        var configuration = {};
        
        // names of optional columns variables
        configuration.names = {
            type: 'string',
            label: "{{i18n PLUGINS_EXTRACTION_EDIT_NODE_OPTIONAL_COLUMNS_NAMES_LABEL}}",
            description: "{{i18n PLUGINS_EXTRACTION_EDIT_NODE_OPTIONAL_COLUMNS_NAMES_DESCRIPTION}}",
            validation: {
                regexp: '^[a-zA-Z_-][a-zA-Z0-9_-]*(\\s*,\\s*[a-zA-Z_-][a-zA-Z0-9_-]*)*$',
                regexText: "{{i18n PLUGINS_EXTRACTION_EDIT_NODE_OPTIONAL_COLUMNS_NAMES_REGEX_TEXT}}"
            },
            multiple: true
        };
        
        return configuration;
    }
 });
 