/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This tool displays the list of all available extraction files
 * @private
 */
Ext.define('Ametys.plugins.extraction.execution.ExtractionDefinitionsTool', {
    extend: "Ametys.file.AbstractFileExplorerTool",
    
    /**
     * @readonly
     * @property {Boolean} extractionTabCompatible Specifies if this tool is compatible with the 'extraction tab'.
     */
    extractionTabCompatible: true,
    
    createTree: function()
    {
        return Ext.create("Ametys.plugins.extraction.execution.ExtractionDefinitionsTree", {
            cls: 'extraction-tree',
            border: false,
            
            enableColumnResize: true,
            hideHeaders: false,
            columns: [{
                    header: "{{i18n PLUGINS_EXTRACTION_EXTRACTIONS_LIST_TOOL_COLUMN_PATH}}",
                    xtype: 'treecolumn',
                    dataIndex: 'text',
                    flex: 1,
                    minWidth: 110,
                    editor: {
                        xtype: 'textfield',
                        allowBlank: false,
                        selectOnFocus: true
                    }
                },
                {header: "{{i18n PLUGINS_EXTRACTION_EXTRACTIONS_LIST_TOOL_COLUMN_AUTHOR}}", hidden: false, width: 110, sortable: true, dataIndex: 'authorFullName'}
            ],
            
            allowNodeEditing: true,
            allowDragAndDrop: true
        });
    },
    
    openFile: function(record)
    {
        Ametys.tool.ToolsManager.openTool('uitool-extraction-execution', {
            id: record.get('path'),
            name: record.get('name'),
            descriptionId: record.get('descriptionId'),
            author: record.get('author'),
            canRead: record.get('canRead'),
            canWrite: record.get('canWrite'),
            canDelete: record.get('canDelete'),
            canAssignRights: record.get('canAssignRights')
        });
    },
    
    getMessageTargetIdForResource: function(type)
    {
        return Ametys.message.MessageTarget.EXTRACTION_DEFINITION_FILE;
    },
    
    getMessageTargetIdForCollection: function(type)
    {
        return Ametys.message.MessageTarget.EXTRACTION_DEFINITION_FOLDER;
    },
    
    testTarget: function(target)
    {
        return target.getId() == Ametys.message.MessageTarget.EXTRACTION_DEFINITION_FILE || target.getId() == Ametys.message.MessageTarget.EXTRACTION_DEFINITION_FOLDER
    },

    setParams: function (params)
    {
        this.callParent(arguments);
        this.showRefreshing();
        this._tree.initRootNodeParameter(Ext.bind(this._refreshCb, this));
    },
    
    /**
     * @private
     * Callback function after (re)loading the tree
     */
    _refreshCb: function ()
    {
        this.showRefreshed();
        
        // Select root node
        this._tree.getSelectionModel().select(0);
    }
});
