/*
 *  Copyright 2018 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.extraction.execution.pipeline.impl;

import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;

import org.ametys.core.util.SizeUtils.ExcludeFromSizeCalculation;
import org.ametys.plugins.extraction.ExtractionConstants;
import org.ametys.plugins.extraction.execution.pipeline.ExtractionMatcher;
import org.ametys.plugins.extraction.execution.pipeline.Pipeline;
import org.ametys.plugins.extraction.execution.pipeline.PipelineDescriptor;
import org.ametys.plugins.extraction.execution.pipeline.PipelineSerializerModel;
import org.ametys.runtime.i18n.I18nizableText;

/**
 * Basic implementation of {@link PipelineDescriptor}, with no XSLT and a XML serializer.
 */
public class NoOpPipelineDescriptor implements PipelineDescriptor
{
    @ExcludeFromSizeCalculation
    private PipelineSerializerModel _xmlSerializer;

    /**
     * Default constructor
     * @param xmlSerializer The XML descriptor serializer for the pipelines
     */
    public NoOpPipelineDescriptor(PipelineSerializerModel xmlSerializer)
    {
        _xmlSerializer = xmlSerializer;
    }
    
    @Override
    public I18nizableText getLabel()
    {
        return new I18nizableText(ExtractionConstants.PLUGIN_NAME, "PLUGINS_EXTRACTION_EXECUTE_EXTRACTION_DEFAULT_PIPELINE_LABEL");
    }
    
    @Override
    public ExtractionMatcher getExtractionMatcher()
    {
        return new AllExtractionMatcher();
    }
    
    @Override
    public List<String> getStylesheets()
    {
        return Collections.emptyList();
    }
    
    @Override
    public PipelineSerializerModel getSerializerModel()
    {
        return _xmlSerializer;
    }
    
    @Override
    public String getResultSubfolder()
    {
        return ""; // root folder
    }
    
    @Override
    public String getDefaultExtension()
    {
        return _xmlSerializer.getDefaultFileExtension();
    }
    
    @Override
    public Pipeline newPipeline(OutputStream out)
    {
        return new PipelineImpl(this, out, null/*we can pass null as xslt list is empty*/);
    }

    @Override
    public Map<String, String> getOutputParameters()
    {
        return Collections.emptyMap();
    }
}
