/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.extraction.edition;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.core.user.UserHelper;
import org.ametys.plugins.extraction.execution.Extraction;
import org.ametys.plugins.extraction.execution.ExtractionDefinitionReader;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.impl.FileSource;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class SaveExtractionHelper
extends AbstractLogEnabled
implements Component,
Serviceable {
    public static final String ROLE = SaveExtractionHelper.class.getName();
    private static final String EXTRACT_EXTRA_DATA_REGEX = "\\(([-_a-zA-Z]+)\\)";
    private SourceResolver _sourceResolver;
    private ExtractionDefinitionReader _definitionReader;
    private UserHelper _userHelper;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this._sourceResolver = (SourceResolver)serviceManager.lookup(SourceResolver.ROLE);
        this._definitionReader = (ExtractionDefinitionReader)((Object)serviceManager.lookup(ExtractionDefinitionReader.ROLE));
        this._userHelper = (UserHelper)serviceManager.lookup(UserHelper.ROLE);
    }

    public boolean saveExtraction(String relativeDefinitionFilePath, Map<String, Object> extractionComponents) throws Exception {
        boolean errorOccurred;
        block19: {
            File definitionFile;
            String definitionFilePath;
            File backupFile;
            block18: {
                Extraction extraction;
                block17: {
                    errorOccurred = false;
                    String backupFilePath = "context://WEB-INF/param/extraction/definitions/" + relativeDefinitionFilePath + ".tmp";
                    Source backupSrc = this._sourceResolver.resolveURI(backupFilePath);
                    backupFile = ((FileSource)backupSrc).getFile();
                    definitionFilePath = "context://WEB-INF/param/extraction/definitions/" + relativeDefinitionFilePath;
                    Source definitionSrc = this._sourceResolver.resolveURI(definitionFilePath);
                    definitionFile = ((FileSource)definitionSrc).getFile();
                    if (!definitionFile.exists()) {
                        throw new IllegalArgumentException("The file " + relativeDefinitionFilePath + " does not exist.");
                    }
                    extraction = this._definitionReader.readExtractionDefinitionFile(definitionFile);
                    try {
                        Files.copy(definitionFile.toPath(), backupFile.toPath(), new CopyOption[0]);
                    }
                    catch (IOException e) {
                        if (!this.getLogger().isErrorEnabled()) break block17;
                        this.getLogger().error("Error when creating backup '" + definitionFilePath + "' file", (Throwable)e);
                    }
                }
                try (OutputStream os = Files.newOutputStream(Paths.get(definitionFile.getAbsolutePath(), new String[0]), new OpenOption[0]);){
                    TransformerHandler handler = ((SAXTransformerFactory)TransformerFactory.newInstance()).newTransformerHandler();
                    StreamResult result = new StreamResult(os);
                    handler.setResult(result);
                    Properties format = new Properties();
                    format.put("method", "xml");
                    format.put("indent", "yes");
                    format.put("encoding", "UTF-8");
                    format.put("{http://xml.apache.org/xalan}indent-amount", "4");
                    handler.getTransformer().setOutputProperties(format);
                    try {
                        this._saxExtraction(extraction, extractionComponents, handler);
                    }
                    catch (Exception e) {
                        if (this.getLogger().isErrorEnabled()) {
                            this.getLogger().error("Error when saxing the extraction definition file '" + definitionFilePath + "'", (Throwable)e);
                        }
                        errorOccurred = true;
                    }
                }
                catch (IOException | TransformerConfigurationException | TransformerFactoryConfigurationError e) {
                    if (!this.getLogger().isErrorEnabled()) break block18;
                    this.getLogger().error("Error when trying to modify the extraction definition file '" + definitionFilePath + "'", e);
                }
            }
            try {
                if (errorOccurred) {
                    Files.copy(backupFile.toPath(), definitionFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                Files.deleteIfExists(backupFile.toPath());
            }
            catch (IOException e) {
                if (!this.getLogger().isErrorEnabled()) break block19;
                this.getLogger().error("Error when restoring backup '" + definitionFilePath + "' file", (Throwable)e);
            }
        }
        return !errorOccurred;
    }

    private void _saxExtraction(Extraction extraction, Map<String, Object> extractionComponents, TransformerHandler handler) throws SAXException {
        handler.startDocument();
        Map extractionData = (Map)extractionComponents.get("data");
        AttributesImpl attributes = new AttributesImpl();
        if (MapUtils.isNotEmpty((Map)extractionData)) {
            attributes.addCDATAAttribute("name", (String)extractionData.get("name"));
        }
        XMLUtils.startElement((ContentHandler)handler, (String)"extraction", (Attributes)attributes);
        String descriptionId = extraction.getDescriptionId();
        if (StringUtils.isNotEmpty((CharSequence)descriptionId)) {
            AttributesImpl descriptionAttributes = new AttributesImpl();
            descriptionAttributes.addCDATAAttribute("id", descriptionId);
            XMLUtils.createElement((ContentHandler)handler, (String)"description", (Attributes)descriptionAttributes);
        }
        this._saxAuthor(extraction, handler);
        List children = (List)extractionComponents.get("children");
        if (null != children) {
            for (Map child : children) {
                String tag;
                switch (tag = (String)child.get("tag")) {
                    case "clauses-variables": {
                        this._saxClausesVariables(child, handler);
                        break;
                    }
                    case "optional-columns": {
                        this._saxOptionalColumns(child, handler);
                        break;
                    }
                    case "query": 
                    case "thesaurus": 
                    case "count": 
                    case "mapping-query": {
                        this._saxExtractionComponent(child, handler);
                        break;
                    }
                }
            }
        }
        XMLUtils.endElement((ContentHandler)handler, (String)"extraction");
        handler.endDocument();
    }

    private void _saxAuthor(Extraction extraction, TransformerHandler handler) throws SAXException {
        UserIdentity author = extraction.getAuthor();
        if (author != null) {
            this._userHelper.saxUserIdentity(author, (ContentHandler)handler, "author");
        }
    }

    private void _saxClausesVariables(Map<String, Object> child, TransformerHandler handler) throws SAXException {
        Map data = (Map)child.get("data");
        List variables = (List)data.get("variables");
        if (!variables.isEmpty()) {
            XMLUtils.startElement((ContentHandler)handler, (String)"clauses-variables");
            for (Map variable : variables) {
                String solrRequest;
                String searchModelId;
                AttributesImpl attributes = new AttributesImpl();
                attributes.addCDATAAttribute("name", (String)variable.get("name"));
                attributes.addCDATAAttribute("type", (String)variable.get("type"));
                XMLUtils.startElement((ContentHandler)handler, (String)"variable", (Attributes)attributes);
                List contentTypeIds = (List)variable.get("contentTypeIds");
                if (contentTypeIds != null && !contentTypeIds.isEmpty()) {
                    XMLUtils.startElement((ContentHandler)handler, (String)"content-types");
                    for (String contentTypeId : contentTypeIds) {
                        AttributesImpl contentTypeAttributes = new AttributesImpl();
                        contentTypeAttributes.addCDATAAttribute("id", contentTypeId);
                        XMLUtils.createElement((ContentHandler)handler, (String)"content-type", (Attributes)contentTypeAttributes);
                    }
                    XMLUtils.endElement((ContentHandler)handler, (String)"content-types");
                }
                if (StringUtils.isNotEmpty((CharSequence)(searchModelId = (String)variable.get("searchModelId")))) {
                    XMLUtils.createElement((ContentHandler)handler, (String)"search-model-id", (String)searchModelId);
                }
                if (StringUtils.isNotEmpty((CharSequence)(solrRequest = (String)variable.get("solrRequest")))) {
                    XMLUtils.createElement((ContentHandler)handler, (String)"solr-request", (String)solrRequest);
                }
                XMLUtils.endElement((ContentHandler)handler, (String)"variable");
            }
            XMLUtils.endElement((ContentHandler)handler, (String)"clauses-variables");
        }
    }

    private void _saxOptionalColumns(Map<String, Object> child, TransformerHandler handler) throws SAXException {
        Map data = (Map)child.get("data");
        List names = (List)data.get("names");
        if (null != names && !names.isEmpty()) {
            XMLUtils.startElement((ContentHandler)handler, (String)"optional-columns");
            for (String name : names) {
                XMLUtils.startElement((ContentHandler)handler, (String)"name");
                XMLUtils.data((ContentHandler)handler, (String)name.trim());
                XMLUtils.endElement((ContentHandler)handler, (String)"name");
            }
            XMLUtils.endElement((ContentHandler)handler, (String)"optional-columns");
        }
    }

    private void _saxExtractionComponent(Map<String, Object> component, TransformerHandler handler) throws SAXException {
        Map data = (Map)component.get("data");
        String tag = (String)component.get("tag");
        AttributesImpl attributes = this._getComponentAttibutes(data);
        XMLUtils.startElement((ContentHandler)handler, (String)tag, (Attributes)attributes);
        this._saxExtractionComponentClauses(data, handler);
        this._saxExtractionComponentGroupingFields(data, handler);
        this._saxExtractionComponentColumns(data, handler);
        this._saxExtractionComponentSorts(data, handler);
        if (component.get("children") != null) {
            List children = (List)component.get("children");
            for (Map child : children) {
                this._saxExtractionComponent(child, handler);
            }
        }
        XMLUtils.endElement((ContentHandler)handler, (String)tag);
    }

    private AttributesImpl _getComponentAttibutes(Map<String, Object> data) {
        Object maxLevel;
        Object microThesaurusId;
        Object queryReferenceId;
        List contentTypes;
        AttributesImpl attributes = new AttributesImpl();
        Object componentTagName = data.get("componentTagName");
        if (null != componentTagName && !StringUtils.isEmpty((CharSequence)((String)componentTagName))) {
            attributes.addCDATAAttribute("tagName", (String)componentTagName);
        }
        if (null != (contentTypes = (List)data.get("contentTypes")) && !contentTypes.isEmpty()) {
            attributes.addCDATAAttribute("contentTypes", String.join((CharSequence)",", contentTypes));
        }
        if (null != (queryReferenceId = data.get("queryReferenceId")) && !StringUtils.isEmpty((CharSequence)((String)queryReferenceId))) {
            attributes.addCDATAAttribute("ref", (String)queryReferenceId);
        }
        if (null != (microThesaurusId = data.get("microThesaurusId")) && !StringUtils.isEmpty((CharSequence)((String)microThesaurusId))) {
            attributes.addCDATAAttribute("microThesaurus", (String)microThesaurusId);
        }
        if (null != (maxLevel = data.get("maxLevel")) && !StringUtils.isEmpty((CharSequence)String.valueOf(maxLevel))) {
            attributes.addCDATAAttribute("max-level", String.valueOf(maxLevel));
        }
        return attributes;
    }

    private void _saxExtractionComponentClauses(Map<String, Object> data, TransformerHandler handler) throws SAXException {
        List clauses = (List)data.get("clauses");
        if (null != clauses && !clauses.isEmpty()) {
            XMLUtils.startElement((ContentHandler)handler, (String)"clauses");
            for (String clause : clauses) {
                XMLUtils.startElement((ContentHandler)handler, (String)"clause");
                XMLUtils.data((ContentHandler)handler, (String)clause);
                XMLUtils.endElement((ContentHandler)handler, (String)"clause");
            }
            XMLUtils.endElement((ContentHandler)handler, (String)"clauses");
        }
    }

    private void _saxExtractionComponentGroupingFields(Map<String, Object> data, TransformerHandler handler) throws SAXException {
        Object groupingFields = data.get("groupingFields");
        if (null == groupingFields || StringUtils.isEmpty((CharSequence)((String)groupingFields))) {
            return;
        }
        XMLUtils.startElement((ContentHandler)handler, (String)"grouping-fields");
        XMLUtils.data((ContentHandler)handler, (String)((String)groupingFields));
        XMLUtils.endElement((ContentHandler)handler, (String)"grouping-fields");
    }

    private void _saxExtractionComponentColumns(Map<String, Object> data, TransformerHandler handler) throws SAXException {
        Object columnsObj = data.get("columns");
        if (null == columnsObj || StringUtils.isEmpty((CharSequence)((String)columnsObj))) {
            return;
        }
        Map<String, String> columns = this._splitDataAndExtradataFromString((String)columnsObj);
        if (!columns.isEmpty()) {
            AttributesImpl columnsAttributes = new AttributesImpl();
            Object overrideColumns = data.get("overrideColumns");
            if (null != overrideColumns && ((Boolean)overrideColumns).booleanValue()) {
                columnsAttributes.addCDATAAttribute("override", "true");
            }
            XMLUtils.startElement((ContentHandler)handler, (String)"columns", (Attributes)columnsAttributes);
            for (Map.Entry<String, String> column : columns.entrySet()) {
                AttributesImpl columnAttributes = new AttributesImpl();
                if (column.getValue() != null) {
                    columnAttributes.addCDATAAttribute("optional", column.getValue());
                }
                XMLUtils.startElement((ContentHandler)handler, (String)"column", (Attributes)columnAttributes);
                XMLUtils.data((ContentHandler)handler, (String)column.getKey());
                XMLUtils.endElement((ContentHandler)handler, (String)"column");
            }
            XMLUtils.endElement((ContentHandler)handler, (String)"columns");
        }
    }

    private void _saxExtractionComponentSorts(Map<String, Object> data, TransformerHandler handler) throws SAXException {
        Object sortsObj = data.get("sorts");
        if (null == sortsObj || StringUtils.isEmpty((CharSequence)((String)sortsObj))) {
            return;
        }
        Map<String, String> sorts = this._splitDataAndExtradataFromString((String)sortsObj);
        if (!sorts.isEmpty()) {
            AttributesImpl sortsAttributes = new AttributesImpl();
            Object overrideSorts = data.get("overrideSorts");
            if (null != overrideSorts && ((Boolean)overrideSorts).booleanValue()) {
                sortsAttributes.addCDATAAttribute("override", "true");
            }
            XMLUtils.startElement((ContentHandler)handler, (String)"sorts", (Attributes)sortsAttributes);
            for (Map.Entry<String, String> sort : sorts.entrySet()) {
                AttributesImpl sortAttributes = new AttributesImpl();
                if (sort.getValue() != null) {
                    sortAttributes.addCDATAAttribute("order", sort.getValue());
                }
                XMLUtils.startElement((ContentHandler)handler, (String)"sort", (Attributes)sortAttributes);
                XMLUtils.data((ContentHandler)handler, (String)sort.getKey());
                XMLUtils.endElement((ContentHandler)handler, (String)"sort");
            }
            XMLUtils.endElement((ContentHandler)handler, (String)"sorts");
        }
    }

    private Map<String, String> _splitDataAndExtradataFromString(String str) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (String data : str.split(",")) {
            Pattern pattern = Pattern.compile(EXTRACT_EXTRA_DATA_REGEX);
            Matcher matcher = pattern.matcher(data);
            String extra = null;
            if (matcher.find()) {
                extra = matcher.group(1);
            }
            String finalData = data;
            if (null != extra) {
                extra = extra.trim();
                int indexOfExtra = data.indexOf("(");
                finalData = data.substring(0, indexOfExtra);
            }
            result.put(finalData.trim(), extra);
        }
        return result;
    }
}

