/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.extraction.execution;

import java.io.File;
import java.util.Map;
import org.ametys.core.right.RightManager;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.util.URIUtils;
import org.ametys.plugins.core.ui.parameter.files.AbstractGetFilesAction;
import org.ametys.runtime.util.AmetysHomeHelper;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.excalibur.source.TraversableSource;

public class GetExtractionResultFilesAction
extends AbstractGetFilesAction {
    private RightManager _rightManager;
    private CurrentUserProvider _currentUserProvider;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._rightManager = (RightManager)serviceManager.lookup(RightManager.ROLE);
        this._currentUserProvider = (CurrentUserProvider)serviceManager.lookup(CurrentUserProvider.ROLE);
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        if (this._rightManager.hasRight(this._currentUserProvider.getUser(), "Extraction_Rights_ExecuteExtraction", (Object)"/${WorkspaceName}") != RightManager.RightResult.RIGHT_ALLOW) {
            String errorMessage = "User " + String.valueOf(this._currentUserProvider.getUser()) + " try to list extraction result files with no sufficient rights";
            this.getLogger().error(errorMessage);
            throw new IllegalStateException(errorMessage);
        }
        return super.act(redirector, resolver, objectModel, source, parameters);
    }

    protected String getRootURI(Request request) {
        return new File(AmetysHomeHelper.getAmetysHomeData(), "extraction").toURI().toString();
    }

    protected Map<String, Object> _resource2JsonObject(TraversableSource file, TraversableSource root) {
        Map jsonObject = super._resource2JsonObject(file, root);
        String path = (String)jsonObject.get("path");
        jsonObject.put("downloadUrl", URIUtils.encodePath((String)path));
        return jsonObject;
    }
}

