/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.extraction.execution.pipeline.impl;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.core.util.SizeUtils;
import org.ametys.plugins.extraction.execution.pipeline.ExtractionMatcher;
import org.ametys.plugins.extraction.execution.pipeline.Pipeline;
import org.ametys.plugins.extraction.execution.pipeline.PipelineDescriptor;
import org.ametys.plugins.extraction.execution.pipeline.PipelineSerializerModel;
import org.ametys.plugins.extraction.execution.pipeline.PipelineSerializerModelExtensionPoint;
import org.ametys.plugins.extraction.execution.pipeline.impl.AllExtractionMatcher;
import org.ametys.plugins.extraction.execution.pipeline.impl.ListExtractionMatcher;
import org.ametys.plugins.extraction.execution.pipeline.impl.PipelineImpl;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.excalibur.source.SourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurablePipelineDescriptor
implements PipelineDescriptor,
Configurable {
    @SizeUtils.ExcludeFromSizeCalculation
    private static final Logger __LOGGER = LoggerFactory.getLogger(ConfigurablePipelineDescriptor.class);
    private static final String __DEFAULT_SERIALIZER = "xml";
    private String _id;
    private I18nizableText _label;
    private List<String> _extractions;
    private List<String> _xslts;
    private Map<String, String> _outputParams;
    @SizeUtils.ExcludeFromSizeCalculation
    private PipelineSerializerModel _serializer;
    @SizeUtils.ExcludeFromSizeCalculation
    private SourceResolver _resolver;
    @SizeUtils.ExcludeFromSizeCalculation
    private PipelineSerializerModelExtensionPoint _pipelineSerializers;

    public ConfigurablePipelineDescriptor(String id, SourceResolver resolver, PipelineSerializerModelExtensionPoint pipelineSerializers) {
        this._id = id;
        this._resolver = resolver;
        this._pipelineSerializers = pipelineSerializers;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this._label = I18nizableText.parseI18nizableText((Configuration)configuration.getChild("label"), (String)"application");
        this._extractions = new ArrayList<String>();
        for (Configuration extractionConf : configuration.getChild("extractions").getChildren("extraction")) {
            String filePath = extractionConf.getValue();
            this._extractions.add(filePath);
        }
        this._xslts = new ArrayList<String>();
        for (Configuration xsltConf : configuration.getChild("stylesheets").getChildren("xslt")) {
            String name = xsltConf.getAttribute("name");
            this._xslts.add(name);
        }
        this.setOutputParameters(configuration.getChild("out", false));
        String serializerType = this._outputParams.getOrDefault("type", __DEFAULT_SERIALIZER);
        this._serializer = (PipelineSerializerModel)this._pipelineSerializers.getExtension(serializerType);
        if (this._serializer == null) {
            __LOGGER.warn("The serializer type '{}' in <out> tag of the pipeline descriptor '{}' is invalid.", (Object)serializerType, (Object)this._id);
            this._serializer = (PipelineSerializerModel)this._pipelineSerializers.getExtension(__DEFAULT_SERIALIZER);
        }
    }

    @Override
    public I18nizableText getLabel() {
        return this._label;
    }

    @Override
    public ExtractionMatcher getExtractionMatcher() {
        return !this._extractions.isEmpty() ? new ListExtractionMatcher(this._extractions) : new AllExtractionMatcher();
    }

    @Override
    public List<String> getStylesheets() {
        return this._xslts;
    }

    @Override
    public PipelineSerializerModel getSerializerModel() {
        return this._serializer;
    }

    @Override
    public String getResultSubfolder() {
        return this._outputParams.getOrDefault("path", "");
    }

    @Override
    public String getDefaultExtension() {
        return this._outputParams.getOrDefault("extension", this._serializer.getDefaultFileExtension());
    }

    @Override
    public Pipeline newPipeline(OutputStream out) {
        return new PipelineImpl(this, out, this._resolver);
    }

    @Override
    public Map<String, String> getOutputParameters() {
        return this._outputParams;
    }

    protected void setOutputParameters(Configuration outputConf) throws ConfigurationException {
        this._outputParams = new HashMap<String, String>();
        if (outputConf != null) {
            for (String name : outputConf.getAttributeNames()) {
                this._outputParams.put(name, outputConf.getAttribute(name));
            }
        }
    }
}

