/*
 *  Copyright 2020 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * A tree presenting the extraction definition files
 * @private
 */
Ext.define('Ametys.plugins.extraction.execution.ExtractionResultsTree', {
    extend: "Ametys.file.AbstractFileExplorerTree",
    
    createTreeStore: function()
    {
        return Ext.create('Ext.data.TreeStore', {
            model: 'Ametys.plugins.extraction.execution.ExtractionResultFileNode',
            proxy: {
                type: 'ametys',
                plugin: 'extraction',
                url: 'result/files.json',
                reader: {
                    type: 'json',
                    rootProperty: 'nodes'
                }
            },
            folderSort: true,
            sorters: [{
                property: 'text',
                direction: 'ASC'
            }],
            root: {
                id: 'root',
                name: 'root',
                hasChild: true,
                editable: false,
                allowDrag: false,
                allowDrop: false,
                type: 'collection',
                iconCls: 'ametysicon-folder249',
                text: "{{i18n PLUGINS_EXTRACTION_RESULTS_TREE_ROOT_NODE_DEFAULT_TEXT}}",
                path: '',
                expanded: true,
                loaded: true // Prevent AJAX request
            }
        });
    },
    
    getMessageTargetIdForResource: function(type)
    {
        return Ametys.message.MessageTarget.EXTRACTION_DEFINITION_FILE;
    },
    
    getMessageTargetIdForCollection: function(type)
    {
        return Ametys.message.MessageTarget.EXTRACTION_DEFINITION_FOLDER;
    },

    /**
     * Get the message target configuration for given node
     * @param {Ext.data.Model} node The node.
     * @param {Boolean} busMessage True if it is for a bus message, false if it is for the drag and drop.
     */
    getMessageTargetConfiguration: function(node, busMessage)
    {
        if (busMessage && node.isRoot())
        {
            return {
                id: Ametys.message.MessageTarget.EXTRACTION_RESULT_ROOT
            }
        }
        else if (node.get('type') == Ametys.file.AbstractFileExplorerTree.TYPE_RESOURCE)
        {
            return {
                id: Ametys.message.MessageTarget.EXTRACTION_RESULT_FILE,
                parameters: {
                    path: node.get('path'),
                    downloadUrl: node.get('downloadUrl')
                }   
            }
        }
        else if (node.get('type') == Ametys.file.AbstractFileExplorerTree.TYPE_COLLECTION)
        {
            return {
                id: Ametys.message.MessageTarget.EXTRACTION_RESULT_FOLDER,
                parameters: {
                    path: node.get('path')
                }   
            }
        }
    },

    testTarget: function(target)
    {
        return target.getId() == Ametys.message.MessageTarget.EXTRACTION_RESULT_FILE || target.getId() == Ametys.message.MessageTarget.EXTRACTION_RESULT_FOLDER
    }
});
