/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.extraction.execution;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.ametys.cms.contenttype.ContentTypeExtensionPoint;
import org.ametys.plugins.core.user.UserHelper;
import org.ametys.plugins.extraction.component.AbstractExtractionComponent;
import org.ametys.plugins.extraction.component.CountExtractionComponent;
import org.ametys.plugins.extraction.component.ExtractionComponent;
import org.ametys.plugins.extraction.component.MappingQueryExtractionComponent;
import org.ametys.plugins.extraction.component.QueryExtractionComponent;
import org.ametys.plugins.extraction.component.ThesaurusExtractionComponent;
import org.ametys.plugins.extraction.execution.Extraction;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.LifecycleHelper;
import org.apache.commons.lang3.StringUtils;

public class ExtractionDefinitionReader
extends AbstractLogEnabled
implements Component,
Contextualizable,
Serviceable {
    public static final String ROLE = ExtractionDefinitionReader.class.getName();
    private Context _context;
    private ServiceManager _serviceManager;
    private UserHelper _userHelper;
    private AmetysObjectResolver _ametysResolver;
    private ContentTypeExtensionPoint _contentTypeExtensionPoint;

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public void service(ServiceManager manager) throws ServiceException {
        this._serviceManager = manager;
        this._userHelper = (UserHelper)manager.lookup(UserHelper.ROLE);
        this._ametysResolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._contentTypeExtensionPoint = (ContentTypeExtensionPoint)manager.lookup(ContentTypeExtensionPoint.ROLE);
    }

    public Extraction readExtractionDefinitionFile(File file) throws Exception {
        long startTime = -1L;
        if (this.getLogger().isDebugEnabled()) {
            startTime = System.currentTimeMillis();
            this.getLogger().debug("Reading definition file");
        }
        assert (file != null);
        Configuration configuration = new DefaultConfigurationBuilder().buildFromFile(file);
        Extraction extraction = new Extraction(file.getName());
        this._readExtractionDescription(configuration, extraction);
        this._readExtractionAuthor(configuration, extraction);
        this._readVariablesDefinition(configuration, extraction);
        this._readExtractionDefinitionFile(configuration, extraction);
        if (this.getLogger().isDebugEnabled()) {
            long endTime = System.currentTimeMillis();
            this.getLogger().debug("Read definition file in " + (endTime - startTime) + "ms");
        }
        return extraction;
    }

    public Extraction readVariablesDefinitionsInExtractionDefinitionFile(File file) throws Exception {
        assert (file != null);
        Configuration configuration = new DefaultConfigurationBuilder().buildFromFile(file);
        Extraction extraction = new Extraction(file.getName());
        this._readVariablesDefinition(configuration, extraction);
        return extraction;
    }

    private void _readExtractionDescription(Configuration configuration, Extraction extraction) {
        block3: {
            String descriptionId = configuration.getChild("description", true).getAttribute("id", null);
            if (StringUtils.isNotBlank((CharSequence)descriptionId)) {
                try {
                    this._ametysResolver.resolveById(descriptionId);
                    extraction.setDescriptionId(descriptionId);
                }
                catch (AmetysRepositoryException e) {
                    if (!this.getLogger().isWarnEnabled()) break block3;
                    this.getLogger().warn("Invalid extraction description " + descriptionId + " for configuration " + configuration.getLocation(), (Throwable)e);
                }
            }
        }
    }

    private void _readExtractionAuthor(Configuration configuration, Extraction extraction) throws ConfigurationException {
        Configuration author = configuration.getChild("author", false);
        if (author != null) {
            extraction.setAuthor(this._userHelper.xml2userIdentity(author));
        }
    }

    private void _readVariablesDefinition(Configuration configuration, Extraction extraction) throws ConfigurationException {
        block8: for (Configuration child : configuration.getChildren()) {
            switch (child.getName()) {
                case "optional-columns": {
                    extraction.setDisplayOptionalColumnsNames(this.getDisplayOptionalColumnNames(child));
                    continue block8;
                }
                case "clauses-variables": {
                    extraction.setClausesVariables(this.getClausesVariables(child));
                    continue block8;
                }
            }
        }
    }

    private void _readExtractionDefinitionFile(Configuration configuration, Extraction extraction) throws Exception {
        block9: for (Configuration child : configuration.getChildren()) {
            switch (child.getName()) {
                case "query": 
                case "thesaurus": 
                case "count": 
                case "mapping-query": {
                    ExtractionComponent component = this._processExtractionComponent(child);
                    extraction.addExtractionComponent(component);
                    continue block9;
                }
            }
        }
    }

    private List<String> getDisplayOptionalColumnNames(Configuration configuration) throws ConfigurationException {
        ArrayList<String> names = new ArrayList<String>();
        for (Configuration nameConfiguration : configuration.getChildren("name")) {
            names.add(nameConfiguration.getValue());
        }
        return names;
    }

    private List<Extraction.ClausesVariable> getClausesVariables(Configuration configuration) throws ConfigurationException {
        ArrayList<Extraction.ClausesVariable> variables = new ArrayList<Extraction.ClausesVariable>();
        for (Configuration variableConfiguration : configuration.getChildren("variable")) {
            String name = variableConfiguration.getAttribute("name", null);
            if (null == name) {
                throw new ConfigurationException("A clauses variable is not well defined, name is mandatory.");
            }
            String typeAsString = variableConfiguration.getAttribute("type", null);
            Extraction.ClausesVariableType type = typeAsString != null ? Extraction.ClausesVariableType.fromStringValue(typeAsString) : Extraction.ClausesVariableType.SELECT_CONTENTS;
            List<String> contentTypeIds = this._getClausesVariableContentTypeIds(variableConfiguration, type);
            Optional<String> searchModelId = this._getClausesVariableSearchModelId(variableConfiguration);
            Optional<String> solrRequest = this._getClausesVariableSolrRequest(variableConfiguration);
            variables.add(new Extraction.ClausesVariable(name, type, contentTypeIds, searchModelId, solrRequest));
        }
        return variables;
    }

    private List<String> _getClausesVariableContentTypeIds(Configuration variableConfiguration, Extraction.ClausesVariableType clausesVariableType) throws ConfigurationException {
        ArrayList<String> contentTypeIds = new ArrayList<String>();
        Optional.ofNullable(variableConfiguration.getAttribute("contentType", null)).ifPresent(contentTypeId -> contentTypeIds.add((String)contentTypeId));
        if (contentTypeIds.isEmpty()) {
            Configuration contentTypesConf = variableConfiguration.getChild("content-types");
            for (Configuration contentTypeConf : contentTypesConf.getChildren("content-type")) {
                String id = contentTypeConf.getAttribute("id");
                contentTypeIds.add(id);
            }
        }
        if (Extraction.ClausesVariableType.SELECT_CONTENTS.equals((Object)clausesVariableType) && contentTypeIds.size() > 1) {
            throw new ConfigurationException("Only one content type id can be provided for variables of type selectContents", variableConfiguration);
        }
        for (String contentTypeId2 : contentTypeIds) {
            if (this._contentTypeExtensionPoint.hasExtension(contentTypeId2)) continue;
            throw new ConfigurationException("Only one content type id can be provided for variables of type selectContents", variableConfiguration);
        }
        return contentTypeIds;
    }

    private Optional<String> _getClausesVariableSearchModelId(Configuration variableConfiguration) {
        String searchModelId = variableConfiguration.getChild("search-model-id").getValue(null);
        return Optional.ofNullable(searchModelId).filter(StringUtils::isNotEmpty);
    }

    private Optional<String> _getClausesVariableSolrRequest(Configuration variableConfiguration) {
        String solrRequest = variableConfiguration.getChild("solr-request").getValue(null);
        return Optional.ofNullable(solrRequest).filter(StringUtils::isNotEmpty);
    }

    private ExtractionComponent _processExtractionComponent(Configuration componentConfiguration) throws Exception {
        AbstractExtractionComponent component = null;
        switch (componentConfiguration.getName()) {
            case "query": {
                component = new QueryExtractionComponent();
                break;
            }
            case "count": {
                component = new CountExtractionComponent();
                break;
            }
            case "thesaurus": {
                component = new ThesaurusExtractionComponent();
                break;
            }
            case "mapping-query": {
                component = new MappingQueryExtractionComponent();
                break;
            }
        }
        if (component != null) {
            LifecycleHelper.setupComponent((Object)component, (Logger)this.getLogger(), (Context)this._context, (ServiceManager)this._serviceManager, (Configuration)componentConfiguration);
            for (Configuration child : componentConfiguration.getChildren()) {
                ExtractionComponent subComponent = this._processExtractionComponent(child);
                if (null == subComponent) continue;
                component.addSubComponent(subComponent);
            }
        }
        return component;
    }
}

