/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * Singleton class helper for thesaurus extraction components edition.
 * @private
 */
 Ext.define('Ametys.plugins.extraction.edition.EditThesaurusExtractionComponentDialog', {
    extend: "Ametys.plugins.extraction.edition.EditExtractionComponentDialog",
    singleton: true,
    
    /**
     * @protected
     * Retrieve the dialog title
     * @return {String} the dialog title
     */
    _getDialogTitle: function ()
    {
        if (this._mode == 'new')
        {
            return "{{i18n PLUGINS_EXTRACTION_ADD_THESAURUS_DIALOG_TITLE}}";
        }
        return "{{i18n PLUGINS_EXTRACTION_EDIT_THESAURUS_DIALOG_TITLE}}";
    },
    
    /**
     * @protected
     * Retrieve the dialog icon class
     * @return {String} the dialog icon class
     */
    _getDialogIconCls: function ()
    {
        return "ametysicon-books";
    },
    
    /**
     * @protected
     * Retrieves the form configuration elements
     * @param {Object} response needed information to configure form
     * @return {Object} the form configuration element
     */
    _getFormConfiguration: function(response)
    {
        var configuration = {};
        
        // Tag name field
        Ext.apply(configuration, this._getTagNameFormConfiguration());
        
        // Thesaurus name field
        configuration.thesaurusId = {
            type: 'string',
            label: "{{i18n PLUGINS_EXTRACTION_EDIT_NODE_THESAURUS_LABEL}}",
            description: "{{i18n PLUGINS_EXTRACTION_EDIT_NODE_THESAURUS_DESCRIPTION}}",
            enumeration: response.thesaurii,
            validation: {
                mandatory: true
            }
        };
        
        // Micro thesaurus name field
        configuration.microThesaurusId = {
            type: 'string',
            label: "{{i18n PLUGINS_EXTRACTION_EDIT_NODE_MICROTHESAURUS_LABEL}}",
            description: "{{i18n PLUGINS_EXTRACTION_EDIT_NODE_MICROTHESAURUS_DESCRIPTION}}",
            widget: 'edition.microthesaurii',
            'widget-params': {
                thesaurusField: 'thesaurusId'
            },
            validation: {
                mandatory: true
            }
        };
        
        // Max level field
        configuration.maxLevel = {
            type: 'long',
            label: "{{i18n PLUGINS_EXTRACTION_EDIT_NODE_MAX_LEVEL_LABEL}}",
            description: "{{i18n PLUGINS_EXTRACTION_EDIT_NODE_MAX_LEVEL_DESCRIPTION}}",
            'widget-params': {
                minValue: 1
            },
            validation: {
                mandatory: true
            }
        };
        
        return configuration;
    }
 });
 