/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.extraction.execution;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ametys.core.cache.AbstractCacheManager;
import org.ametys.core.cache.Cache;
import org.ametys.core.file.FileHelper;
import org.ametys.core.group.GroupIdentity;
import org.ametys.core.right.ProfileAssignmentStorage;
import org.ametys.core.right.ProfileAssignmentStorageExtensionPoint;
import org.ametys.core.right.RightManager;
import org.ametys.core.ui.Callable;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.core.user.UserHelper;
import org.ametys.plugins.extraction.execution.Extraction;
import org.ametys.plugins.extraction.execution.ExtractionDefinitionReader;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.TraversableSource;
import org.apache.excalibur.source.impl.FileSource;

public class ExtractionDAO
extends AbstractLogEnabled
implements Serviceable,
Component,
Initializable {
    public static final String ROLE = ExtractionDAO.class.getName();
    private static final String EXTRACTION_AUTHOR_CACHE = ExtractionDAO.class.getName() + "$extractionAuthor";
    private CurrentUserProvider _userProvider;
    private RightManager _rightManager;
    private SourceResolver _sourceResolver;
    private ExtractionDefinitionReader _definitionReader;
    private ProfileAssignmentStorageExtensionPoint _profileAssignmentStorageEP;
    private CurrentUserProvider _currentUserProvider;
    private AbstractCacheManager _cacheManager;
    private UserHelper _userHelper;
    private TraversableSource _root;
    private FileHelper _fileHelper;

    public void service(ServiceManager manager) throws ServiceException {
        this._userProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
        this._rightManager = (RightManager)manager.lookup(RightManager.ROLE);
        this._sourceResolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
        this._definitionReader = (ExtractionDefinitionReader)((Object)manager.lookup(ExtractionDefinitionReader.ROLE));
        this._profileAssignmentStorageEP = (ProfileAssignmentStorageExtensionPoint)manager.lookup(ProfileAssignmentStorageExtensionPoint.ROLE);
        this._currentUserProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
        this._cacheManager = (AbstractCacheManager)manager.lookup(AbstractCacheManager.ROLE);
        this._userHelper = (UserHelper)manager.lookup(UserHelper.ROLE);
        this._fileHelper = (FileHelper)manager.lookup(FileHelper.ROLE);
    }

    public void initialize() throws Exception {
        this._root = (TraversableSource)this._sourceResolver.resolveURI("context://WEB-INF/param/extraction/definitions/");
        this._cacheManager.createRequestCache(EXTRACTION_AUTHOR_CACHE, new I18nizableText("plugin.extraction", "PLUGINS_EXTRACTION_CACHE_DEFINITION_AUTHOR_LABEL"), new I18nizableText("plugin.extraction", "PLUGINS_EXTRACTION_CACHE_DEFINITION_AUTHOR_DESCRIPTION"), true);
    }

    @Callable(rights={"*"})
    public Map<String, Object> getRootProperties() throws IOException {
        String rootURI = "context://WEB-INF/param/extraction/definitions/";
        TraversableSource rootDir = (TraversableSource)this._sourceResolver.resolveURI(rootURI);
        Map<String, Object> infos = this.getExtractionContainerProperties(rootDir);
        return infos;
    }

    public Map<String, Object> getExtractionContainerProperties(TraversableSource folder) {
        HashMap<String, Object> infos = new HashMap<String, Object>();
        UserIdentity currentUser = this._userProvider.getUser();
        infos.put("canRead", this.canRead(currentUser, folder));
        infos.put("canRename", this.canRename(currentUser, folder));
        infos.put("canWrite", this.canWrite(currentUser, folder));
        infos.put("canDelete", this.canDelete(currentUser, folder));
        infos.put("canAssignRights", this.canAssignRights(currentUser, folder));
        return infos;
    }

    public Map<String, Object> getExtractionProperties(Extraction extraction, TraversableSource file) {
        HashMap<String, Object> infos = new HashMap<String, Object>();
        UserIdentity currentUser = this._userProvider.getUser();
        infos.put("descriptionId", extraction.getDescriptionId());
        UserIdentity author = extraction.getAuthor();
        infos.put("author", this._userHelper.user2json(author));
        infos.put("canRead", this.canRead(currentUser, file));
        infos.put("canWrite", this.canWrite(currentUser, file));
        infos.put("canDelete", this.canDelete(currentUser, file));
        infos.put("canAssignRights", this.canAssignRights(currentUser, file));
        return infos;
    }

    public Boolean hasAnyReadableDescendant(UserIdentity userIdentity, TraversableSource folder) {
        try {
            if (folder.exists()) {
                for (TraversableSource child : folder.getChildren()) {
                    if (!(child.isCollection() ? this.canRead(userIdentity, child) || this.hasAnyReadableDescendant(userIdentity, child) != false : child.getName().endsWith(".xml") && this.canRead(userIdentity, child))) continue;
                    return true;
                }
            }
            return false;
        }
        catch (SourceException e) {
            throw new RuntimeException("Cannot list child elements of " + folder.getURI(), e);
        }
    }

    public Boolean hasAnyWritableDescendant(UserIdentity userIdentity, TraversableSource folder) {
        return this.hasAnyWritableDescendant(userIdentity, folder, false);
    }

    public Boolean hasAnyWritableDescendant(UserIdentity userIdentity, TraversableSource folder, boolean ignoreExtraction) {
        try {
            if (folder.exists()) {
                for (TraversableSource child : folder.getChildren()) {
                    if (!(child.isCollection() ? this.canWrite(userIdentity, child) || this.hasAnyWritableDescendant(userIdentity, child) != false : !ignoreExtraction && child.getName().endsWith(".xml") && this.canWrite(userIdentity, child))) continue;
                    return true;
                }
            }
            return false;
        }
        catch (SourceException e) {
            throw new RuntimeException("Cannot list child elements of " + folder.getURI(), e);
        }
    }

    public boolean hasAnyAssignableDescendant(UserIdentity userIdentity, TraversableSource folder) {
        try {
            if (folder.exists()) {
                for (TraversableSource child : folder.getChildren()) {
                    if (!(child.isCollection() ? this.canAssignRights(userIdentity, child) || this.hasAnyAssignableDescendant(userIdentity, child) : child.getName().endsWith(".xml") && this.canAssignRights(userIdentity, child))) continue;
                    return true;
                }
            }
            return false;
        }
        catch (SourceException e) {
            throw new RuntimeException("Cannot list child elements of " + folder.getURI(), e);
        }
    }

    public boolean canRead(UserIdentity userIdentity, TraversableSource source) {
        return this._rightManager.hasReadAccess(userIdentity, (Object)source) || this.canWrite(userIdentity, source);
    }

    public boolean canWrite(UserIdentity userIdentity, TraversableSource source) {
        return this.canWrite(userIdentity, source, false);
    }

    public boolean canRename(UserIdentity userIdentity, TraversableSource folder) {
        try {
            return !this._isRoot(folder) && this.canWrite(userIdentity, folder) && this.canWrite(userIdentity, (TraversableSource)folder.getParent());
        }
        catch (SourceException e) {
            throw new RuntimeException("Unable to determine user rights on the extraction container " + folder.getURI(), e);
        }
    }

    public boolean canDelete(UserIdentity userIdentity, TraversableSource source) {
        try {
            return !this._isRoot(source) && this.canWrite(userIdentity, (TraversableSource)source.getParent()) && this.canWrite(userIdentity, source, true);
        }
        catch (SourceException e) {
            throw new RuntimeException("Unable to determine user rights on extraction container or file at uri " + source.getURI(), e);
        }
    }

    public boolean canWrite(UserIdentity userIdentity, TraversableSource source, boolean recursively) {
        boolean hasRight;
        boolean bl = hasRight = this._rightManager.hasRight(userIdentity, "Extraction_Rights_EditExtraction", (Object)source) == RightManager.RightResult.RIGHT_ALLOW;
        if (!hasRight) {
            return false;
        }
        try {
            if (recursively && source.isCollection()) {
                for (TraversableSource child : source.getChildren()) {
                    if (hasRight = hasRight && this.canWrite(userIdentity, child)) continue;
                    return false;
                }
            }
            return hasRight;
        }
        catch (SourceException e) {
            throw new RuntimeException("Unable to determine user rights on extraction container " + source.getURI(), e);
        }
    }

    public boolean canAssignRights(UserIdentity userIdentity, TraversableSource source) {
        try {
            return this._rightManager.hasRight(userIdentity, "Runtime_Rights_Rights_Handle", (Object)"/cms") == RightManager.RightResult.RIGHT_ALLOW || !this._isRoot(source) && this.canWrite(userIdentity, (TraversableSource)source.getParent()) && this.canWrite(userIdentity, source, true);
        }
        catch (SourceException e) {
            throw new RuntimeException("Unable to determine the user rights on the extraction container or file at uri " + source.getURI(), e);
        }
    }

    protected boolean _isRoot(TraversableSource folder) {
        return ExtractionDAO.trimLastFileSeparator(this._root.getURI()).equals(ExtractionDAO.trimLastFileSeparator(folder.getURI()));
    }

    public String getExtractionRightPath(TraversableSource source) {
        String rootURI = ExtractionDAO.trimLastFileSeparator(this._root.getURI());
        String sourceURI = source.getURI();
        if (!sourceURI.startsWith(rootURI)) {
            return null;
        }
        String relPath = StringUtils.substringAfter((String)ExtractionDAO.trimLastFileSeparator(sourceURI), (String)rootURI);
        if (relPath.startsWith("/")) {
            relPath = StringUtils.substringAfter((String)relPath, (String)"/");
        }
        return StringUtils.isEmpty((CharSequence)relPath) ? "/extraction-dir" : "/extraction-dir/" + relPath;
    }

    public TraversableSource getExtractionSource(String rightContext) throws IOException {
        if (rightContext.startsWith("/extraction-dir")) {
            String relPath = StringUtils.substringAfter((String)rightContext, (String)"/extraction-dir");
            String fileUri = "context://WEB-INF/param/extraction/definitions/" + relPath;
            return (TraversableSource)this._sourceResolver.resolveURI(fileUri);
        }
        return null;
    }

    public void copyRights(String sourceContext, String targetContext) {
        Map profilesForUsers = this._profileAssignmentStorageEP.getProfilesForUsers((Object)sourceContext, null);
        profilesForUsers.entrySet().forEach(entry -> this._copyAllowedUsers((UserIdentity)entry.getKey(), (Set)((Map)entry.getValue()).get(ProfileAssignmentStorage.UserOrGroup.ALLOWED), targetContext));
        profilesForUsers.entrySet().forEach(entry -> this._copyDeniedUsers((UserIdentity)entry.getKey(), (Set)((Map)entry.getValue()).get(ProfileAssignmentStorage.UserOrGroup.DENIED), targetContext));
        Map profilesForGroups = this._profileAssignmentStorageEP.getProfilesForGroups((Object)sourceContext, null);
        profilesForGroups.entrySet().forEach(entry -> this._copyAllowedGroups((GroupIdentity)entry.getKey(), (Set)((Map)entry.getValue()).get(ProfileAssignmentStorage.UserOrGroup.ALLOWED), targetContext));
        profilesForGroups.entrySet().forEach(entry -> this._copyDeniedGroups((GroupIdentity)entry.getKey(), (Set)((Map)entry.getValue()).get(ProfileAssignmentStorage.UserOrGroup.DENIED), targetContext));
        Map profilesForAnonymousOrAnyConnectedUser = this._profileAssignmentStorageEP.getProfilesForAnonymousAndAnyConnectedUser((Object)sourceContext);
        ((Set)profilesForAnonymousOrAnyConnectedUser.get(ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys.ANONYMOUS_ALLOWED)).forEach(profileId -> this._profileAssignmentStorageEP.allowProfileToAnonymous(profileId, (Object)targetContext));
        ((Set)profilesForAnonymousOrAnyConnectedUser.get(ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys.ANONYMOUS_DENIED)).forEach(profileId -> this._profileAssignmentStorageEP.denyProfileToAnonymous(profileId, (Object)targetContext));
        ((Set)profilesForAnonymousOrAnyConnectedUser.get(ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys.ANYCONNECTEDUSER_ALLOWED)).forEach(profileId -> this._profileAssignmentStorageEP.allowProfileToAnyConnectedUser(profileId, (Object)targetContext));
        ((Set)profilesForAnonymousOrAnyConnectedUser.get(ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys.ANYCONNECTEDUSER_DENIED)).forEach(profileId -> this._profileAssignmentStorageEP.denyProfileToAnyConnectedUser(profileId, (Object)targetContext));
    }

    private void _copyAllowedUsers(UserIdentity userIdentity, Set<String> profiles, String context) {
        profiles.forEach(profile -> this._profileAssignmentStorageEP.allowProfileToUser(userIdentity, profile, (Object)context));
    }

    private void _copyDeniedUsers(UserIdentity userIdentity, Set<String> profiles, String context) {
        profiles.forEach(profile -> this._profileAssignmentStorageEP.denyProfileToUser(userIdentity, profile, (Object)context));
    }

    private void _copyAllowedGroups(GroupIdentity groupIdentity, Set<String> profiles, String context) {
        profiles.forEach(profile -> this._profileAssignmentStorageEP.allowProfileToGroup(groupIdentity, profile, (Object)context));
    }

    private void _copyDeniedGroups(GroupIdentity groupIdentity, Set<String> profiles, String context) {
        profiles.forEach(profile -> this._profileAssignmentStorageEP.denyProfileToGroup(groupIdentity, profile, (Object)context));
    }

    public void deleteRights(String context) {
        Map profilesForUsers = this._profileAssignmentStorageEP.getProfilesForUsers((Object)context, null);
        profilesForUsers.entrySet().forEach(entry -> this._removeAllowedUsers((UserIdentity)entry.getKey(), (Set)((Map)entry.getValue()).get(ProfileAssignmentStorage.UserOrGroup.ALLOWED), context));
        profilesForUsers.entrySet().forEach(entry -> this._removeDeniedUsers((UserIdentity)entry.getKey(), (Set)((Map)entry.getValue()).get(ProfileAssignmentStorage.UserOrGroup.DENIED), context));
        Map profilesForGroups = this._profileAssignmentStorageEP.getProfilesForGroups((Object)context, null);
        profilesForGroups.entrySet().forEach(entry -> this._removeAllowedGroups((GroupIdentity)entry.getKey(), (Set)((Map)entry.getValue()).get(ProfileAssignmentStorage.UserOrGroup.ALLOWED), context));
        profilesForGroups.entrySet().forEach(entry -> this._removeDeniedGroups((GroupIdentity)entry.getKey(), (Set)((Map)entry.getValue()).get(ProfileAssignmentStorage.UserOrGroup.DENIED), context));
        Map profilesForAnonymousOrAnyConnectedUser = this._profileAssignmentStorageEP.getProfilesForAnonymousAndAnyConnectedUser((Object)context);
        ((Set)profilesForAnonymousOrAnyConnectedUser.get(ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys.ANONYMOUS_ALLOWED)).forEach(profileId -> this._profileAssignmentStorageEP.removeAllowedProfileFromAnonymous(profileId, (Object)context));
        ((Set)profilesForAnonymousOrAnyConnectedUser.get(ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys.ANONYMOUS_DENIED)).forEach(profileId -> this._profileAssignmentStorageEP.removeDeniedProfileFromAnonymous(profileId, (Object)context));
        ((Set)profilesForAnonymousOrAnyConnectedUser.get(ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys.ANYCONNECTEDUSER_ALLOWED)).forEach(profileId -> this._profileAssignmentStorageEP.removeAllowedProfileFromAnyConnectedUser(profileId, (Object)context));
        ((Set)profilesForAnonymousOrAnyConnectedUser.get(ProfileAssignmentStorage.AnonymousOrAnyConnectedKeys.ANYCONNECTEDUSER_DENIED)).forEach(profileId -> this._profileAssignmentStorageEP.removeDeniedProfileFromAnyConnectedUser(profileId, (Object)context));
    }

    private void _removeAllowedUsers(UserIdentity userIdentity, Set<String> profiles, String context) {
        profiles.forEach(profile -> this._profileAssignmentStorageEP.removeAllowedProfileFromUser(userIdentity, profile, (Object)context));
    }

    private void _removeDeniedUsers(UserIdentity userIdentity, Set<String> profiles, String context) {
        profiles.forEach(profile -> this._profileAssignmentStorageEP.removeDeniedProfileFromUser(userIdentity, profile, (Object)context));
    }

    private void _removeAllowedGroups(GroupIdentity groupIdentity, Set<String> profiles, String context) {
        profiles.forEach(profile -> this._profileAssignmentStorageEP.removeAllowedProfileFromGroup(groupIdentity, profile, (Object)context));
    }

    private void _removeDeniedGroups(GroupIdentity groupIdentity, Set<String> profiles, String context) {
        profiles.forEach(profile -> this._profileAssignmentStorageEP.removeDeniedProfileFromGroup(groupIdentity, profile, (Object)context));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callable(rights={"Extraction_Rights_EditExtraction"})
    public Map<String, Object> moveOrRenameExtractionDefinitionFile(String srcRelPath, String targetRelPath) throws IOException {
        Map<Object, Object> result = new HashMap();
        FileSource srcFile = null;
        FileSource targetFile = null;
        try {
            srcFile = (FileSource)this._sourceResolver.resolveURI("context://WEB-INF/param/extraction/definitions/" + srcRelPath);
            targetFile = (FileSource)this._sourceResolver.resolveURI("context://WEB-INF/param/extraction/definitions/" + targetRelPath);
            String sourceContext = "/extraction-dir/" + srcRelPath;
            String targetContext = "/extraction-dir/" + targetRelPath;
            result = this._moveOrRenameSource(srcFile, targetFile, sourceContext, targetContext);
            if (result.containsKey("uri")) {
                String newURI = (String)result.get("uri");
                String path = newURI.substring(this._root.getURI().length());
                result.put("path", path);
            }
        }
        catch (Throwable throwable) {
            this._sourceResolver.release(srcFile);
            this._sourceResolver.release(targetFile);
            throw throwable;
        }
        this._sourceResolver.release((Source)srcFile);
        this._sourceResolver.release((Source)targetFile);
        return result;
    }

    private Map<String, Object> _moveOrRenameSource(FileSource sourceFile, FileSource targetFile, String sourceContext, String targetContext) throws IOException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (!StringUtils.startsWith((CharSequence)sourceFile.getURI(), (CharSequence)this._root.getURI()) || !StringUtils.startsWith((CharSequence)targetFile.getURI(), (CharSequence)this._root.getURI())) {
            result.put("success", false);
            result.put("error", "no-exists");
            this.getLogger().error("User '{}' tried to  move parameter file outside of the root extraction directory.", (Object)this._currentUserProvider.getUser());
            return result;
        }
        if (!sourceFile.exists()) {
            result.put("success", false);
            result.put("error", "no-exists");
            return result;
        }
        if (targetFile.exists()) {
            if (sourceFile.getFile().equals(targetFile.getFile())) {
                result.put("success", true);
                result.put("name", targetFile.getName());
                result.put("uri", targetFile.getURI());
                return result;
            }
            result.put("success", false);
            result.put("error", "already-exists");
            return result;
        }
        this.copyRightsRecursively(sourceContext, targetContext, (TraversableSource)sourceFile);
        if (sourceFile.getFile().isFile()) {
            FileUtils.moveFile((File)sourceFile.getFile(), (File)targetFile.getFile());
        } else {
            FileUtils.moveDirectory((File)sourceFile.getFile(), (File)targetFile.getFile());
        }
        this.deleteRightsRecursively(sourceContext, (TraversableSource)targetFile);
        result.put("success", true);
        result.put("name", targetFile.getName());
        result.put("uri", targetFile.getURI());
        return result;
    }

    public void copyRightsRecursively(String sourceContext, String targetContext, TraversableSource file) {
        this.copyRights(sourceContext, targetContext);
        if (file.isCollection()) {
            try {
                for (TraversableSource child : file.getChildren()) {
                    this.copyRightsRecursively(sourceContext + "/" + child.getName(), targetContext + "/" + child.getName(), child);
                }
            }
            catch (SourceException e) {
                throw new RuntimeException("Cannot list child elements of " + file.getURI(), e);
            }
        }
    }

    public void deleteRightsRecursively(String context, TraversableSource file) {
        this.deleteRights(context);
        if (file.isCollection()) {
            try {
                for (TraversableSource child : file.getChildren()) {
                    this.deleteRightsRecursively(context + "/" + child.getName(), child);
                }
            }
            catch (SourceException e) {
                throw new RuntimeException("Cannot list child elements of " + file.getURI(), e);
            }
        }
    }

    public UserIdentity getAuthor(FileSource extractionPath) {
        return (UserIdentity)this._getExtractionAuthorCache().get((Object)extractionPath, path -> this._getUserIdentityByExtractionFile((FileSource)path));
    }

    private UserIdentity _getUserIdentityByExtractionFile(FileSource extractionPath) {
        try {
            Extraction extraction = this._definitionReader.readExtractionDefinitionFile(extractionPath.getFile());
            return extraction.getAuthor();
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot read extraction " + String.valueOf(extractionPath), e);
        }
    }

    private Cache<FileSource, UserIdentity> _getExtractionAuthorCache() {
        return this._cacheManager.get(EXTRACTION_AUTHOR_CACHE);
    }

    public static String trimLastFileSeparator(String uri) {
        return StringUtils.endsWith((CharSequence)uri, (CharSequence)"/") ? StringUtils.substringBeforeLast((String)uri, (String)"/") : uri;
    }

    @Callable(rights={"Runtime_Rights_Rights_Handle", "Extraction_Rights_ExecuteExtraction"})
    public List<String> getFilteredPath(String path, String value) {
        try {
            TraversableSource currentSrc = (TraversableSource)this._sourceResolver.resolveURI("context://WEB-INF/param/extraction/definitions/" + (String)(path.length() > 0 ? "/" + path : ""));
            List result = this._fileHelper.filterSources(currentSrc, value);
            return result.stream().map(this::_toRelativePath).toList();
        }
        catch (IOException e) {
            this.getLogger().error("Failed to filter extraction definition at path '" + path + "'", (Throwable)e);
            return List.of();
        }
    }

    private String _toRelativePath(String absoluteURI) {
        return StringUtils.substringAfter((String)ExtractionDAO.trimLastFileSeparator(absoluteURI), (String)ExtractionDAO.trimLastFileSeparator(this._root.getURI()));
    }
}

