/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.extraction.execution.pipeline;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Optional;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.ametys.core.util.LambdaUtils;

public final class Pipelines {
    private static SAXTransformerFactory __transformerFactory;

    private Pipelines() {
    }

    public static SAXTransformerFactory getSaxTransformerFactory() {
        if (__transformerFactory == null) {
            __transformerFactory = (SAXTransformerFactory)TransformerFactory.newInstance();
        }
        return __transformerFactory;
    }

    public static OutputStream getOutputStream(Path outputFile) throws IOException {
        outputFile.getParent().toFile().mkdirs();
        OutputStream resultOs = Files.newOutputStream(outputFile, new OpenOption[0]);
        return resultOs;
    }

    public static StreamResult setResult(TransformerHandler transformerHandler, OutputStream outputStream) throws IOException {
        StreamResult streamResult = new StreamResult(outputStream);
        transformerHandler.setResult(streamResult);
        return streamResult;
    }

    public static void close(StreamResult result) {
        Optional.ofNullable(result).map(StreamResult::getOutputStream).ifPresent(LambdaUtils.wrapConsumer(OutputStream::close));
    }
}

