/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.extraction.execution.pipeline.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.stream.Collector;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamSource;
import org.ametys.core.util.LambdaUtils;
import org.ametys.plugins.extraction.execution.pipeline.Pipeline;
import org.ametys.plugins.extraction.execution.pipeline.PipelineDescriptor;
import org.ametys.plugins.extraction.execution.pipeline.PipelineSerializerModel;
import org.ametys.plugins.extraction.execution.pipeline.Pipelines;
import org.ametys.plugins.extraction.execution.pipeline.impl.PipelineSerializer;
import org.apache.cocoon.components.xslt.TraxErrorListener;
import org.apache.cocoon.util.log.SLF4JLoggerAdapter;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.impl.FileSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;

class PipelineImpl
implements Pipeline {
    private static final Logger __LOGGER = LoggerFactory.getLogger(Pipeline.class);
    private static final org.apache.avalon.framework.logger.Logger __AVALON_LOGGER = new SLF4JLoggerAdapter(__LOGGER);
    private PipelineDescriptor _desc;
    private OutputStream _out;
    private SourceResolver _resolver;
    private List<Source> _sources = new ArrayList<Source>();
    private TransformerHandler _firstHandler;
    private TransformerHandler _lastHandler;
    private PipelineSerializer _serializer;

    PipelineImpl(PipelineDescriptor desc, OutputStream out, SourceResolver resolver) {
        this._desc = desc;
        this._out = out;
        this._resolver = resolver;
    }

    @Override
    public ContentHandler getHandler() throws Exception {
        if (this._firstHandler != null || this._lastHandler != null) {
            throw new IllegalStateException("Pipeline was already opened.");
        }
        SAXTransformerFactory stf = Pipelines.getSaxTransformerFactory();
        if (this._desc.getStylesheets().isEmpty()) {
            this._lastHandler = this._firstHandler = stf.newTransformerHandler();
        } else {
            this._getTransformerHandler(stf);
        }
        PipelineSerializerModel serializerModel = this._desc.getSerializerModel();
        this._serializer = serializerModel.newSerializer(this._lastHandler, this._out, this._desc.getOutputParameters());
        this._serializer.prepare();
        return this._firstHandler;
    }

    private void _getTransformerHandler(SAXTransformerFactory stf) {
        TransformerHandler currentHandler;
        String suffix = "context://WEB-INF/param/extraction/stylesheets//";
        Queue xslts = this._desc.getStylesheets().stream().map("context://WEB-INF/param/extraction/stylesheets//"::concat).map(LambdaUtils.wrap(arg_0 -> ((SourceResolver)this._resolver).resolveURI(arg_0))).map(LambdaUtils.wrap(source -> this._newTransformerHandler(stf, (Source)source))).collect(Collector.of(ArrayDeque::new, (deque, th) -> deque.add(th), (deque1, deque2) -> {
            throw new IllegalStateException("Should not be parallel");
        }, new Collector.Characteristics[0]));
        this._firstHandler = (TransformerHandler)xslts.element();
        while (true) {
            currentHandler = (TransformerHandler)xslts.remove();
            if (xslts.isEmpty()) break;
            currentHandler.setResult(new SAXResult((ContentHandler)xslts.element()));
        }
        this._lastHandler = currentHandler;
    }

    private TransformerHandler _newTransformerHandler(SAXTransformerFactory stf, Source source) throws TransformerConfigurationException {
        this._sources.add(source);
        String uri = source.getURI();
        this._checkExists(source, uri);
        FileSource fileSource = this._checkFileSource(source, uri);
        StreamSource streamSource = new StreamSource(fileSource.getFile());
        Templates templates = stf.newTemplates(streamSource);
        TransformerHandler th = stf.newTransformerHandler(templates);
        TraxErrorListener errorListener = new TraxErrorListener(__AVALON_LOGGER, uri);
        th.getTransformer().setErrorListener((ErrorListener)errorListener);
        return th;
    }

    private void _checkExists(Source s, String uri) {
        boolean exists = s.exists();
        if (!exists) {
            throw new IllegalArgumentException("XSL file '" + uri + " does not exist. The pipeline cannot be executed.");
        }
    }

    private FileSource _checkFileSource(Source source, String uri) {
        if (source instanceof FileSource) {
            return (FileSource)source;
        }
        throw new IllegalArgumentException("Source '" + uri + " is not a file source. The pipeline cannot be executed.");
    }

    @Override
    public void serialize() throws Exception {
        this._serializer.serialize();
    }

    @Override
    public void close() throws IOException {
        this._release();
        if (this._serializer != null) {
            this._serializer.close();
        }
    }

    private void _release() {
        if (this._resolver != null) {
            this._sources.forEach(arg_0 -> ((SourceResolver)this._resolver).release(arg_0));
        }
    }
}

