/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * Singleton class helper for extraction components managing groups edition.
 * @private
 */
 Ext.define('Ametys.plugins.extraction.edition.EditGroupExtractionComponentDialog', {
    extend: "Ametys.plugins.extraction.edition.EditSolrExtractionComponentDialog",
    
    /**
     * @protected
     * Retrieves the form configuration for grouping fields
     * @return {Object} the grouping fields form configuration element
     */
    _getGroupingFieldsFormConfiguration: function()
    {
        var configuration = {};
        
        // Grouping fields field
        var groupingFieldsWidgetParams = {};
        Ext.apply(groupingFieldsWidgetParams, this._codeWidgetParams);
        Ext.apply(groupingFieldsWidgetParams, {height: 44, mode: 'solr-ametys-columns'});
        configuration.groupingFields = {
            type: 'string',
            label: "{{i18n PLUGINS_EXTRACTION_EDIT_NODE_GROUPING_FIELDS_LABEL}}",
            description: "{{i18n PLUGINS_EXTRACTION_EDIT_NODE_GROUPING_FIELDS_DESCRIPTION}}",
            validation: {
                regexp: '^\\w[\\w-\\.]*(\\s*,\\s*\\w[\\w-\\.]*)*$',
                regexText: "{{i18n PLUGINS_EXTRACTION_EDIT_NODE_GROUPING_FIELDS_REGEX_TEXT}}"
            },
            widget: 'edition.solr-code',
            'widget-params': groupingFieldsWidgetParams
        };
        
        return configuration;
    },
    
    _getInitFormCreationValues: function()
    {
        var fromParent = this.callParent(arguments);
        var values = fromParent.values;
        var repeaters = fromParent.repeaters;
    
        return {
            values: values,
            repeaters: repeaters
        };
    }
 });
 