/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.extraction.component;

import java.util.Map;

import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.ContentHandler;

import org.ametys.cms.repository.Content;
import org.ametys.plugins.extraction.ExtractionConstants;
import org.ametys.plugins.extraction.execution.ExtractionExecutionContext;
import org.ametys.plugins.extraction.execution.ExtractionExecutionContextHierarchyElement;

/**
 * This class represents a mapping query component of the extraction module
 */
public class MappingQueryExtractionComponent extends AbstractSolrExtractionComponent
{
    @Override
    public void configure(Configuration configuration) throws ConfigurationException
    {
        String tagName = configuration.getAttribute("tagName", null);
        if (tagName != null && !StringUtils.isEmpty(tagName))
        {
            throw new IllegalArgumentException(getLogsPrefix() + "a maping query component can't have a tagName attribute");
        }
        
        super.configure(configuration);
    }

    @Override
    protected void processContents(Iterable<Content> contents, ContentHandler contentHandler, ExtractionExecutionContext context) throws Exception
    {
        if (contents.iterator().hasNext())
        {
            ExtractionExecutionContextHierarchyElement currentContext = new ExtractionExecutionContextHierarchyElement(this, contents);
            executeSubComponents(contentHandler, context, currentContext);
        }
    }
    
    @Override
    public Map<String, Object> getComponentDetailsForTree()
    {
        Map<String, Object> details = super.getComponentDetailsForTree();
        details.put("text", "mapping-query");
        details.put("tag", ExtractionConstants.MAPPING_QUERY_COMPONENT_TAG);
        details.put("iconCls", "ametysicon-squares");
        return details;
    }

    @Override
    protected String getDefaultTagName()
    {
        return null;
    }
    
    @Override
    protected String getLogsPrefix()
    {
        return "Mapping-query component: ";
    }
}
