/*
 *  Copyright 2018 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.extraction.execution.pipeline.impl;

import java.io.OutputStream;
import java.util.Map;
import java.util.Properties;

import javax.xml.transform.OutputKeys;
import javax.xml.transform.sax.TransformerHandler;

import org.ametys.plugins.extraction.execution.pipeline.PipelineSerializerModel;

/**
 * Model for text pipeline serializers
 */
public class TextPipelineSerializerModel implements PipelineSerializerModel
{
    @Override
    public String getDefaultFileExtension()
    {
        return "txt";
    }
    
    @Override
    public PipelineSerializer newSerializer(TransformerHandler handler, OutputStream out, Map<String, String> outputParameters)
    {
        return new TextPipelineSerializer(handler, out, outputParameters);
    }
    
    private static final class TextPipelineSerializer extends AbstractSerializerImpl
    {
        TextPipelineSerializer(TransformerHandler handler, OutputStream out, Map<String, String> outputParameters)
        {
            super(handler, out);
            _setOutputProps(outputParameters);
        }
        
        private void _setOutputProps(Map<String, String> outputParameters)
        {
            Properties properties = new Properties();
            properties.put(OutputKeys.METHOD, outputParameters.getOrDefault("method", "text"));
            properties.put(OutputKeys.ENCODING, outputParameters.getOrDefault("encoding", "UTF-8"));
            _handler.getTransformer().setOutputProperties(properties);
        }
        
        @Override
        public void serialize() throws Exception
        {
            // Nothing
        }
    }
}
