/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.extraction.execution;

import java.lang.invoke.CallSite;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ametys.cms.contenttype.ContentType;
import org.ametys.cms.contenttype.ContentTypeExtensionPoint;
import org.ametys.cms.repository.Content;
import org.ametys.core.util.FilenameUtils;
import org.ametys.plugins.extraction.component.AbstractSolrExtractionComponent;
import org.ametys.plugins.extraction.component.ExtractionComponent;
import org.ametys.plugins.extraction.edition.EditExtractionNodeManager;
import org.ametys.plugins.extraction.execution.Extraction;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.ModelHelper;
import org.ametys.runtime.model.type.ElementType;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;

public class PathResolver
extends AbstractLogEnabled
implements Component,
Serviceable {
    public static final String ROLE = PathResolver.class.getName();
    private static final List<Character> __PATH_SEPARATORS = Arrays.asList(Character.valueOf('/'), Character.valueOf('\\'));
    private static final Pattern __VARIABLE_REGEXP_PATTERN = Pattern.compile("\\$\\{([\\w-\\/]*)\\}");
    private static final String __NO_VALUE_OR_BLANK_FOLDER_NAME = "_NOVALUE_";
    private EditExtractionNodeManager _editExtractionNodeManager;
    private ContentTypeExtensionPoint _contentTypeExtensionPoint;

    public void service(ServiceManager manager) throws ServiceException {
        this._editExtractionNodeManager = (EditExtractionNodeManager)((Object)manager.lookup(EditExtractionNodeManager.ROLE));
        this._contentTypeExtensionPoint = (ContentTypeExtensionPoint)manager.lookup(ContentTypeExtensionPoint.ROLE);
    }

    public boolean hasVariable(String path) {
        Matcher m = __VARIABLE_REGEXP_PATTERN.matcher(path);
        return m.find();
    }

    public boolean isFolder(String path) {
        PathWrapper unresolvedPath = this._splitPathElements(path);
        if (path.isEmpty()) {
            return true;
        }
        List<String> elements = unresolvedPath.getElements();
        String lastElement = elements.get(elements.size() - 1);
        Matcher m = __VARIABLE_REGEXP_PATTERN.matcher(lastElement);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            m.group(1);
            m.appendReplacement(sb, "");
        }
        m.appendTail(sb);
        return !sb.toString().contains(".");
    }

    public Map<Path, List<Content>> resolvePath(String path, List<Content> contents, Extraction extraction, Path basePath) throws IllegalArgumentException {
        PathWrapper unresolvedPath = this._splitPathElements(path);
        Collection<ContentType> contentTypes = this._getFirstLevelContentTypes(extraction);
        HashSet<String> variableNames = new HashSet<String>();
        for (String element : unresolvedPath.getElements()) {
            this._fillVariableNames(contentTypes, element, variableNames);
        }
        if (variableNames.isEmpty()) {
            return Collections.singletonMap(this._toPath(this._validPath(unresolvedPath), basePath), null);
        }
        Map<Content, Set<PathWrapper>> pathByContent = this._pathByContent(unresolvedPath, Optional.ofNullable(contents).orElse(Collections.emptyList()));
        Map<PathWrapper, List<Content>> contentsByPath = this._contentsByPath(pathByContent);
        return contentsByPath.entrySet().stream().collect(Collectors.toMap(e -> this._toPath((PathWrapper)e.getKey(), basePath), e -> (List)e.getValue()));
    }

    private PathWrapper _validPath(PathWrapper pathWithNoVar) {
        List<String> pathElements = pathWithNoVar.getElements();
        if (pathElements.size() == 1 && "".equals(pathElements.get(0))) {
            return pathWithNoVar;
        }
        return new PathWrapper(pathElements.stream().map(this::_validPathElementName).collect(Collectors.toList()));
    }

    private Path _toPath(PathWrapper resolvedPath, Path basePath) {
        List<String> elements = resolvedPath.getElements();
        return Paths.get(basePath.toString(), elements.toArray(new String[elements.size()]));
    }

    private PathWrapper _splitPathElements(String path) {
        ArrayList<String> res = new ArrayList<String>();
        boolean previousCharWasDollar = false;
        boolean inVariable = false;
        int start = 0;
        int end = 0;
        for (int i = 0; i < path.length(); ++i) {
            char currentChar = path.charAt(i);
            if (!inVariable && __PATH_SEPARATORS.contains(Character.valueOf(currentChar))) {
                end = i;
                res.add(path.substring(start, end));
                start = i + 1;
            } else if (!inVariable && currentChar == '$') {
                previousCharWasDollar = true;
            } else if (!inVariable && previousCharWasDollar && currentChar == '{') {
                inVariable = true;
            } else if (inVariable && currentChar == '}') {
                inVariable = false;
            }
            if (currentChar == '$') continue;
            previousCharWasDollar = false;
        }
        res.add(path.substring(start, path.length()));
        return new PathWrapper(res);
    }

    private void _fillVariableNames(Collection<ContentType> contentTypes, String element, Set<String> variableNames) throws IllegalArgumentException {
        Matcher m = __VARIABLE_REGEXP_PATTERN.matcher(element);
        while (m.find()) {
            String variableName = m.group(1);
            if (ModelHelper.hasModelItem((String)variableName, contentTypes) && ModelHelper.getModelItem((String)variableName, contentTypes) instanceof ElementDefinition) {
                variableNames.add(variableName);
                continue;
            }
            throw new IllegalArgumentException("The variable named '" + variableName + "' can not be used in the extraction result path. It is not an attribute of the defined content types");
        }
    }

    private Collection<ContentType> _getFirstLevelContentTypes(Extraction extraction) {
        return extraction.getExtractionComponents().stream().map(this::_getContentTypeIds).flatMap(Collection::stream).map(arg_0 -> ((ContentTypeExtensionPoint)this._contentTypeExtensionPoint).getExtension(arg_0)).collect(Collectors.toList());
    }

    private Collection<String> _getContentTypeIds(ExtractionComponent component) {
        String queryReferenceId;
        if (component instanceof AbstractSolrExtractionComponent && StringUtils.isNotEmpty((CharSequence)(queryReferenceId = ((AbstractSolrExtractionComponent)component).getQueryReferenceId()))) {
            return this._editExtractionNodeManager.getSavedQueryContentTypes(queryReferenceId);
        }
        return component.getContentTypes();
    }

    private Map<Content, Set<PathWrapper>> _pathByContent(PathWrapper unresolvedPath, List<Content> contents) {
        HashMap<Content, Set<PathWrapper>> pathByContent = new HashMap<Content, Set<PathWrapper>>();
        for (Content content : contents) {
            List<Set<String>> pathElements = this._resolvePath(unresolvedPath, content);
            Set<PathWrapper> allPaths = this._getAllPaths(pathElements);
            pathByContent.put(content, allPaths);
        }
        return pathByContent;
    }

    private List<Set<String>> _resolvePath(PathWrapper unresolvedPath, Content content) {
        ArrayList<Set<String>> resolvedPathElements = new ArrayList<Set<String>>();
        for (String element : unresolvedPath.getElements()) {
            Set<String> resolvedElements = this._resolvePathElement(element, content);
            resolvedPathElements.add(this._validPathElementNames(resolvedElements));
        }
        return resolvedPathElements;
    }

    private Set<String> _resolvePathElement(String unresolvedElement, Content content) {
        HashMap<CallSite, Set<String>> replacements = new HashMap<CallSite, Set<String>>();
        Matcher m = __VARIABLE_REGEXP_PATTERN.matcher(unresolvedElement);
        while (m.find()) {
            String variableName = m.group(1);
            ElementType type = (ElementType)content.getType(variableName);
            Object variableValue = content.getValue(variableName, true);
            Set<String> strValues = this._getStringValues(type, variableValue);
            replacements.put((CallSite)((Object)("${" + variableName + "}")), strValues);
        }
        Set<String> pathElements = Collections.singleton(unresolvedElement);
        for (String toReplace : replacements.keySet()) {
            pathElements = this._replace(toReplace, (Set)replacements.get(toReplace), pathElements);
        }
        return pathElements;
    }

    private Set<String> _getStringValues(ElementType type, Object value) {
        Stream<Object> values = Stream.empty();
        values = type.getManagedClassArray().isInstance(value) ? Arrays.stream((Object[])value) : Collections.singleton(value).stream();
        Set<String> strValues = values.filter(Objects::nonNull).map(arg_0 -> ((ElementType)type).toString(arg_0)).collect(Collectors.toSet());
        if (strValues.isEmpty()) {
            strValues = Collections.singleton(__NO_VALUE_OR_BLANK_FOLDER_NAME);
        }
        return strValues;
    }

    private Set<String> _replace(String toReplace, Set<String> replaceBy, Set<String> uncompleteElements) {
        HashSet<String> newPossibleElements = new HashSet<String>();
        for (String singleReplaceBy : replaceBy) {
            for (String uncompleteElement : uncompleteElements) {
                newPossibleElements.add(uncompleteElement.replace(toReplace, singleReplaceBy));
            }
        }
        return newPossibleElements;
    }

    private Set<String> _validPathElementNames(Set<String> elements) {
        return elements.stream().map(this::_validPathElementName).collect(Collectors.toSet());
    }

    private String _validPathElementName(String element) {
        return StringUtils.isBlank((CharSequence)element) ? __NO_VALUE_OR_BLANK_FOLDER_NAME : FilenameUtils.filterName((String)element);
    }

    private Set<PathWrapper> _getAllPaths(List<Set<String>> pathElements) {
        Set<PathWrapper> allPaths = new HashSet<PathWrapper>();
        allPaths.add(null);
        for (Set<String> possibleElements : pathElements) {
            allPaths = this._getAllPathsInCurrentLevel(possibleElements, allPaths);
        }
        return allPaths;
    }

    private Set<PathWrapper> _getAllPathsInCurrentLevel(Set<String> possibleElementsInCurrentLevel, Set<PathWrapper> computedPathsInPreviousLevel) {
        HashSet<PathWrapper> paths = new HashSet<PathWrapper>();
        for (PathWrapper computedPathInPreviousLevel : computedPathsInPreviousLevel) {
            for (String possibleElement : possibleElementsInCurrentLevel) {
                ArrayList<String> pathInCurrentLevel = computedPathInPreviousLevel == null ? new ArrayList<String>() : new ArrayList<String>(computedPathInPreviousLevel.getElements());
                pathInCurrentLevel.add(possibleElement);
                paths.add(new PathWrapper(pathInCurrentLevel));
            }
        }
        return paths;
    }

    private Map<PathWrapper, List<Content>> _contentsByPath(Map<Content, Set<PathWrapper>> pathByContent) {
        HashMap<PathWrapper, List<Content>> contentsByPath = new HashMap<PathWrapper, List<Content>>();
        for (Content content : pathByContent.keySet()) {
            Set<PathWrapper> paths = pathByContent.get(content);
            for (PathWrapper path : paths) {
                List<Content> contentsForPath;
                if (contentsByPath.containsKey(path)) {
                    contentsForPath = (List)contentsByPath.get(path);
                } else {
                    contentsForPath = new ArrayList();
                    contentsByPath.put(path, contentsForPath);
                }
                contentsForPath.add(content);
            }
        }
        return contentsByPath;
    }

    private static final class PathWrapper {
        private List<String> _pathElements;

        PathWrapper(List<String> pathElements) {
            this._pathElements = pathElements;
        }

        List<String> getElements() {
            return this._pathElements;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._pathElements == null ? 0 : this._pathElements.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof PathWrapper)) {
                return false;
            }
            PathWrapper other = (PathWrapper)obj;
            return !(this._pathElements == null ? other._pathElements != null : !this._pathElements.equals(other._pathElements));
        }

        public String toString() {
            return this._pathElements.toString();
        }
    }
}

