/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.extraction.component;

import java.util.List;
import java.util.Map;

import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.ContentHandler;

import org.ametys.cms.repository.Content;
import org.ametys.cms.search.cocoon.GroupSearchContent;
import org.ametys.plugins.extraction.ExtractionConstants;
import org.ametys.plugins.extraction.execution.ExtractionExecutionContext;
import org.ametys.runtime.model.ViewItemContainer;

/**
 * This class represents a count component of the extraction module
 */
public class CountExtractionComponent extends AbstractGroupExtractionComponent implements TwoStepsExecutingExtractionComponent
{
    @Override
    protected void processContents(Iterable<Content> contents, ContentHandler contentHandler, ExtractionExecutionContext context) throws Exception
    {
        XMLUtils.startElement(contentHandler, _tagName);
        
        GroupSearchContent rootGroup = organizeContentsInGroups(contents, context.getDefaultLocale());
        saxGroup(contentHandler, rootGroup, 0, context, null);
        
        XMLUtils.endElement(contentHandler, _tagName);
    }
    
    @Override
    public Iterable<Content> computeFirstLevelResults(ExtractionExecutionContext context) throws Exception
    {
        return getContents(context);
    }
    
    @Override
    public void executeFor(ContentHandler contentHandler, Iterable<Content> firstLevelResults, ExtractionExecutionContext context) throws Exception
    {
        processContents(firstLevelResults, contentHandler, context);
    }

    @Override
    protected void saxContents(ContentHandler contentHandler, ExtractionExecutionContext context, ViewItemContainer resultItems, List<Content> contents) throws Exception
    {
        XMLUtils.data(contentHandler, String.valueOf(contents.size()));
    }

    @Override
    public void addSubComponent(ExtractionComponent subComponent)
    {
        throw new UnsupportedOperationException(getLogsPrefix() + "a count component can't have sub components");
    }
    
    @Override
    public Map<String, Object> getComponentDetailsForTree()
    {
        Map<String, Object> details = super.getComponentDetailsForTree();
        details.put("tag", ExtractionConstants.COUNT_COMPONENT_TAG);
        details.put("iconCls", "ametysicon-abacus");
        return details;
    }

    @Override
    protected String getDefaultTagName()
    {
        return "count";
    }
    
    @Override
    protected String getLogsPrefix()
    {
        return "Count component '" + _tagName + "': ";
    }
}
