/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.extraction.execution;

import java.io.File;

import org.ametys.plugins.core.impl.enumerator.AbstractTraversableSourceEnumerator;
import org.ametys.plugins.extraction.ExtractionConstants;
import org.ametys.runtime.util.AmetysHomeHelper;

/**
 * Enumerator for extraction definition files
 */
public class ExtractionResultFilesEnumerator extends AbstractTraversableSourceEnumerator
{
    @Override
    protected String getLocation()
    {
        return new File(AmetysHomeHelper.getAmetysHomeData(), ExtractionConstants.RESULT_EXTRACTION_DIR_NAME).toURI().toString();
    }
}
