/*
 *  Copyright 2018 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.extraction.execution.pipeline;

import java.io.OutputStream;
import java.util.Map;

import javax.xml.transform.sax.TransformerHandler;

import org.ametys.plugins.extraction.execution.pipeline.impl.PipelineSerializer;

/**
 * A model which can provide a {@link PipelineSerializer} with {@link #newSerializer} method.
 */
public interface PipelineSerializerModel
{
    /**
     * Gets the default extension of the file result
     * @return the default extension of the file result
     */
    String getDefaultFileExtension();
    
    /**
     * Provides a new {@link PipelineSerializer}
     * @param handler The content handler
     * @param out The output stream to write on
     * @param outputParameters The output parameters for additional configuration 
     * @return the built {@link PipelineSerializer}
     */
    PipelineSerializer newSerializer(TransformerHandler handler, OutputStream out, Map<String, String> outputParameters);
}
